/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import proguard.MemberSpecification;
import proguard.MemberValueSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class MemberSpecificationElement
extends DataType {
    private String access;
    private String annotation;
    private String type;
    private String name;
    private String parameters;
    private String values;

    public void appendTo(List memberSpecifications, boolean isMethod, boolean isConstructor) {
        MemberSpecificationElement memberSpecificationElement = this.isReference() ? (MemberSpecificationElement)this.getCheckedRef(this.getClass(), this.getClass().getName()) : this;
        String access = memberSpecificationElement.access;
        String type = memberSpecificationElement.type;
        String annotation = memberSpecificationElement.annotation;
        String name = memberSpecificationElement.name;
        String parameters = memberSpecificationElement.parameters;
        String values2 = memberSpecificationElement.values;
        if (annotation != null) {
            annotation = ClassUtil.internalType(annotation);
        }
        if (isMethod) {
            if (isConstructor) {
                if (type != null) {
                    throw new BuildException("Type attribute not allowed in constructor specification [" + type + "]");
                }
                if (parameters != null) {
                    type = "void";
                }
                if (values2 != null) {
                    throw new BuildException("Values attribute not allowed in constructor specification [" + values2 + "]");
                }
                name = "<init>";
            } else if (type != null ^ parameters != null) {
                throw new BuildException("Type and parameters attributes must always be present in combination in method specification");
            }
        } else if (parameters != null) {
            throw new BuildException("Parameters attribute not allowed in field specification [" + parameters + "]");
        }
        if (values2 != null && type == null) {
            throw new BuildException("Values attribute must be specified in combination with type attribute in class member specification [" + values2 + "]");
        }
        List parameterList = ListUtil.commaSeparatedList(parameters);
        String descriptor = parameters != null ? ClassUtil.internalMethodDescriptor(type, parameterList) : (type != null ? ClassUtil.internalType(type) : null);
        MemberSpecification memberSpecification = values2 != null ? new MemberValueSpecification(this.requiredAccessFlags(true, access), this.requiredAccessFlags(false, access), annotation, name, descriptor, this.parseValues(type, ClassUtil.internalType(type), values2)) : new MemberSpecification(this.requiredAccessFlags(true, access), this.requiredAccessFlags(false, access), annotation, name, descriptor);
        memberSpecifications.add(memberSpecification);
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public void setParam(String parameters) {
        this.parameters = parameters;
    }

    public void setValues(String values2) {
        this.values = values2;
    }

    private int requiredAccessFlags(boolean set, String access) throws BuildException {
        int accessFlags = 0;
        if (access != null) {
            StringTokenizer tokenizer = new StringTokenizer(access, " ,");
            while (tokenizer.hasMoreTokens()) {
                int accessFlag;
                String strippedToken;
                String token = tokenizer.nextToken();
                if (!(token.startsWith("!") ^ set)) continue;
                String string = strippedToken = token.startsWith("!") ? token.substring(1) : token;
                int n = strippedToken.equals("public") ? 1 : (strippedToken.equals("private") ? 2 : (strippedToken.equals("protected") ? 4 : (strippedToken.equals("static") ? 8 : (strippedToken.equals("final") ? 16 : (strippedToken.equals("synchronized") ? 32 : (strippedToken.equals("volatile") ? 64 : (strippedToken.equals("transient") ? 128 : (strippedToken.equals("bridge") ? 64 : (strippedToken.equals("varargs") ? 128 : (strippedToken.equals("native") ? 256 : (strippedToken.equals("abstract") ? 1024 : (strippedToken.equals("strictfp") ? 2048 : (accessFlag = strippedToken.equals("synthetic") ? 4096 : 0)))))))))))));
                if (accessFlag == 0) {
                    throw new BuildException("Incorrect class member access modifier [" + strippedToken + "]");
                }
                accessFlags |= accessFlag;
            }
        }
        return accessFlags;
    }

    private Number[] parseValues(String externalType, String internalType, String string) throws BuildException {
        Number[] numberArray;
        int rangeIndex = string.lastIndexOf("..");
        if (rangeIndex >= 0) {
            Number[] numberArray2 = new Number[2];
            numberArray2[0] = this.parseValue(externalType, internalType, string.substring(0, rangeIndex));
            numberArray = numberArray2;
            numberArray2[1] = this.parseValue(externalType, internalType, string.substring(rangeIndex + 2));
        } else {
            Number[] numberArray3 = new Number[1];
            numberArray = numberArray3;
            numberArray3[0] = this.parseValue(externalType, internalType, string);
        }
        return numberArray;
    }

    private Number parseValue(String externalType, String internalType, String string) throws BuildException {
        try {
            switch (internalType.charAt(0)) {
                case 'Z': {
                    return this.parseBoolean(string);
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': {
                    return Integer.decode(string);
                }
            }
            throw new BuildException("Can't handle '" + externalType + "' constant [" + string + "]");
        }
        catch (NumberFormatException e) {
            throw new BuildException("Can't parse " + externalType + " constant [" + string + "]");
        }
    }

    private Integer parseBoolean(String string) throws BuildException {
        if ("false".equals(string)) {
            return 0;
        }
        if ("true".equals(string)) {
            return 1;
        }
        throw new BuildException("Unknown boolean constant [" + string + "]");
    }
}

