/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import proguard.ClassPath;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ant.ClassPathElement;
import proguard.ant.ClassSpecificationElement;
import proguard.ant.ConfigurationElement;
import proguard.ant.FilterElement;
import proguard.ant.KeepSpecificationElement;

public class ConfigurationTask
extends Task {
    protected final Configuration configuration = new Configuration();

    public void appendTo(Configuration configuration) {
        configuration.programJars = this.extendClassPath(configuration.programJars, this.configuration.programJars);
        configuration.libraryJars = this.extendClassPath(configuration.libraryJars, this.configuration.libraryJars);
        configuration.keep = this.extendClassSpecifications(configuration.keep, this.configuration.keep);
        configuration.keepDirectories = this.extendList(configuration.keepDirectories, this.configuration.keepDirectories);
        configuration.whyAreYouKeeping = this.extendClassSpecifications(configuration.whyAreYouKeeping, this.configuration.whyAreYouKeeping);
        configuration.optimizations = this.extendClassSpecifications(configuration.optimizations, this.configuration.optimizations);
        configuration.assumeNoSideEffects = this.extendClassSpecifications(configuration.assumeNoSideEffects, this.configuration.assumeNoSideEffects);
        configuration.assumeNoExternalSideEffects = this.extendClassSpecifications(configuration.assumeNoExternalSideEffects, this.configuration.assumeNoExternalSideEffects);
        configuration.assumeNoEscapingParameters = this.extendClassSpecifications(configuration.assumeNoEscapingParameters, this.configuration.assumeNoEscapingParameters);
        configuration.assumeNoExternalReturnValues = this.extendClassSpecifications(configuration.assumeNoExternalReturnValues, this.configuration.assumeNoExternalReturnValues);
        configuration.assumeValues = this.extendClassSpecifications(configuration.assumeValues, this.configuration.assumeValues);
        configuration.keepPackageNames = this.extendList(configuration.keepPackageNames, this.configuration.keepPackageNames);
        configuration.keepAttributes = this.extendList(configuration.keepAttributes, this.configuration.keepAttributes);
        configuration.adaptClassStrings = this.extendList(configuration.adaptClassStrings, this.configuration.adaptClassStrings);
        configuration.adaptResourceFileNames = this.extendList(configuration.adaptResourceFileNames, this.configuration.adaptResourceFileNames);
        configuration.adaptResourceFileContents = this.extendList(configuration.adaptResourceFileContents, this.configuration.adaptResourceFileContents);
        configuration.note = this.extendList(configuration.note, this.configuration.note);
        configuration.warn = this.extendList(configuration.warn, this.configuration.warn);
    }

    public void addConfiguredInjar(ClassPathElement classPathElement) {
        this.configuration.programJars = this.extendClassPath(this.configuration.programJars, classPathElement, false);
    }

    public void addConfiguredOutjar(ClassPathElement classPathElement) {
        this.configuration.programJars = this.extendClassPath(this.configuration.programJars, classPathElement, true);
    }

    public void addConfiguredLibraryjar(ClassPathElement classPathElement) {
        this.configuration.libraryJars = this.extendClassPath(this.configuration.libraryJars, classPathElement, false);
    }

    public void addConfiguredKeepdirectory(FilterElement filterElement) {
        this.configuration.keepDirectories = this.extendFilter(this.configuration.keepDirectories, filterElement);
    }

    public void addConfiguredKeepdirectories(FilterElement filterElement) {
        this.configuration.keepDirectories = this.extendFilter(this.configuration.keepDirectories, filterElement);
    }

    public void addConfiguredKeep(KeepSpecificationElement keepSpecificationElement) {
        this.configuration.keep = this.extendKeepSpecifications(this.configuration.keep, keepSpecificationElement, true, true, false);
    }

    public void addConfiguredKeepclassmembers(KeepSpecificationElement keepSpecificationElement) {
        this.configuration.keep = this.extendKeepSpecifications(this.configuration.keep, keepSpecificationElement, false, true, false);
    }

    public void addConfiguredKeepclasseswithmembers(KeepSpecificationElement keepSpecificationElement) {
        this.configuration.keep = this.extendKeepSpecifications(this.configuration.keep, keepSpecificationElement, true, true, true);
    }

    public void addConfiguredKeepnames(KeepSpecificationElement keepSpecificationElement) {
        keepSpecificationElement.setAllowshrinking(true);
        this.configuration.keep = this.extendKeepSpecifications(this.configuration.keep, keepSpecificationElement, true, true, false);
    }

    public void addConfiguredKeepclassmembernames(KeepSpecificationElement keepSpecificationElement) {
        keepSpecificationElement.setAllowshrinking(true);
        this.configuration.keep = this.extendKeepSpecifications(this.configuration.keep, keepSpecificationElement, false, true, false);
    }

    public void addConfiguredKeepclasseswithmembernames(KeepSpecificationElement keepSpecificationElement) {
        keepSpecificationElement.setAllowshrinking(true);
        this.configuration.keep = this.extendKeepSpecifications(this.configuration.keep, keepSpecificationElement, true, true, true);
    }

    public void addConfiguredWhyareyoukeeping(ClassSpecificationElement classSpecificationElement) {
        this.configuration.whyAreYouKeeping = this.extendClassSpecifications(this.configuration.whyAreYouKeeping, classSpecificationElement);
    }

    public void addConfiguredAssumenosideeffects(ClassSpecificationElement classSpecificationElement) {
        this.configuration.assumeNoSideEffects = this.extendClassSpecifications(this.configuration.assumeNoSideEffects, classSpecificationElement);
    }

    public void addConfiguredAssumenoexternalsideeffects(ClassSpecificationElement classSpecificationElement) {
        this.configuration.assumeNoExternalSideEffects = this.extendClassSpecifications(this.configuration.assumeNoExternalSideEffects, classSpecificationElement);
    }

    public void addConfiguredAssumenoescapingparameters(ClassSpecificationElement classSpecificationElement) {
        this.configuration.assumeNoEscapingParameters = this.extendClassSpecifications(this.configuration.assumeNoEscapingParameters, classSpecificationElement);
    }

    public void addConfiguredAssumenoexternalreturnvalues(ClassSpecificationElement classSpecificationElement) {
        this.configuration.assumeNoExternalReturnValues = this.extendClassSpecifications(this.configuration.assumeNoExternalReturnValues, classSpecificationElement);
    }

    public void addConfiguredAssumevalues(ClassSpecificationElement classSpecificationElement) {
        this.configuration.assumeValues = this.extendClassSpecifications(this.configuration.assumeValues, classSpecificationElement);
    }

    public void addConfiguredOptimizations(FilterElement filterElement) {
        this.addConfiguredOptimization(filterElement);
    }

    public void addConfiguredOptimization(FilterElement filterElement) {
        this.configuration.optimizations = this.extendFilter(this.configuration.optimizations, filterElement);
    }

    public void addConfiguredKeeppackagename(FilterElement filterElement) {
        this.configuration.keepPackageNames = this.extendFilter(this.configuration.keepPackageNames, filterElement, true);
    }

    public void addConfiguredKeeppackagenames(FilterElement filterElement) {
        this.configuration.keepPackageNames = this.extendFilter(this.configuration.keepPackageNames, filterElement, true);
    }

    public void addConfiguredKeepattributes(FilterElement filterElement) {
        this.addConfiguredKeepattribute(filterElement);
    }

    public void addConfiguredKeepattribute(FilterElement filterElement) {
        this.configuration.keepAttributes = this.extendFilter(this.configuration.keepAttributes, filterElement);
    }

    public void addConfiguredAdaptclassstrings(FilterElement filterElement) {
        this.configuration.adaptClassStrings = this.extendFilter(this.configuration.adaptClassStrings, filterElement, true);
    }

    public void addConfiguredAdaptresourcefilenames(FilterElement filterElement) {
        this.configuration.adaptResourceFileNames = this.extendFilter(this.configuration.adaptResourceFileNames, filterElement);
    }

    public void addConfiguredAdaptresourcefilecontents(FilterElement filterElement) {
        this.configuration.adaptResourceFileContents = this.extendFilter(this.configuration.adaptResourceFileContents, filterElement);
    }

    public void addConfiguredDontnote(FilterElement filterElement) {
        this.configuration.note = this.extendFilter(this.configuration.note, filterElement, true);
    }

    public void addConfiguredDontwarn(FilterElement filterElement) {
        this.configuration.warn = this.extendFilter(this.configuration.warn, filterElement, true);
    }

    public void addConfiguredConfiguration(ConfigurationElement configurationElement) {
        configurationElement.appendTo(this.configuration);
    }

    public void addText(String text) throws BuildException {
        try {
            Project project = this.getProject();
            String arg = project.replaceProperties(text);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)project.getProperties());
            try (ConfigurationParser parser = new ConfigurationParser(arg, "embedded configuration", project.getBaseDir(), properties);){
                parser.parse(this.configuration);
            }
        }
        catch (IOException ex) {
            throw new BuildException(ex.getMessage());
        }
    }

    private ClassPath extendClassPath(ClassPath classPath, ClassPathElement classPathElement, boolean output) {
        if (classPath == null) {
            classPath = new ClassPath();
        }
        classPathElement.appendClassPathEntriesTo(classPath, output);
        return classPath;
    }

    private ClassPath extendClassPath(ClassPath classPath, ClassPath additionalClassPath) {
        if (additionalClassPath != null) {
            if (classPath == null) {
                classPath = new ClassPath();
            }
            classPath.addAll(additionalClassPath);
        }
        return classPath;
    }

    private List extendKeepSpecifications(List keepSpecifications, KeepSpecificationElement keepSpecificationElement, boolean markClasses, boolean markClassMembers, boolean markClassesConditionally) {
        if (keepSpecifications == null) {
            keepSpecifications = new ArrayList();
        }
        keepSpecificationElement.appendTo(keepSpecifications, markClasses, markClassMembers, markClassesConditionally);
        return keepSpecifications;
    }

    private List extendClassSpecifications(List classSpecifications, ClassSpecificationElement classSpecificationElement) {
        if (classSpecifications == null) {
            classSpecifications = new ArrayList();
        }
        classSpecificationElement.appendTo(classSpecifications);
        return classSpecifications;
    }

    private List extendClassSpecifications(List classSpecifications, List additionalClassSpecifications) {
        if (additionalClassSpecifications != null) {
            if (classSpecifications == null) {
                classSpecifications = new ArrayList();
            }
            classSpecifications.addAll(additionalClassSpecifications);
        }
        return classSpecifications;
    }

    private List extendFilter(List filter, FilterElement filterElement) {
        return this.extendFilter(filter, filterElement, false);
    }

    private List extendFilter(List filter, FilterElement filterElement, boolean internal) {
        if (filter == null) {
            filter = new ArrayList();
        }
        filterElement.appendTo(filter, internal);
        return filter;
    }

    private List extendList(List list, List additionalList) {
        if (additionalList != null) {
            if (list == null) {
                list = new ArrayList();
            }
            list.addAll(additionalList);
        }
        return list;
    }
}

