/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.VariableCleaner;
import proguard.classfile.editor.VariableRemapper;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.evaluation.LivenessAnalyzer;

public class VariableOptimizer
extends SimplifiedVisitor
implements AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private static final boolean DEBUG = false;
    private static final int MAX_VARIABLES_SIZE = 64;
    private final boolean reuseThis;
    private final MemberVisitor extraVariableMemberVisitor;
    private final LivenessAnalyzer livenessAnalyzer = new LivenessAnalyzer();
    private final VariableRemapper variableRemapper = new VariableRemapper();
    private VariableCleaner variableCleaner = new VariableCleaner();
    private int[] variableMap = new int[64];

    public VariableOptimizer(boolean bl) {
        this(bl, null);
    }

    public VariableOptimizer(boolean bl, MemberVisitor memberVisitor) {
        this.reuseThis = bl;
        this.extraVariableMemberVisitor = memberVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.initializeArrays(codeAttribute);
        this.livenessAnalyzer.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.attributesAccept(clazz, method, this);
        int n = (method.getAccessFlags() & 8) != 0 || this.reuseThis ? 0 : 1;
        int n2 = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        int n3 = codeAttribute.u2maxLocals;
        int n4 = codeAttribute.u4codeLength;
        boolean bl = false;
        block0: for (int i = 0; i < n3; ++i) {
            this.variableMap[i] = i;
            if (i < n2 || i >= 64) continue;
            for (int j = n; j < i; ++j) {
                if (!this.areNonOverlapping(i, j, n4)) continue;
                this.variableMap[i] = j;
                this.updateLiveness(i, j, n4);
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            this.variableRemapper.setVariableMap(this.variableMap);
            this.variableRemapper.visitCodeAttribute(clazz, method, codeAttribute);
            if (this.extraVariableMemberVisitor != null) {
                method.accept(clazz, this.extraVariableMemberVisitor);
            }
        } else {
            this.variableCleaner.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        int n = localVariableInfo.u2index;
        int n2 = localVariableInfo.u2startPC;
        int n3 = n2 + localVariableInfo.u2length;
        n2 = this.firstLiveness(n2, n3, n);
        n3 = this.lastLiveness(n2, n3, n);
        localVariableInfo.u2startPC = n2;
        localVariableInfo.u2length = n3 - n2;
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        int n = localVariableTypeInfo.u2index;
        int n2 = localVariableTypeInfo.u2startPC;
        int n3 = n2 + localVariableTypeInfo.u2length;
        n2 = this.firstLiveness(n2, n3, n);
        n3 = this.lastLiveness(n2, n3, n);
        localVariableTypeInfo.u2startPC = n2;
        localVariableTypeInfo.u2length = n3 - n2;
    }

    private void initializeArrays(CodeAttribute codeAttribute) {
        int n = codeAttribute.u4codeLength;
        if (this.variableMap.length < n) {
            this.variableMap = new int[n];
        }
    }

    private boolean areNonOverlapping(int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (!(this.livenessAnalyzer.isAliveBefore(i, n) && this.livenessAnalyzer.isAliveBefore(i, n2) || this.livenessAnalyzer.isAliveAfter(i, n) && this.livenessAnalyzer.isAliveAfter(i, n2)) && !this.livenessAnalyzer.isCategory2(i, n)) continue;
            return false;
        }
        return true;
    }

    private void updateLiveness(int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (this.livenessAnalyzer.isAliveBefore(i, n)) {
                this.livenessAnalyzer.setAliveBefore(i, n, false);
                this.livenessAnalyzer.setAliveBefore(i, n2, true);
            }
            if (!this.livenessAnalyzer.isAliveAfter(i, n)) continue;
            this.livenessAnalyzer.setAliveAfter(i, n, false);
            this.livenessAnalyzer.setAliveAfter(i, n2, true);
        }
    }

    private int firstLiveness(int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            if (!this.livenessAnalyzer.isTraced(i) || !this.livenessAnalyzer.isAliveBefore(i, n3)) continue;
            return i;
        }
        return n2;
    }

    private int lastLiveness(int n, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 - 1; i >= n; --i) {
            if (!this.livenessAnalyzer.isTraced(i)) continue;
            if (this.livenessAnalyzer.isAliveBefore(i, n3)) {
                return n4;
            }
            n4 = i;
        }
        return n2;
    }
}

