/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.Arrays;

public class BufferingOutputStream
extends OutputStream {
    private final OutputStream other;
    private final byte[] buf;
    private int bufOff;

    public BufferingOutputStream(OutputStream outputStream) {
        this.other = outputStream;
        this.buf = new byte[4096];
    }

    public BufferingOutputStream(OutputStream outputStream, int n4) {
        this.other = outputStream;
        this.buf = new byte[n4];
    }

    public void write(byte[] byArray, int n4, int n5) throws IOException {
        if (n5 < this.buf.length - this.bufOff) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
            this.bufOff += n5;
        } else {
            int n6 = this.buf.length - this.bufOff;
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n6);
            this.bufOff += n6;
            this.flush();
            n4 += n6;
            n5 -= n6;
            while (n5 >= this.buf.length) {
                this.other.write(byArray, n4, this.buf.length);
                n4 += this.buf.length;
                n5 -= this.buf.length;
            }
            if (n5 > 0) {
                System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
                this.bufOff += n5;
            }
        }
    }

    public void write(int n4) throws IOException {
        this.buf[this.bufOff++] = (byte)n4;
        if (this.bufOff == this.buf.length) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        this.other.write(this.buf, 0, this.bufOff);
        this.bufOff = 0;
        Arrays.fill(this.buf, (byte)0);
    }

    public void close() throws IOException {
        this.flush();
        this.other.close();
    }
}

