/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

public abstract class Pack {
    public static short bigEndianToShort(byte[] byArray, int n4) {
        int n5 = (byArray[n4] & 0xFF) << 8;
        return (short)(n5 |= byArray[++n4] & 0xFF);
    }

    public static int bigEndianToInt(byte[] byArray, int n4) {
        int n5 = byArray[n4] << 24;
        n5 |= (byArray[++n4] & 0xFF) << 16;
        n5 |= (byArray[++n4] & 0xFF) << 8;
        return n5 |= byArray[++n4] & 0xFF;
    }

    public static void bigEndianToInt(byte[] byArray, int n4, int[] nArray) {
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            nArray[i4] = Pack.bigEndianToInt(byArray, n4);
            n4 += 4;
        }
    }

    public static byte[] intToBigEndian(int n4) {
        byte[] byArray = new byte[4];
        Pack.intToBigEndian(n4, byArray, 0);
        return byArray;
    }

    public static void intToBigEndian(int n4, byte[] byArray, int n5) {
        byArray[n5] = (byte)(n4 >>> 24);
        byArray[++n5] = (byte)(n4 >>> 16);
        byArray[++n5] = (byte)(n4 >>> 8);
        byArray[++n5] = (byte)n4;
    }

    public static byte[] intToBigEndian(int[] nArray) {
        byte[] byArray = new byte[4 * nArray.length];
        Pack.intToBigEndian(nArray, byArray, 0);
        return byArray;
    }

    public static void intToBigEndian(int[] nArray, byte[] byArray, int n4) {
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            Pack.intToBigEndian(nArray[i4], byArray, n4);
            n4 += 4;
        }
    }

    public static long bigEndianToLong(byte[] byArray, int n4) {
        int n5 = Pack.bigEndianToInt(byArray, n4);
        int n6 = Pack.bigEndianToInt(byArray, n4 + 4);
        return ((long)n5 & 0xFFFFFFFFL) << 32 | (long)n6 & 0xFFFFFFFFL;
    }

    public static void bigEndianToLong(byte[] byArray, int n4, long[] lArray) {
        for (int i4 = 0; i4 < lArray.length; ++i4) {
            lArray[i4] = Pack.bigEndianToLong(byArray, n4);
            n4 += 8;
        }
    }

    public static byte[] longToBigEndian(long l4) {
        byte[] byArray = new byte[8];
        Pack.longToBigEndian(l4, byArray, 0);
        return byArray;
    }

    public static void longToBigEndian(long l4, byte[] byArray, int n4) {
        Pack.intToBigEndian((int)(l4 >>> 32), byArray, n4);
        Pack.intToBigEndian((int)(l4 & 0xFFFFFFFFL), byArray, n4 + 4);
    }

    public static byte[] longToBigEndian(long[] lArray) {
        byte[] byArray = new byte[8 * lArray.length];
        Pack.longToBigEndian(lArray, byArray, 0);
        return byArray;
    }

    public static void longToBigEndian(long[] lArray, byte[] byArray, int n4) {
        for (int i4 = 0; i4 < lArray.length; ++i4) {
            Pack.longToBigEndian(lArray[i4], byArray, n4);
            n4 += 8;
        }
    }

    public static short littleEndianToShort(byte[] byArray, int n4) {
        int n5 = byArray[n4] & 0xFF;
        return (short)(n5 |= (byArray[++n4] & 0xFF) << 8);
    }

    public static int littleEndianToInt(byte[] byArray, int n4) {
        int n5 = byArray[n4] & 0xFF;
        n5 |= (byArray[++n4] & 0xFF) << 8;
        n5 |= (byArray[++n4] & 0xFF) << 16;
        return n5 |= byArray[++n4] << 24;
    }

    public static void littleEndianToInt(byte[] byArray, int n4, int[] nArray) {
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            nArray[i4] = Pack.littleEndianToInt(byArray, n4);
            n4 += 4;
        }
    }

    public static void littleEndianToInt(byte[] byArray, int n4, int[] nArray, int n5, int n6) {
        for (int i4 = 0; i4 < n6; ++i4) {
            nArray[n5 + i4] = Pack.littleEndianToInt(byArray, n4);
            n4 += 4;
        }
    }

    public static int[] littleEndianToInt(byte[] byArray, int n4, int n5) {
        int[] nArray = new int[n5];
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            nArray[i4] = Pack.littleEndianToInt(byArray, n4);
            n4 += 4;
        }
        return nArray;
    }

    public static byte[] shortToLittleEndian(short s4) {
        byte[] byArray = new byte[2];
        Pack.shortToLittleEndian(s4, byArray, 0);
        return byArray;
    }

    public static void shortToLittleEndian(short s4, byte[] byArray, int n4) {
        byArray[n4] = (byte)s4;
        byArray[++n4] = (byte)(s4 >>> 8);
    }

    public static byte[] intToLittleEndian(int n4) {
        byte[] byArray = new byte[4];
        Pack.intToLittleEndian(n4, byArray, 0);
        return byArray;
    }

    public static void intToLittleEndian(int n4, byte[] byArray, int n5) {
        byArray[n5] = (byte)n4;
        byArray[++n5] = (byte)(n4 >>> 8);
        byArray[++n5] = (byte)(n4 >>> 16);
        byArray[++n5] = (byte)(n4 >>> 24);
    }

    public static byte[] intToLittleEndian(int[] nArray) {
        byte[] byArray = new byte[4 * nArray.length];
        Pack.intToLittleEndian(nArray, byArray, 0);
        return byArray;
    }

    public static void intToLittleEndian(int[] nArray, byte[] byArray, int n4) {
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            Pack.intToLittleEndian(nArray[i4], byArray, n4);
            n4 += 4;
        }
    }

    public static long littleEndianToLong(byte[] byArray, int n4) {
        int n5 = Pack.littleEndianToInt(byArray, n4);
        int n6 = Pack.littleEndianToInt(byArray, n4 + 4);
        return ((long)n6 & 0xFFFFFFFFL) << 32 | (long)n5 & 0xFFFFFFFFL;
    }

    public static void littleEndianToLong(byte[] byArray, int n4, long[] lArray) {
        for (int i4 = 0; i4 < lArray.length; ++i4) {
            lArray[i4] = Pack.littleEndianToLong(byArray, n4);
            n4 += 8;
        }
    }

    public static byte[] longToLittleEndian(long l4) {
        byte[] byArray = new byte[8];
        Pack.longToLittleEndian(l4, byArray, 0);
        return byArray;
    }

    public static void longToLittleEndian(long l4, byte[] byArray, int n4) {
        Pack.intToLittleEndian((int)(l4 & 0xFFFFFFFFL), byArray, n4);
        Pack.intToLittleEndian((int)(l4 >>> 32), byArray, n4 + 4);
    }

    public static byte[] longToLittleEndian(long[] lArray) {
        byte[] byArray = new byte[8 * lArray.length];
        Pack.longToLittleEndian(lArray, byArray, 0);
        return byArray;
    }

    public static void longToLittleEndian(long[] lArray, byte[] byArray, int n4) {
        for (int i4 = 0; i4 < lArray.length; ++i4) {
            Pack.longToLittleEndian(lArray[i4], byArray, n4);
            n4 += 8;
        }
    }
}

