/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.math.BigInteger;
import java.util.NoSuchElementException;

public final class Arrays {
    private Arrays() {
    }

    public static boolean areEqual(boolean[] blArray, boolean[] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (blArray == null || blArray2 == null) {
            return false;
        }
        if (blArray.length != blArray2.length) {
            return false;
        }
        for (int i4 = 0; i4 != blArray.length; ++i4) {
            if (blArray[i4] == blArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        if (cArray.length != cArray2.length) {
            return false;
        }
        for (int i4 = 0; i4 != cArray.length; ++i4) {
            if (cArray[i4] == cArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i4 = 0; i4 != byArray.length; ++i4) {
            if (byArray[i4] == byArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(short[] sArray, short[] sArray2) {
        if (sArray == sArray2) {
            return true;
        }
        if (sArray == null || sArray2 == null) {
            return false;
        }
        if (sArray.length != sArray2.length) {
            return false;
        }
        for (int i4 = 0; i4 != sArray.length; ++i4) {
            if (sArray[i4] == sArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static boolean constantTimeAreEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n4 = 0;
        for (int i4 = 0; i4 != byArray.length; ++i4) {
            n4 |= byArray[i4] ^ byArray2[i4];
        }
        return n4 == 0;
    }

    public static boolean areEqual(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i4 = 0; i4 != nArray.length; ++i4) {
            if (nArray[i4] == nArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (lArray == null || lArray2 == null) {
            return false;
        }
        if (lArray.length != lArray2.length) {
            return false;
        }
        for (int i4 = 0; i4 != lArray.length; ++i4) {
            if (lArray[i4] == lArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i4 = 0; i4 != objectArray.length; ++i4) {
            Object object = objectArray[i4];
            Object object2 = objectArray2[i4];
            if (!(object == null ? object2 != null : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    public static int compareUnsigned(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        if (byArray == null) {
            return -1;
        }
        if (byArray2 == null) {
            return 1;
        }
        int n4 = Math.min(byArray.length, byArray2.length);
        for (int i4 = 0; i4 < n4; ++i4) {
            int n5 = byArray[i4] & 0xFF;
            int n6 = byArray2[i4] & 0xFF;
            if (n5 < n6) {
                return -1;
            }
            if (n5 <= n6) continue;
            return 1;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        if (byArray.length > byArray2.length) {
            return 1;
        }
        return 0;
    }

    public static boolean contains(short[] sArray, short s4) {
        for (int i4 = 0; i4 < sArray.length; ++i4) {
            if (sArray[i4] != s4) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] nArray, int n4) {
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            if (nArray[i4] != n4) continue;
            return true;
        }
        return false;
    }

    public static void fill(byte[] byArray, byte by) {
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            byArray[i4] = by;
        }
    }

    public static void fill(char[] cArray, char c4) {
        for (int i4 = 0; i4 < cArray.length; ++i4) {
            cArray[i4] = c4;
        }
    }

    public static void fill(long[] lArray, long l4) {
        for (int i4 = 0; i4 < lArray.length; ++i4) {
            lArray[i4] = l4;
        }
    }

    public static void fill(short[] sArray, short s4) {
        for (int i4 = 0; i4 < sArray.length; ++i4) {
            sArray[i4] = s4;
        }
    }

    public static void fill(int[] nArray, int n4) {
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            nArray[i4] = n4;
        }
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n4 = byArray.length;
        int n5 = n4 + 1;
        while (--n4 >= 0) {
            n5 *= 257;
            n5 ^= byArray[n4];
        }
        return n5;
    }

    public static int hashCode(byte[] byArray, int n4, int n5) {
        if (byArray == null) {
            return 0;
        }
        int n6 = n5;
        int n7 = n6 + 1;
        while (--n6 >= 0) {
            n7 *= 257;
            n7 ^= byArray[n4 + n6];
        }
        return n7;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n4 = cArray.length;
        int n5 = n4 + 1;
        while (--n4 >= 0) {
            n5 *= 257;
            n5 ^= cArray[n4];
        }
        return n5;
    }

    public static int hashCode(int[][] nArray) {
        int n4 = 0;
        for (int i4 = 0; i4 != nArray.length; ++i4) {
            n4 = n4 * 257 + Arrays.hashCode(nArray[i4]);
        }
        return n4;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n4 = nArray.length;
        int n5 = n4 + 1;
        while (--n4 >= 0) {
            n5 *= 257;
            n5 ^= nArray[n4];
        }
        return n5;
    }

    public static int hashCode(int[] nArray, int n4, int n5) {
        if (nArray == null) {
            return 0;
        }
        int n6 = n5;
        int n7 = n6 + 1;
        while (--n6 >= 0) {
            n7 *= 257;
            n7 ^= nArray[n4 + n6];
        }
        return n7;
    }

    public static int hashCode(long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n4 = lArray.length;
        int n5 = n4 + 1;
        while (--n4 >= 0) {
            long l4 = lArray[n4];
            n5 *= 257;
            n5 ^= (int)l4;
            n5 *= 257;
            n5 ^= (int)(l4 >>> 32);
        }
        return n5;
    }

    public static int hashCode(long[] lArray, int n4, int n5) {
        if (lArray == null) {
            return 0;
        }
        int n6 = n5;
        int n7 = n6 + 1;
        while (--n6 >= 0) {
            long l4 = lArray[n4 + n6];
            n7 *= 257;
            n7 ^= (int)l4;
            n7 *= 257;
            n7 ^= (int)(l4 >>> 32);
        }
        return n7;
    }

    public static int hashCode(short[][][] sArray) {
        int n4 = 0;
        for (int i4 = 0; i4 != sArray.length; ++i4) {
            n4 = n4 * 257 + Arrays.hashCode(sArray[i4]);
        }
        return n4;
    }

    public static int hashCode(short[][] sArray) {
        int n4 = 0;
        for (int i4 = 0; i4 != sArray.length; ++i4) {
            n4 = n4 * 257 + Arrays.hashCode(sArray[i4]);
        }
        return n4;
    }

    public static int hashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n4 = sArray.length;
        int n5 = n4 + 1;
        while (--n4 >= 0) {
            n5 *= 257;
            n5 ^= sArray[n4] & 0xFF;
        }
        return n5;
    }

    public static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n4 = objectArray.length;
        int n5 = n4 + 1;
        while (--n4 >= 0) {
            n5 *= 257;
            n5 ^= objectArray[n4].hashCode();
        }
        return n5;
    }

    public static byte[] clone(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static char[] clone(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    public static byte[] clone(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return null;
        }
        if (byArray2 == null || byArray2.length != byArray.length) {
            return Arrays.clone(byArray);
        }
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static byte[][] clone(byte[][] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[byArray.length][];
        for (int i4 = 0; i4 != byArrayArray.length; ++i4) {
            byArrayArray[i4] = Arrays.clone(byArray[i4]);
        }
        return byArrayArray;
    }

    public static byte[][][] clone(byte[][][] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[][][] byArrayArray = new byte[byArray.length][][];
        for (int i4 = 0; i4 != byArrayArray.length; ++i4) {
            byArrayArray[i4] = Arrays.clone(byArray[i4]);
        }
        return byArrayArray;
    }

    public static int[] clone(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static long[] clone(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        long[] lArray2 = new long[lArray.length];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        return lArray2;
    }

    public static long[] clone(long[] lArray, long[] lArray2) {
        if (lArray == null) {
            return null;
        }
        if (lArray2 == null || lArray2.length != lArray.length) {
            return Arrays.clone(lArray);
        }
        System.arraycopy(lArray, 0, lArray2, 0, lArray2.length);
        return lArray2;
    }

    public static short[] clone(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        short[] sArray2 = new short[sArray.length];
        System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
        return sArray2;
    }

    public static BigInteger[] clone(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        BigInteger[] bigIntegerArray2 = new BigInteger[bigIntegerArray.length];
        System.arraycopy(bigIntegerArray, 0, bigIntegerArray2, 0, bigIntegerArray.length);
        return bigIntegerArray2;
    }

    public static byte[] copyOf(byte[] byArray, int n4) {
        byte[] byArray2 = new byte[n4];
        if (n4 < byArray.length) {
            System.arraycopy(byArray, 0, byArray2, 0, n4);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    public static char[] copyOf(char[] cArray, int n4) {
        char[] cArray2 = new char[n4];
        if (n4 < cArray.length) {
            System.arraycopy(cArray, 0, cArray2, 0, n4);
        } else {
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        }
        return cArray2;
    }

    public static int[] copyOf(int[] nArray, int n4) {
        int[] nArray2 = new int[n4];
        if (n4 < nArray.length) {
            System.arraycopy(nArray, 0, nArray2, 0, n4);
        } else {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        }
        return nArray2;
    }

    public static long[] copyOf(long[] lArray, int n4) {
        long[] lArray2 = new long[n4];
        if (n4 < lArray.length) {
            System.arraycopy(lArray, 0, lArray2, 0, n4);
        } else {
            System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        }
        return lArray2;
    }

    public static BigInteger[] copyOf(BigInteger[] bigIntegerArray, int n4) {
        BigInteger[] bigIntegerArray2 = new BigInteger[n4];
        if (n4 < bigIntegerArray.length) {
            System.arraycopy(bigIntegerArray, 0, bigIntegerArray2, 0, n4);
        } else {
            System.arraycopy(bigIntegerArray, 0, bigIntegerArray2, 0, bigIntegerArray.length);
        }
        return bigIntegerArray2;
    }

    public static byte[] copyOfRange(byte[] byArray, int n4, int n5) {
        int n6 = Arrays.getLength(n4, n5);
        byte[] byArray2 = new byte[n6];
        if (byArray.length - n4 < n6) {
            System.arraycopy(byArray, n4, byArray2, 0, byArray.length - n4);
        } else {
            System.arraycopy(byArray, n4, byArray2, 0, n6);
        }
        return byArray2;
    }

    public static int[] copyOfRange(int[] nArray, int n4, int n5) {
        int n6 = Arrays.getLength(n4, n5);
        int[] nArray2 = new int[n6];
        if (nArray.length - n4 < n6) {
            System.arraycopy(nArray, n4, nArray2, 0, nArray.length - n4);
        } else {
            System.arraycopy(nArray, n4, nArray2, 0, n6);
        }
        return nArray2;
    }

    public static long[] copyOfRange(long[] lArray, int n4, int n5) {
        int n6 = Arrays.getLength(n4, n5);
        long[] lArray2 = new long[n6];
        if (lArray.length - n4 < n6) {
            System.arraycopy(lArray, n4, lArray2, 0, lArray.length - n4);
        } else {
            System.arraycopy(lArray, n4, lArray2, 0, n6);
        }
        return lArray2;
    }

    public static BigInteger[] copyOfRange(BigInteger[] bigIntegerArray, int n4, int n5) {
        int n6 = Arrays.getLength(n4, n5);
        BigInteger[] bigIntegerArray2 = new BigInteger[n6];
        if (bigIntegerArray.length - n4 < n6) {
            System.arraycopy(bigIntegerArray, n4, bigIntegerArray2, 0, bigIntegerArray.length - n4);
        } else {
            System.arraycopy(bigIntegerArray, n4, bigIntegerArray2, 0, n6);
        }
        return bigIntegerArray2;
    }

    private static int getLength(int n4, int n5) {
        int n6 = n5 - n4;
        if (n6 < 0) {
            StringBuffer stringBuffer = new StringBuffer(n4);
            stringBuffer.append(" > ").append(n5);
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        return n6;
    }

    public static byte[] append(byte[] byArray, byte by) {
        if (byArray == null) {
            return new byte[]{by};
        }
        int n4 = byArray.length;
        byte[] byArray2 = new byte[n4 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        byArray2[n4] = by;
        return byArray2;
    }

    public static short[] append(short[] sArray, short s4) {
        if (sArray == null) {
            return new short[]{s4};
        }
        int n4 = sArray.length;
        short[] sArray2 = new short[n4 + 1];
        System.arraycopy(sArray, 0, sArray2, 0, n4);
        sArray2[n4] = s4;
        return sArray2;
    }

    public static int[] append(int[] nArray, int n4) {
        if (nArray == null) {
            return new int[]{n4};
        }
        int n5 = nArray.length;
        int[] nArray2 = new int[n5 + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n5);
        nArray2[n5] = n4;
        return nArray2;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray2 != null) {
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            return byArray3;
        }
        if (byArray2 != null) {
            return Arrays.clone(byArray2);
        }
        return Arrays.clone(byArray);
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray != null && byArray2 != null && byArray3 != null) {
            byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
            System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
            return byArray4;
        }
        if (byArray == null) {
            return Arrays.concatenate(byArray2, byArray3);
        }
        if (byArray2 == null) {
            return Arrays.concatenate(byArray, byArray3);
        }
        return Arrays.concatenate(byArray, byArray2);
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (byArray != null && byArray2 != null && byArray3 != null && byArray4 != null) {
            byte[] byArray5 = new byte[byArray.length + byArray2.length + byArray3.length + byArray4.length];
            System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray5, byArray.length, byArray2.length);
            System.arraycopy(byArray3, 0, byArray5, byArray.length + byArray2.length, byArray3.length);
            System.arraycopy(byArray4, 0, byArray5, byArray.length + byArray2.length + byArray3.length, byArray4.length);
            return byArray5;
        }
        if (byArray4 == null) {
            return Arrays.concatenate(byArray, byArray2, byArray3);
        }
        if (byArray3 == null) {
            return Arrays.concatenate(byArray, byArray2, byArray4);
        }
        if (byArray2 == null) {
            return Arrays.concatenate(byArray, byArray3, byArray4);
        }
        return Arrays.concatenate(byArray2, byArray3, byArray4);
    }

    public static byte[] concatenate(byte[][] byArray) {
        int n4 = 0;
        for (int i4 = 0; i4 != byArray.length; ++i4) {
            n4 += byArray[i4].length;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        for (int i5 = 0; i5 != byArray.length; ++i5) {
            System.arraycopy(byArray[i5], 0, byArray2, n5, byArray[i5].length);
            n5 += byArray[i5].length;
        }
        return byArray2;
    }

    public static int[] concatenate(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return Arrays.clone(nArray2);
        }
        if (nArray2 == null) {
            return Arrays.clone(nArray);
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static byte[] prepend(byte[] byArray, byte by) {
        if (byArray == null) {
            return new byte[]{by};
        }
        int n4 = byArray.length;
        byte[] byArray2 = new byte[n4 + 1];
        System.arraycopy(byArray, 0, byArray2, 1, n4);
        byArray2[0] = by;
        return byArray2;
    }

    public static short[] prepend(short[] sArray, short s4) {
        if (sArray == null) {
            return new short[]{s4};
        }
        int n4 = sArray.length;
        short[] sArray2 = new short[n4 + 1];
        System.arraycopy(sArray, 0, sArray2, 1, n4);
        sArray2[0] = s4;
        return sArray2;
    }

    public static int[] prepend(int[] nArray, int n4) {
        if (nArray == null) {
            return new int[]{n4};
        }
        int n5 = nArray.length;
        int[] nArray2 = new int[n5 + 1];
        System.arraycopy(nArray, 0, nArray2, 1, n5);
        nArray2[0] = n4;
        return nArray2;
    }

    public static byte[] reverse(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n4 = 0;
        int n5 = byArray.length;
        byte[] byArray2 = new byte[n5];
        while (--n5 >= 0) {
            byArray2[n5] = byArray[n4++];
        }
        return byArray2;
    }

    public static int[] reverse(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n4 = 0;
        int n5 = nArray.length;
        int[] nArray2 = new int[n5];
        while (--n5 >= 0) {
            nArray2[n5] = nArray[n4++];
        }
        return nArray2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Iterator<T>
    implements java.util.Iterator<T> {
        private final T[] dataArray;
        private int position = 0;

        public Iterator(T[] TArray) {
            this.dataArray = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.dataArray.length;
        }

        @Override
        public T next() {
            if (this.position == this.dataArray.length) {
                throw new NoSuchElementException("Out of elements: " + this.position);
            }
            return this.dataArray[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove element from an Array.");
        }
    }
}

