/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import org.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.pqc.math.linearalgebra.RandUtils;

public class Permutation {
    private int[] perm;

    public Permutation(int n4) {
        if (n4 <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n4];
        for (int i4 = n4 - 1; i4 >= 0; --i4) {
            this.perm[i4] = i4;
        }
    }

    public Permutation(int[] nArray) {
        if (!this.isPermutation(nArray)) {
            throw new IllegalArgumentException("array is not a permutation vector");
        }
        this.perm = IntUtils.clone(nArray);
    }

    public Permutation(byte[] byArray) {
        int n4;
        if (byArray.length <= 4) {
            throw new IllegalArgumentException("invalid encoding");
        }
        int n5 = LittleEndianConversions.OS2IP(byArray, 0);
        if (byArray.length != 4 + n5 * (n4 = IntegerFunctions.ceilLog256(n5 - 1))) {
            throw new IllegalArgumentException("invalid encoding");
        }
        this.perm = new int[n5];
        for (int i4 = 0; i4 < n5; ++i4) {
            this.perm[i4] = LittleEndianConversions.OS2IP(byArray, 4 + i4 * n4, n4);
        }
        if (!this.isPermutation(this.perm)) {
            throw new IllegalArgumentException("invalid encoding");
        }
    }

    public Permutation(int n4, SecureRandom secureRandom) {
        int n5;
        if (n4 <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n4];
        int[] nArray = new int[n4];
        for (n5 = 0; n5 < n4; ++n5) {
            nArray[n5] = n5;
        }
        n5 = n4;
        for (int i4 = 0; i4 < n4; ++i4) {
            int n6 = RandUtils.nextInt(secureRandom, n5);
            this.perm[i4] = nArray[n6];
            nArray[n6] = nArray[--n5];
        }
    }

    public byte[] getEncoded() {
        int n4 = this.perm.length;
        int n5 = IntegerFunctions.ceilLog256(n4 - 1);
        byte[] byArray = new byte[4 + n4 * n5];
        LittleEndianConversions.I2OSP(n4, byArray, 0);
        for (int i4 = 0; i4 < n4; ++i4) {
            LittleEndianConversions.I2OSP(this.perm[i4], byArray, 4 + i4 * n5, n5);
        }
        return byArray;
    }

    public int[] getVector() {
        return IntUtils.clone(this.perm);
    }

    public Permutation computeInverse() {
        Permutation permutation = new Permutation(this.perm.length);
        for (int i4 = this.perm.length - 1; i4 >= 0; --i4) {
            permutation.perm[this.perm[i4]] = i4;
        }
        return permutation;
    }

    public Permutation rightMultiply(Permutation permutation) {
        if (permutation.perm.length != this.perm.length) {
            throw new IllegalArgumentException("length mismatch");
        }
        Permutation permutation2 = new Permutation(this.perm.length);
        for (int i4 = this.perm.length - 1; i4 >= 0; --i4) {
            permutation2.perm[i4] = this.perm[permutation.perm[i4]];
        }
        return permutation2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Permutation)) {
            return false;
        }
        Permutation permutation = (Permutation)object;
        return IntUtils.equals(this.perm, permutation.perm);
    }

    public String toString() {
        String string = "[" + this.perm[0];
        for (int i4 = 1; i4 < this.perm.length; ++i4) {
            string = string + ", " + this.perm[i4];
        }
        string = string + "]";
        return string;
    }

    public int hashCode() {
        return this.perm.hashCode();
    }

    private boolean isPermutation(int[] nArray) {
        int n4 = nArray.length;
        boolean[] blArray = new boolean[n4];
        for (int i4 = 0; i4 < n4; ++i4) {
            if (nArray[i4] < 0 || nArray[i4] >= n4 || blArray[nArray[i4]]) {
                return false;
            }
            blArray[nArray[i4]] = true;
        }
        return true;
    }
}

