/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nField;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;

public class GF2nPolynomialField
extends GF2nField {
    GF2Polynomial[] squaringMatrix;
    private boolean isTrinomial = false;
    private boolean isPentanomial = false;
    private int tc;
    private int[] pc = new int[3];

    public GF2nPolynomialField(int n4, SecureRandom secureRandom) {
        super(secureRandom);
        if (n4 < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = n4;
        this.computeFieldPolynomial();
        this.computeSquaringMatrix();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public GF2nPolynomialField(int n4, SecureRandom secureRandom, boolean bl) {
        super(secureRandom);
        if (n4 < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = n4;
        if (bl) {
            this.computeFieldPolynomial();
        } else {
            this.computeFieldPolynomial2();
        }
        this.computeSquaringMatrix();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public GF2nPolynomialField(int n4, SecureRandom secureRandom, GF2Polynomial gF2Polynomial) throws RuntimeException {
        super(secureRandom);
        if (n4 < 3) {
            throw new IllegalArgumentException("degree must be at least 3");
        }
        if (gF2Polynomial.getLength() != n4 + 1) {
            throw new RuntimeException();
        }
        if (!gF2Polynomial.isIrreducible()) {
            throw new RuntimeException();
        }
        this.mDegree = n4;
        this.fieldPolynomial = gF2Polynomial;
        this.computeSquaringMatrix();
        int n5 = 2;
        for (int i4 = 1; i4 < this.fieldPolynomial.getLength() - 1; ++i4) {
            if (!this.fieldPolynomial.testBit(i4)) continue;
            if (++n5 == 3) {
                this.tc = i4;
            }
            if (n5 > 5) continue;
            this.pc[n5 - 3] = i4;
        }
        if (n5 == 3) {
            this.isTrinomial = true;
        }
        if (n5 == 5) {
            this.isPentanomial = true;
        }
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public boolean isTrinomial() {
        return this.isTrinomial;
    }

    public boolean isPentanomial() {
        return this.isPentanomial;
    }

    public int getTc() throws RuntimeException {
        if (!this.isTrinomial) {
            throw new RuntimeException();
        }
        return this.tc;
    }

    public int[] getPc() throws RuntimeException {
        if (!this.isPentanomial) {
            throw new RuntimeException();
        }
        int[] nArray = new int[3];
        System.arraycopy(this.pc, 0, nArray, 0, 3);
        return nArray;
    }

    public GF2Polynomial getSquaringVector(int n4) {
        return new GF2Polynomial(this.squaringMatrix[n4]);
    }

    protected GF2nElement getRandomRoot(GF2Polynomial gF2Polynomial) {
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(gF2Polynomial, this);
        int n4 = gF2nPolynomial.getDegree();
        while (n4 > 1) {
            GF2nPolynomial gF2nPolynomial2;
            int n5;
            do {
                GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this, this.random);
                GF2nPolynomial gF2nPolynomial3 = new GF2nPolynomial(2, GF2nPolynomialElement.ZERO(this));
                gF2nPolynomial3.set(1, gF2nPolynomialElement);
                GF2nPolynomial gF2nPolynomial4 = new GF2nPolynomial(gF2nPolynomial3);
                for (int i4 = 1; i4 <= this.mDegree - 1; ++i4) {
                    gF2nPolynomial4 = gF2nPolynomial4.multiplyAndReduce(gF2nPolynomial4, gF2nPolynomial);
                    gF2nPolynomial4 = gF2nPolynomial4.add(gF2nPolynomial3);
                }
                gF2nPolynomial2 = gF2nPolynomial4.gcd(gF2nPolynomial);
                n5 = gF2nPolynomial2.getDegree();
                n4 = gF2nPolynomial.getDegree();
            } while (n5 == 0 || n5 == n4);
            gF2nPolynomial = n5 << 1 > n4 ? gF2nPolynomial.quotient(gF2nPolynomial2) : new GF2nPolynomial(gF2nPolynomial2);
            n4 = gF2nPolynomial.getDegree();
        }
        return gF2nPolynomial.at(0);
    }

    protected void computeCOBMatrix(GF2nField gF2nField) {
        GF2nElement[] gF2nElementArray;
        GF2nElement gF2nElement;
        int n4;
        if (this.mDegree != gF2nField.mDegree) {
            throw new IllegalArgumentException("GF2nPolynomialField.computeCOBMatrix: B1 has a different degree and thus cannot be coverted to!");
        }
        if (gF2nField instanceof GF2nONBField) {
            gF2nField.computeCOBMatrix(this);
            return;
        }
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[this.mDegree];
        for (n4 = 0; n4 < this.mDegree; ++n4) {
            gF2PolynomialArray[n4] = new GF2Polynomial(this.mDegree);
        }
        while ((gF2nElement = gF2nField.getRandomRoot(this.fieldPolynomial)).isZero()) {
        }
        if (gF2nElement instanceof GF2nONBElement) {
            gF2nElementArray = new GF2nONBElement[this.mDegree];
            gF2nElementArray[this.mDegree - 1] = GF2nONBElement.ONE((GF2nONBField)gF2nField);
        } else {
            gF2nElementArray = new GF2nPolynomialElement[this.mDegree];
            gF2nElementArray[this.mDegree - 1] = GF2nPolynomialElement.ONE((GF2nPolynomialField)gF2nField);
        }
        gF2nElementArray[this.mDegree - 2] = gF2nElement;
        for (n4 = this.mDegree - 3; n4 >= 0; --n4) {
            gF2nElementArray[n4] = (GF2nElement)gF2nElementArray[n4 + 1].multiply(gF2nElement);
        }
        if (gF2nField instanceof GF2nONBField) {
            for (n4 = 0; n4 < this.mDegree; ++n4) {
                for (int i4 = 0; i4 < this.mDegree; ++i4) {
                    if (!gF2nElementArray[n4].testBit(this.mDegree - i4 - 1)) continue;
                    gF2PolynomialArray[this.mDegree - i4 - 1].setBit(this.mDegree - n4 - 1);
                }
            }
        } else {
            for (n4 = 0; n4 < this.mDegree; ++n4) {
                for (int i5 = 0; i5 < this.mDegree; ++i5) {
                    if (!gF2nElementArray[n4].testBit(i5)) continue;
                    gF2PolynomialArray[this.mDegree - i5 - 1].setBit(this.mDegree - n4 - 1);
                }
            }
        }
        this.fields.addElement(gF2nField);
        this.matrices.addElement(gF2PolynomialArray);
        gF2nField.fields.addElement(this);
        gF2nField.matrices.addElement(this.invertMatrix(gF2PolynomialArray));
    }

    private void computeSquaringMatrix() {
        int n4;
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[this.mDegree - 1];
        this.squaringMatrix = new GF2Polynomial[this.mDegree];
        for (n4 = 0; n4 < this.squaringMatrix.length; ++n4) {
            this.squaringMatrix[n4] = new GF2Polynomial(this.mDegree, "ZERO");
        }
        for (n4 = 0; n4 < this.mDegree - 1; ++n4) {
            gF2PolynomialArray[n4] = new GF2Polynomial(1, "ONE").shiftLeft(this.mDegree + n4).remainder(this.fieldPolynomial);
        }
        for (n4 = 1; n4 <= Math.abs(this.mDegree >> 1); ++n4) {
            for (int i4 = 1; i4 <= this.mDegree; ++i4) {
                if (!gF2PolynomialArray[this.mDegree - (n4 << 1)].testBit(this.mDegree - i4)) continue;
                this.squaringMatrix[i4 - 1].setBit(this.mDegree - n4);
            }
        }
        for (n4 = Math.abs(this.mDegree >> 1) + 1; n4 <= this.mDegree; ++n4) {
            this.squaringMatrix[(n4 << 1) - this.mDegree - 1].setBit(this.mDegree - n4);
        }
    }

    protected void computeFieldPolynomial() {
        if (this.testTrinomials()) {
            return;
        }
        if (this.testPentanomials()) {
            return;
        }
        this.testRandom();
    }

    protected void computeFieldPolynomial2() {
        if (this.testTrinomials()) {
            return;
        }
        if (this.testPentanomials()) {
            return;
        }
        this.testRandom();
    }

    private boolean testTrinomials() {
        boolean bl = false;
        int n4 = 0;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        this.fieldPolynomial.setBit(0);
        this.fieldPolynomial.setBit(this.mDegree);
        for (int i4 = 1; i4 < this.mDegree && !bl; ++i4) {
            this.fieldPolynomial.setBit(i4);
            bl = this.fieldPolynomial.isIrreducible();
            ++n4;
            if (bl) {
                this.isTrinomial = true;
                this.tc = i4;
                return bl;
            }
            this.fieldPolynomial.resetBit(i4);
            bl = this.fieldPolynomial.isIrreducible();
        }
        return bl;
    }

    private boolean testPentanomials() {
        boolean bl = false;
        int n4 = 0;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        this.fieldPolynomial.setBit(0);
        this.fieldPolynomial.setBit(this.mDegree);
        for (int i4 = 1; i4 <= this.mDegree - 3 && !bl; ++i4) {
            this.fieldPolynomial.setBit(i4);
            for (int i5 = i4 + 1; i5 <= this.mDegree - 2 && !bl; ++i5) {
                this.fieldPolynomial.setBit(i5);
                for (int i6 = i5 + 1; i6 <= this.mDegree - 1 && !bl; ++i6) {
                    this.fieldPolynomial.setBit(i6);
                    if ((this.mDegree & 1) != 0 | (i4 & 1) != 0 | (i5 & 1) != 0 | (i6 & 1) != 0) {
                        bl = this.fieldPolynomial.isIrreducible();
                        ++n4;
                        if (bl) {
                            this.isPentanomial = true;
                            this.pc[0] = i4;
                            this.pc[1] = i5;
                            this.pc[2] = i6;
                            return bl;
                        }
                    }
                    this.fieldPolynomial.resetBit(i6);
                }
                this.fieldPolynomial.resetBit(i5);
            }
            this.fieldPolynomial.resetBit(i4);
        }
        return bl;
    }

    private boolean testRandom() {
        boolean bl = false;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        int n4 = 0;
        while (!bl) {
            ++n4;
            this.fieldPolynomial.randomize();
            this.fieldPolynomial.setBit(this.mDegree);
            this.fieldPolynomial.setBit(0);
            if (!this.fieldPolynomial.isIrreducible()) continue;
            bl = true;
            return bl;
        }
        return bl;
    }
}

