/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nField;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;

public class GF2nPolynomial {
    private GF2nElement[] coeff;
    private int size;

    public GF2nPolynomial(int n4, GF2nElement gF2nElement) {
        this.size = n4;
        this.coeff = new GF2nElement[this.size];
        for (int i4 = 0; i4 < this.size; ++i4) {
            this.coeff[i4] = (GF2nElement)gF2nElement.clone();
        }
    }

    private GF2nPolynomial(int n4) {
        this.size = n4;
        this.coeff = new GF2nElement[this.size];
    }

    public GF2nPolynomial(GF2nPolynomial gF2nPolynomial) {
        this.coeff = new GF2nElement[gF2nPolynomial.size];
        this.size = gF2nPolynomial.size;
        for (int i4 = 0; i4 < this.size; ++i4) {
            this.coeff[i4] = (GF2nElement)gF2nPolynomial.coeff[i4].clone();
        }
    }

    public GF2nPolynomial(GF2Polynomial gF2Polynomial, GF2nField gF2nField) {
        this.size = gF2nField.getDegree() + 1;
        this.coeff = new GF2nElement[this.size];
        if (gF2nField instanceof GF2nONBField) {
            for (int i4 = 0; i4 < this.size; ++i4) {
                this.coeff[i4] = gF2Polynomial.testBit(i4) ? GF2nONBElement.ONE((GF2nONBField)gF2nField) : GF2nONBElement.ZERO((GF2nONBField)gF2nField);
            }
        } else if (gF2nField instanceof GF2nPolynomialField) {
            for (int i5 = 0; i5 < this.size; ++i5) {
                this.coeff[i5] = gF2Polynomial.testBit(i5) ? GF2nPolynomialElement.ONE((GF2nPolynomialField)gF2nField) : GF2nPolynomialElement.ZERO((GF2nPolynomialField)gF2nField);
            }
        } else {
            throw new IllegalArgumentException("PolynomialGF2n(Bitstring, GF2nField): B1 must be an instance of GF2nONBField or GF2nPolynomialField!");
        }
    }

    public final void assignZeroToElements() {
        for (int i4 = 0; i4 < this.size; ++i4) {
            this.coeff[i4].assignZero();
        }
    }

    public final int size() {
        return this.size;
    }

    public final int getDegree() {
        for (int i4 = this.size - 1; i4 >= 0; --i4) {
            if (this.coeff[i4].isZero()) continue;
            return i4;
        }
        return -1;
    }

    public final void enlarge(int n4) {
        if (n4 <= this.size) {
            return;
        }
        GF2nElement[] gF2nElementArray = new GF2nElement[n4];
        System.arraycopy(this.coeff, 0, gF2nElementArray, 0, this.size);
        GF2nField gF2nField = this.coeff[0].getField();
        if (this.coeff[0] instanceof GF2nPolynomialElement) {
            for (int i4 = this.size; i4 < n4; ++i4) {
                gF2nElementArray[i4] = GF2nPolynomialElement.ZERO((GF2nPolynomialField)gF2nField);
            }
        } else if (this.coeff[0] instanceof GF2nONBElement) {
            for (int i5 = this.size; i5 < n4; ++i5) {
                gF2nElementArray[i5] = GF2nONBElement.ZERO((GF2nONBField)gF2nField);
            }
        }
        this.size = n4;
        this.coeff = gF2nElementArray;
    }

    public final void shrink() {
        int n4;
        for (n4 = this.size - 1; this.coeff[n4].isZero() && n4 > 0; --n4) {
        }
        if (++n4 < this.size) {
            GF2nElement[] gF2nElementArray = new GF2nElement[n4];
            System.arraycopy(this.coeff, 0, gF2nElementArray, 0, n4);
            this.coeff = gF2nElementArray;
            this.size = n4;
        }
    }

    public final void set(int n4, GF2nElement gF2nElement) {
        if (!(gF2nElement instanceof GF2nPolynomialElement) && !(gF2nElement instanceof GF2nONBElement)) {
            throw new IllegalArgumentException("PolynomialGF2n.set f must be an instance of either GF2nPolynomialElement or GF2nONBElement!");
        }
        this.coeff[n4] = (GF2nElement)gF2nElement.clone();
    }

    public final GF2nElement at(int n4) {
        return this.coeff[n4];
    }

    public final boolean isZero() {
        for (int i4 = 0; i4 < this.size; ++i4) {
            if (this.coeff[i4] == null || this.coeff[i4].isZero()) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof GF2nPolynomial)) {
            return false;
        }
        GF2nPolynomial gF2nPolynomial = (GF2nPolynomial)object;
        if (this.getDegree() != gF2nPolynomial.getDegree()) {
            return false;
        }
        for (int i4 = 0; i4 < this.size; ++i4) {
            if (this.coeff[i4].equals(gF2nPolynomial.coeff[i4])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getDegree() + this.coeff.hashCode();
    }

    public final GF2nPolynomial add(GF2nPolynomial gF2nPolynomial) throws RuntimeException {
        GF2nPolynomial gF2nPolynomial2;
        if (this.size() >= gF2nPolynomial.size()) {
            int n4;
            gF2nPolynomial2 = new GF2nPolynomial(this.size());
            for (n4 = 0; n4 < gF2nPolynomial.size(); ++n4) {
                gF2nPolynomial2.coeff[n4] = (GF2nElement)this.coeff[n4].add(gF2nPolynomial.coeff[n4]);
            }
            while (n4 < this.size()) {
                gF2nPolynomial2.coeff[n4] = this.coeff[n4];
                ++n4;
            }
        } else {
            int n5;
            gF2nPolynomial2 = new GF2nPolynomial(gF2nPolynomial.size());
            for (n5 = 0; n5 < this.size(); ++n5) {
                gF2nPolynomial2.coeff[n5] = (GF2nElement)this.coeff[n5].add(gF2nPolynomial.coeff[n5]);
            }
            while (n5 < gF2nPolynomial.size()) {
                gF2nPolynomial2.coeff[n5] = gF2nPolynomial.coeff[n5];
                ++n5;
            }
        }
        return gF2nPolynomial2;
    }

    public final GF2nPolynomial scalarMultiply(GF2nElement gF2nElement) throws RuntimeException {
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(this.size());
        for (int i4 = 0; i4 < this.size(); ++i4) {
            gF2nPolynomial.coeff[i4] = (GF2nElement)this.coeff[i4].multiply(gF2nElement);
        }
        return gF2nPolynomial;
    }

    public final GF2nPolynomial multiply(GF2nPolynomial gF2nPolynomial) throws RuntimeException {
        int n4;
        int n5 = this.size();
        if (n5 != (n4 = gF2nPolynomial.size())) {
            throw new IllegalArgumentException("PolynomialGF2n.multiply: this and b must have the same size!");
        }
        GF2nPolynomial gF2nPolynomial2 = new GF2nPolynomial((n5 << 1) - 1);
        for (int i4 = 0; i4 < this.size(); ++i4) {
            for (int i5 = 0; i5 < gF2nPolynomial.size(); ++i5) {
                gF2nPolynomial2.coeff[i4 + i5] = gF2nPolynomial2.coeff[i4 + i5] == null ? (GF2nElement)this.coeff[i4].multiply(gF2nPolynomial.coeff[i5]) : (GF2nElement)gF2nPolynomial2.coeff[i4 + i5].add(this.coeff[i4].multiply(gF2nPolynomial.coeff[i5]));
            }
        }
        return gF2nPolynomial2;
    }

    public final GF2nPolynomial multiplyAndReduce(GF2nPolynomial gF2nPolynomial, GF2nPolynomial gF2nPolynomial2) throws RuntimeException, ArithmeticException {
        return this.multiply(gF2nPolynomial).reduce(gF2nPolynomial2);
    }

    public final GF2nPolynomial reduce(GF2nPolynomial gF2nPolynomial) throws RuntimeException, ArithmeticException {
        return this.remainder(gF2nPolynomial);
    }

    public final void shiftThisLeft(int n4) {
        block3: {
            int n5;
            GF2nField gF2nField;
            block4: {
                if (n4 <= 0) break block3;
                int n6 = this.size;
                gF2nField = this.coeff[0].getField();
                this.enlarge(this.size + n4);
                for (n5 = n6 - 1; n5 >= 0; --n5) {
                    this.coeff[n5 + n4] = this.coeff[n5];
                }
                if (!(this.coeff[0] instanceof GF2nPolynomialElement)) break block4;
                for (n5 = n4 - 1; n5 >= 0; --n5) {
                    this.coeff[n5] = GF2nPolynomialElement.ZERO((GF2nPolynomialField)gF2nField);
                }
                break block3;
            }
            if (!(this.coeff[0] instanceof GF2nONBElement)) break block3;
            for (n5 = n4 - 1; n5 >= 0; --n5) {
                this.coeff[n5] = GF2nONBElement.ZERO((GF2nONBField)gF2nField);
            }
        }
    }

    public final GF2nPolynomial shiftLeft(int n4) {
        if (n4 <= 0) {
            return new GF2nPolynomial(this);
        }
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(this.size + n4, this.coeff[0]);
        gF2nPolynomial.assignZeroToElements();
        for (int i4 = 0; i4 < this.size; ++i4) {
            gF2nPolynomial.coeff[i4 + n4] = this.coeff[i4];
        }
        return gF2nPolynomial;
    }

    public final GF2nPolynomial[] divide(GF2nPolynomial gF2nPolynomial) throws RuntimeException, ArithmeticException {
        GF2nPolynomial[] gF2nPolynomialArray = new GF2nPolynomial[2];
        GF2nPolynomial gF2nPolynomial2 = new GF2nPolynomial(this);
        gF2nPolynomial2.shrink();
        int n4 = gF2nPolynomial.getDegree();
        GF2nElement gF2nElement = (GF2nElement)gF2nPolynomial.coeff[n4].invert();
        if (gF2nPolynomial2.getDegree() < n4) {
            gF2nPolynomialArray[0] = new GF2nPolynomial(this);
            gF2nPolynomialArray[0].assignZeroToElements();
            gF2nPolynomialArray[0].shrink();
            gF2nPolynomialArray[1] = new GF2nPolynomial(this);
            gF2nPolynomialArray[1].shrink();
            return gF2nPolynomialArray;
        }
        gF2nPolynomialArray[0] = new GF2nPolynomial(this);
        gF2nPolynomialArray[0].assignZeroToElements();
        int n5 = gF2nPolynomial2.getDegree() - n4;
        while (n5 >= 0) {
            GF2nElement gF2nElement2 = (GF2nElement)gF2nPolynomial2.coeff[gF2nPolynomial2.getDegree()].multiply(gF2nElement);
            GF2nPolynomial gF2nPolynomial3 = gF2nPolynomial.scalarMultiply(gF2nElement2);
            gF2nPolynomial3.shiftThisLeft(n5);
            gF2nPolynomial2 = gF2nPolynomial2.add(gF2nPolynomial3);
            gF2nPolynomial2.shrink();
            gF2nPolynomialArray[0].coeff[n5] = (GF2nElement)gF2nElement2.clone();
            n5 = gF2nPolynomial2.getDegree() - n4;
        }
        gF2nPolynomialArray[1] = gF2nPolynomial2;
        gF2nPolynomialArray[0].shrink();
        return gF2nPolynomialArray;
    }

    public final GF2nPolynomial remainder(GF2nPolynomial gF2nPolynomial) throws RuntimeException, ArithmeticException {
        GF2nPolynomial[] gF2nPolynomialArray = new GF2nPolynomial[2];
        gF2nPolynomialArray = this.divide(gF2nPolynomial);
        return gF2nPolynomialArray[1];
    }

    public final GF2nPolynomial quotient(GF2nPolynomial gF2nPolynomial) throws RuntimeException, ArithmeticException {
        GF2nPolynomial[] gF2nPolynomialArray = new GF2nPolynomial[2];
        gF2nPolynomialArray = this.divide(gF2nPolynomial);
        return gF2nPolynomialArray[0];
    }

    public final GF2nPolynomial gcd(GF2nPolynomial gF2nPolynomial) throws RuntimeException, ArithmeticException {
        GF2nPolynomial gF2nPolynomial2 = new GF2nPolynomial(this);
        GF2nPolynomial gF2nPolynomial3 = new GF2nPolynomial(gF2nPolynomial);
        gF2nPolynomial2.shrink();
        gF2nPolynomial3.shrink();
        while (!gF2nPolynomial3.isZero()) {
            GF2nPolynomial gF2nPolynomial4 = gF2nPolynomial2.remainder(gF2nPolynomial3);
            gF2nPolynomial2 = gF2nPolynomial3;
            gF2nPolynomial3 = gF2nPolynomial4;
        }
        GF2nElement gF2nElement = gF2nPolynomial2.coeff[gF2nPolynomial2.getDegree()];
        GF2nPolynomial gF2nPolynomial5 = gF2nPolynomial2.scalarMultiply((GF2nElement)gF2nElement.invert());
        return gF2nPolynomial5;
    }
}

