/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

public final class ByteUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ByteUtils() {
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2 == null;
        }
        if (byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        boolean bl = true;
        for (int i4 = byArray.length - 1; i4 >= 0; --i4) {
            bl &= byArray[i4] == byArray2[i4];
        }
        return bl;
    }

    public static boolean equals(byte[][] byArray, byte[][] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        boolean bl = true;
        for (int i4 = byArray.length - 1; i4 >= 0; --i4) {
            bl &= ByteUtils.equals(byArray[i4], byArray2[i4]);
        }
        return bl;
    }

    public static boolean equals(byte[][][] byArray, byte[][][] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        boolean bl = true;
        for (int i4 = byArray.length - 1; i4 >= 0; --i4) {
            if (byArray[i4].length != byArray2[i4].length) {
                return false;
            }
            for (int i5 = byArray[i4].length - 1; i5 >= 0; --i5) {
                bl &= ByteUtils.equals(byArray[i4][i5], byArray2[i4][i5]);
            }
        }
        return bl;
    }

    public static int deepHashCode(byte[] byArray) {
        int n4 = 1;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            n4 = 31 * n4 + byArray[i4];
        }
        return n4;
    }

    public static int deepHashCode(byte[][] byArray) {
        int n4 = 1;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            n4 = 31 * n4 + ByteUtils.deepHashCode(byArray[i4]);
        }
        return n4;
    }

    public static int deepHashCode(byte[][][] byArray) {
        int n4 = 1;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            n4 = 31 * n4 + ByteUtils.deepHashCode(byArray[i4]);
        }
        return n4;
    }

    public static byte[] clone(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static byte[] fromHexString(String string) {
        char[] cArray = string.toUpperCase().toCharArray();
        int n4 = 0;
        for (int i4 = 0; i4 < cArray.length; ++i4) {
            if ((cArray[i4] < '0' || cArray[i4] > '9') && (cArray[i4] < 'A' || cArray[i4] > 'F')) continue;
            ++n4;
        }
        byte[] byArray = new byte[n4 + 1 >> 1];
        int n5 = n4 & 1;
        for (int i5 = 0; i5 < cArray.length; ++i5) {
            if (cArray[i5] >= '0' && cArray[i5] <= '9') {
                int n6 = n5 >> 1;
                byArray[n6] = (byte)(byArray[n6] << 4);
                int n7 = n5 >> 1;
                byArray[n7] = (byte)(byArray[n7] | cArray[i5] - 48);
            } else {
                if (cArray[i5] < 'A' || cArray[i5] > 'F') continue;
                int n8 = n5 >> 1;
                byArray[n8] = (byte)(byArray[n8] << 4);
                int n9 = n5 >> 1;
                byArray[n9] = (byte)(byArray[n9] | cArray[i5] - 65 + 10);
            }
            ++n5;
        }
        return byArray;
    }

    public static String toHexString(byte[] byArray) {
        String string = "";
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            string = string + HEX_CHARS[byArray[i4] >>> 4 & 0xF];
            string = string + HEX_CHARS[byArray[i4] & 0xF];
        }
        return string;
    }

    public static String toHexString(byte[] byArray, String string, String string2) {
        String string3 = new String(string);
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            string3 = string3 + HEX_CHARS[byArray[i4] >>> 4 & 0xF];
            string3 = string3 + HEX_CHARS[byArray[i4] & 0xF];
            if (i4 >= byArray.length - 1) continue;
            string3 = string3 + string2;
        }
        return string3;
    }

    public static String toBinaryString(byte[] byArray) {
        String string = "";
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            byte by = byArray[i4];
            for (int i5 = 0; i5 < 8; ++i5) {
                int n4 = by >>> i5 & 1;
                string = string + n4;
            }
            if (i4 == byArray.length - 1) continue;
            string = string + " ";
        }
        return string;
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i4 = byArray.length - 1; i4 >= 0; --i4) {
            byArray3[i4] = (byte)(byArray[i4] ^ byArray2[i4]);
        }
        return byArray3;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] concatenate(byte[][] byArray) {
        int n4 = byArray[0].length;
        byte[] byArray2 = new byte[byArray.length * n4];
        int n5 = 0;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            System.arraycopy(byArray[i4], 0, byArray2, n5, n4);
            n5 += n4;
        }
        return byArray2;
    }

    public static byte[][] split(byte[] byArray, int n4) throws ArrayIndexOutOfBoundsException {
        if (n4 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[][] byArrayArray = new byte[][]{new byte[n4], new byte[byArray.length - n4]};
        System.arraycopy(byArray, 0, byArrayArray[0], 0, n4);
        System.arraycopy(byArray, n4, byArrayArray[1], 0, byArray.length - n4);
        return byArrayArray;
    }

    public static byte[] subArray(byte[] byArray, int n4, int n5) {
        byte[] byArray2 = new byte[n5 - n4];
        System.arraycopy(byArray, n4, byArray2, 0, n5 - n4);
        return byArray2;
    }

    public static byte[] subArray(byte[] byArray, int n4) {
        return ByteUtils.subArray(byArray, n4, byArray.length);
    }

    public static char[] toCharArray(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            cArray[i4] = (char)byArray[i4];
        }
        return cArray;
    }
}

