/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow.util;

import org.bouncycastle.pqc.crypto.rainbow.util.GF2Field;

public class ComputeInField {
    private short[][] A;
    short[] x;

    public short[] solveEquation(short[][] sArray, short[] sArray2) {
        try {
            int n4;
            if (sArray.length != sArray2.length) {
                throw new RuntimeException("The equation system is not solvable");
            }
            this.A = new short[sArray.length][sArray.length + 1];
            this.x = new short[sArray.length];
            for (n4 = 0; n4 < sArray.length; ++n4) {
                for (int i4 = 0; i4 < sArray[0].length; ++i4) {
                    this.A[n4][i4] = sArray[n4][i4];
                }
            }
            for (n4 = 0; n4 < sArray2.length; ++n4) {
                this.A[n4][sArray2.length] = GF2Field.addElem(sArray2[n4], this.A[n4][sArray2.length]);
            }
            this.computeZerosUnder(false);
            this.substitute();
            return this.x;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public short[][] inverse(short[][] sArray) {
        try {
            int n4;
            int n5;
            this.A = new short[sArray.length][2 * sArray.length];
            if (sArray.length != sArray[0].length) {
                throw new RuntimeException("The matrix is not invertible. Please choose another one!");
            }
            for (n5 = 0; n5 < sArray.length; ++n5) {
                for (n4 = 0; n4 < sArray.length; ++n4) {
                    this.A[n5][n4] = sArray[n5][n4];
                }
                for (n4 = sArray.length; n4 < 2 * sArray.length; ++n4) {
                    this.A[n5][n4] = 0;
                }
                this.A[n5][n5 + this.A.length] = 1;
            }
            this.computeZerosUnder(true);
            for (n5 = 0; n5 < this.A.length; ++n5) {
                short s4 = GF2Field.invElem(this.A[n5][n5]);
                for (n4 = n5; n4 < 2 * this.A.length; ++n4) {
                    this.A[n5][n4] = GF2Field.multElem(this.A[n5][n4], s4);
                }
            }
            this.computeZerosAbove();
            short[][] sArray2 = new short[this.A.length][this.A.length];
            for (n5 = 0; n5 < this.A.length; ++n5) {
                for (n4 = this.A.length; n4 < 2 * this.A.length; ++n4) {
                    sArray2[n5][n4 - this.A.length] = this.A[n5][n4];
                }
            }
            return sArray2;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private void computeZerosUnder(boolean bl) throws RuntimeException {
        short s4 = 0;
        int n4 = bl ? 2 * this.A.length : this.A.length + 1;
        for (int i4 = 0; i4 < this.A.length - 1; ++i4) {
            for (int i5 = i4 + 1; i5 < this.A.length; ++i5) {
                short s5 = this.A[i5][i4];
                short s6 = GF2Field.invElem(this.A[i4][i4]);
                if (s6 == 0) {
                    throw new RuntimeException("Matrix not invertible! We have to choose another one!");
                }
                for (int i6 = i4; i6 < n4; ++i6) {
                    s4 = GF2Field.multElem(this.A[i4][i6], s6);
                    s4 = GF2Field.multElem(s5, s4);
                    this.A[i5][i6] = GF2Field.addElem(this.A[i5][i6], s4);
                }
            }
        }
    }

    private void computeZerosAbove() throws RuntimeException {
        short s4 = 0;
        for (int i4 = this.A.length - 1; i4 > 0; --i4) {
            for (int i5 = i4 - 1; i5 >= 0; --i5) {
                short s5 = this.A[i5][i4];
                short s6 = GF2Field.invElem(this.A[i4][i4]);
                if (s6 == 0) {
                    throw new RuntimeException("The matrix is not invertible");
                }
                for (int i6 = i4; i6 < 2 * this.A.length; ++i6) {
                    s4 = GF2Field.multElem(this.A[i4][i6], s6);
                    s4 = GF2Field.multElem(s5, s4);
                    this.A[i5][i6] = GF2Field.addElem(this.A[i5][i6], s4);
                }
            }
        }
    }

    private void substitute() throws RuntimeException {
        short s4 = GF2Field.invElem(this.A[this.A.length - 1][this.A.length - 1]);
        if (s4 == 0) {
            throw new RuntimeException("The equation system is not solvable");
        }
        this.x[this.A.length - 1] = GF2Field.multElem(this.A[this.A.length - 1][this.A.length], s4);
        for (int i4 = this.A.length - 2; i4 >= 0; --i4) {
            short s5 = this.A[i4][this.A.length];
            for (int i5 = this.A.length - 1; i5 > i4; --i5) {
                s4 = GF2Field.multElem(this.A[i4][i5], this.x[i5]);
                s5 = GF2Field.addElem(s5, s4);
            }
            s4 = GF2Field.invElem(this.A[i4][i4]);
            if (s4 == 0) {
                throw new RuntimeException("Not solvable equation system");
            }
            this.x[i4] = GF2Field.multElem(s5, s4);
        }
    }

    public short[][] multiplyMatrix(short[][] sArray, short[][] sArray2) throws RuntimeException {
        if (sArray[0].length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short s4 = 0;
        this.A = new short[sArray.length][sArray2[0].length];
        for (int i4 = 0; i4 < sArray.length; ++i4) {
            for (int i5 = 0; i5 < sArray2.length; ++i5) {
                for (int i6 = 0; i6 < sArray2[0].length; ++i6) {
                    s4 = GF2Field.multElem(sArray[i4][i5], sArray2[i5][i6]);
                    this.A[i4][i6] = GF2Field.addElem(this.A[i4][i6], s4);
                }
            }
        }
        return this.A;
    }

    public short[] multiplyMatrix(short[][] sArray, short[] sArray2) throws RuntimeException {
        if (sArray[0].length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short s4 = 0;
        short[] sArray3 = new short[sArray.length];
        for (int i4 = 0; i4 < sArray.length; ++i4) {
            for (int i5 = 0; i5 < sArray2.length; ++i5) {
                s4 = GF2Field.multElem(sArray[i4][i5], sArray2[i5]);
                sArray3[i4] = GF2Field.addElem(sArray3[i4], s4);
            }
        }
        return sArray3;
    }

    public short[] addVect(short[] sArray, short[] sArray2) {
        if (sArray.length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[] sArray3 = new short[sArray.length];
        for (int i4 = 0; i4 < sArray3.length; ++i4) {
            sArray3[i4] = GF2Field.addElem(sArray[i4], sArray2[i4]);
        }
        return sArray3;
    }

    public short[][] multVects(short[] sArray, short[] sArray2) {
        if (sArray.length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[][] sArray3 = new short[sArray.length][sArray2.length];
        for (int i4 = 0; i4 < sArray.length; ++i4) {
            for (int i5 = 0; i5 < sArray2.length; ++i5) {
                sArray3[i4][i5] = GF2Field.multElem(sArray[i4], sArray2[i5]);
            }
        }
        return sArray3;
    }

    public short[] multVect(short s4, short[] sArray) {
        short[] sArray2 = new short[sArray.length];
        for (int i4 = 0; i4 < sArray2.length; ++i4) {
            sArray2[i4] = GF2Field.multElem(s4, sArray[i4]);
        }
        return sArray2;
    }

    public short[][] multMatrix(short s4, short[][] sArray) {
        short[][] sArray2 = new short[sArray.length][sArray[0].length];
        for (int i4 = 0; i4 < sArray.length; ++i4) {
            for (int i5 = 0; i5 < sArray[0].length; ++i5) {
                sArray2[i4][i5] = GF2Field.multElem(s4, sArray[i4][i5]);
            }
        }
        return sArray2;
    }

    public short[][] addSquareMatrix(short[][] sArray, short[][] sArray2) {
        if (sArray.length != sArray2.length || sArray[0].length != sArray2[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        short[][] sArray3 = new short[sArray.length][sArray.length];
        for (int i4 = 0; i4 < sArray.length; ++i4) {
            for (int i5 = 0; i5 < sArray2.length; ++i5) {
                sArray3[i4][i5] = GF2Field.addElem(sArray[i4][i5], sArray2[i4][i5]);
            }
        }
        return sArray3;
    }
}

