/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.rainbow.Layer;
import org.bouncycastle.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import org.bouncycastle.pqc.crypto.rainbow.util.GF2Field;

public class RainbowKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private boolean initialized = false;
    private SecureRandom sr;
    private RainbowKeyGenerationParameters rainbowParams;
    private short[][] A1;
    private short[][] A1inv;
    private short[] b1;
    private short[][] A2;
    private short[][] A2inv;
    private short[] b2;
    private int numOfLayers;
    private Layer[] layers;
    private int[] vi;
    private short[][] pub_quadratic;
    private short[][] pub_singular;
    private short[] pub_scalar;

    public AsymmetricCipherKeyPair genKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        this.keygen();
        RainbowPrivateKeyParameters rainbowPrivateKeyParameters = new RainbowPrivateKeyParameters(this.A1inv, this.b1, this.A2inv, this.b2, this.vi, this.layers);
        RainbowPublicKeyParameters rainbowPublicKeyParameters = new RainbowPublicKeyParameters(this.vi[this.vi.length - 1] - this.vi[0], this.pub_quadratic, this.pub_singular, this.pub_scalar);
        return new AsymmetricCipherKeyPair(rainbowPublicKeyParameters, rainbowPrivateKeyParameters);
    }

    public void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.rainbowParams = (RainbowKeyGenerationParameters)keyGenerationParameters;
        this.sr = new SecureRandom();
        this.vi = this.rainbowParams.getParameters().getVi();
        this.numOfLayers = this.rainbowParams.getParameters().getNumOfLayers();
        this.initialized = true;
    }

    private void initializeDefault() {
        RainbowKeyGenerationParameters rainbowKeyGenerationParameters = new RainbowKeyGenerationParameters(new SecureRandom(), new RainbowParameters());
        this.initialize(rainbowKeyGenerationParameters);
    }

    private void keygen() {
        this.generateL1();
        this.generateL2();
        this.generateF();
        this.computePublicKey();
    }

    private void generateL1() {
        int n4;
        int n5 = this.vi[this.vi.length - 1] - this.vi[0];
        this.A1 = new short[n5][n5];
        this.A1inv = null;
        ComputeInField computeInField = new ComputeInField();
        while (this.A1inv == null) {
            for (n4 = 0; n4 < n5; ++n4) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    this.A1[n4][i4] = (short)(this.sr.nextInt() & 0xFF);
                }
            }
            this.A1inv = computeInField.inverse(this.A1);
        }
        this.b1 = new short[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            this.b1[n4] = (short)(this.sr.nextInt() & 0xFF);
        }
    }

    private void generateL2() {
        int n4;
        int n5 = this.vi[this.vi.length - 1];
        this.A2 = new short[n5][n5];
        this.A2inv = null;
        ComputeInField computeInField = new ComputeInField();
        while (this.A2inv == null) {
            for (n4 = 0; n4 < n5; ++n4) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    this.A2[n4][i4] = (short)(this.sr.nextInt() & 0xFF);
                }
            }
            this.A2inv = computeInField.inverse(this.A2);
        }
        this.b2 = new short[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            this.b2[n4] = (short)(this.sr.nextInt() & 0xFF);
        }
    }

    private void generateF() {
        this.layers = new Layer[this.numOfLayers];
        for (int i4 = 0; i4 < this.numOfLayers; ++i4) {
            this.layers[i4] = new Layer(this.vi[i4], this.vi[i4 + 1], this.sr);
        }
    }

    private void computePublicKey() {
        int n4;
        ComputeInField computeInField = new ComputeInField();
        int n5 = this.vi[this.vi.length - 1] - this.vi[0];
        int n6 = this.vi[this.vi.length - 1];
        short[][][] sArray = new short[n5][n6][n6];
        this.pub_singular = new short[n5][n6];
        this.pub_scalar = new short[n5];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        short[] sArray2 = new short[n6];
        short s4 = 0;
        for (int i4 = 0; i4 < this.layers.length; ++i4) {
            short[][][] sArray3 = this.layers[i4].getCoeffAlpha();
            short[][][] sArray4 = this.layers[i4].getCoeffBeta();
            short[][] sArray5 = this.layers[i4].getCoeffGamma();
            short[] sArray6 = this.layers[i4].getCoeffEta();
            n7 = sArray3[0].length;
            n8 = sArray4[0].length;
            for (int i5 = 0; i5 < n7; ++i5) {
                int n10;
                for (n10 = 0; n10 < n7; ++n10) {
                    for (n4 = 0; n4 < n8; ++n4) {
                        sArray2 = computeInField.multVect(sArray3[i5][n10][n4], this.A2[n10 + n8]);
                        sArray[n9 + i5] = computeInField.addSquareMatrix(sArray[n9 + i5], computeInField.multVects(sArray2, this.A2[n4]));
                        sArray2 = computeInField.multVect(this.b2[n4], sArray2);
                        this.pub_singular[n9 + i5] = computeInField.addVect(sArray2, this.pub_singular[n9 + i5]);
                        sArray2 = computeInField.multVect(sArray3[i5][n10][n4], this.A2[n4]);
                        sArray2 = computeInField.multVect(this.b2[n10 + n8], sArray2);
                        this.pub_singular[n9 + i5] = computeInField.addVect(sArray2, this.pub_singular[n9 + i5]);
                        s4 = GF2Field.multElem(sArray3[i5][n10][n4], this.b2[n10 + n8]);
                        this.pub_scalar[n9 + i5] = GF2Field.addElem(this.pub_scalar[n9 + i5], GF2Field.multElem(s4, this.b2[n4]));
                    }
                }
                for (n10 = 0; n10 < n8; ++n10) {
                    for (n4 = 0; n4 < n8; ++n4) {
                        sArray2 = computeInField.multVect(sArray4[i5][n10][n4], this.A2[n10]);
                        sArray[n9 + i5] = computeInField.addSquareMatrix(sArray[n9 + i5], computeInField.multVects(sArray2, this.A2[n4]));
                        sArray2 = computeInField.multVect(this.b2[n4], sArray2);
                        this.pub_singular[n9 + i5] = computeInField.addVect(sArray2, this.pub_singular[n9 + i5]);
                        sArray2 = computeInField.multVect(sArray4[i5][n10][n4], this.A2[n4]);
                        sArray2 = computeInField.multVect(this.b2[n10], sArray2);
                        this.pub_singular[n9 + i5] = computeInField.addVect(sArray2, this.pub_singular[n9 + i5]);
                        s4 = GF2Field.multElem(sArray4[i5][n10][n4], this.b2[n10]);
                        this.pub_scalar[n9 + i5] = GF2Field.addElem(this.pub_scalar[n9 + i5], GF2Field.multElem(s4, this.b2[n4]));
                    }
                }
                for (n10 = 0; n10 < n8 + n7; ++n10) {
                    sArray2 = computeInField.multVect(sArray5[i5][n10], this.A2[n10]);
                    this.pub_singular[n9 + i5] = computeInField.addVect(sArray2, this.pub_singular[n9 + i5]);
                    this.pub_scalar[n9 + i5] = GF2Field.addElem(this.pub_scalar[n9 + i5], GF2Field.multElem(sArray5[i5][n10], this.b2[n10]));
                }
                this.pub_scalar[n9 + i5] = GF2Field.addElem(this.pub_scalar[n9 + i5], sArray6[i5]);
            }
            n9 += n7;
        }
        short[][][] sArray7 = new short[n5][n6][n6];
        short[][] sArray8 = new short[n5][n6];
        short[] sArray9 = new short[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i6 = 0; i6 < this.A1.length; ++i6) {
                sArray7[n4] = computeInField.addSquareMatrix(sArray7[n4], computeInField.multMatrix(this.A1[n4][i6], sArray[i6]));
                sArray8[n4] = computeInField.addVect(sArray8[n4], computeInField.multVect(this.A1[n4][i6], this.pub_singular[i6]));
                sArray9[n4] = GF2Field.addElem(sArray9[n4], GF2Field.multElem(this.A1[n4][i6], this.pub_scalar[i6]));
            }
            sArray9[n4] = GF2Field.addElem(sArray9[n4], this.b1[n4]);
        }
        sArray = sArray7;
        this.pub_singular = sArray8;
        this.pub_scalar = sArray9;
        this.compactPublicKey(sArray);
    }

    private void compactPublicKey(short[][][] sArray) {
        int n4 = sArray.length;
        int n5 = sArray[0].length;
        int n6 = n5 * (n5 + 1) / 2;
        this.pub_quadratic = new short[n4][n6];
        int n7 = 0;
        for (int i4 = 0; i4 < n4; ++i4) {
            n7 = 0;
            for (int i5 = 0; i5 < n5; ++i5) {
                for (int i6 = i5; i6 < n5; ++i6) {
                    this.pub_quadratic[i4][n7] = i6 == i5 ? sArray[i4][i5][i6] : GF2Field.addElem(sArray[i4][i5][i6], sArray[i4][i6][i5]);
                    ++n7;
                }
            }
        }
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

