/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.util.Pack;

public abstract class Nat256 {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        nArray3[0] = (int)(l4 += ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[1] = (int)(l4 += ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[2] = (int)(l4 += ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[3] = (int)(l4 += ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[4] = (int)(l4 += ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[5] = (int)(l4 += ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[6] = (int)(l4 += ((long)nArray[6] & 0xFFFFFFFFL) + ((long)nArray2[6] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[7] = (int)(l4 += ((long)nArray[7] & 0xFFFFFFFFL) + ((long)nArray2[7] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int add(int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l4 = 0L;
        nArray3[n6 + 0] = (int)(l4 += ((long)nArray[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 1] = (int)(l4 += ((long)nArray[n4 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 2] = (int)(l4 += ((long)nArray[n4 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 3] = (int)(l4 += ((long)nArray[n4 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 4] = (int)(l4 += ((long)nArray[n4 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 4] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 5] = (int)(l4 += ((long)nArray[n4 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 5] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 6] = (int)(l4 += ((long)nArray[n4 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 6] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 7] = (int)(l4 += ((long)nArray[n4 + 7] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 7] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int addBothTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        nArray3[0] = (int)(l4 += ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray3[0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[1] = (int)(l4 += ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + ((long)nArray3[1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[2] = (int)(l4 += ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + ((long)nArray3[2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[3] = (int)(l4 += ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + ((long)nArray3[3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[4] = (int)(l4 += ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL) + ((long)nArray3[4] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[5] = (int)(l4 += ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL) + ((long)nArray3[5] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[6] = (int)(l4 += ((long)nArray[6] & 0xFFFFFFFFL) + ((long)nArray2[6] & 0xFFFFFFFFL) + ((long)nArray3[6] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[7] = (int)(l4 += ((long)nArray[7] & 0xFFFFFFFFL) + ((long)nArray2[7] & 0xFFFFFFFFL) + ((long)nArray3[7] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int addBothTo(int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l4 = 0L;
        nArray3[n6 + 0] = (int)(l4 += ((long)nArray[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 0] & 0xFFFFFFFFL) + ((long)nArray3[n6 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 1] = (int)(l4 += ((long)nArray[n4 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 1] & 0xFFFFFFFFL) + ((long)nArray3[n6 + 1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 2] = (int)(l4 += ((long)nArray[n4 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 2] & 0xFFFFFFFFL) + ((long)nArray3[n6 + 2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 3] = (int)(l4 += ((long)nArray[n4 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 3] & 0xFFFFFFFFL) + ((long)nArray3[n6 + 3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 4] = (int)(l4 += ((long)nArray[n4 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 4] & 0xFFFFFFFFL) + ((long)nArray3[n6 + 4] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 5] = (int)(l4 += ((long)nArray[n4 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 5] & 0xFFFFFFFFL) + ((long)nArray3[n6 + 5] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 6] = (int)(l4 += ((long)nArray[n4 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 6] & 0xFFFFFFFFL) + ((long)nArray3[n6 + 6] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[n6 + 7] = (int)(l4 += ((long)nArray[n4 + 7] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 7] & 0xFFFFFFFFL) + ((long)nArray3[n6 + 7] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int addTo(int[] nArray, int[] nArray2) {
        long l4 = 0L;
        nArray2[0] = (int)(l4 += ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[1] = (int)(l4 += ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[2] = (int)(l4 += ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[3] = (int)(l4 += ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[4] = (int)(l4 += ((long)nArray[4] & 0xFFFFFFFFL) + ((long)nArray2[4] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[5] = (int)(l4 += ((long)nArray[5] & 0xFFFFFFFFL) + ((long)nArray2[5] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[6] = (int)(l4 += ((long)nArray[6] & 0xFFFFFFFFL) + ((long)nArray2[6] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[7] = (int)(l4 += ((long)nArray[7] & 0xFFFFFFFFL) + ((long)nArray2[7] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int addTo(int[] nArray, int n4, int[] nArray2, int n5, int n6) {
        long l4 = (long)n6 & 0xFFFFFFFFL;
        nArray2[n5 + 0] = (int)(l4 += ((long)nArray[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n5 + 1] = (int)(l4 += ((long)nArray[n4 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n5 + 2] = (int)(l4 += ((long)nArray[n4 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n5 + 3] = (int)(l4 += ((long)nArray[n4 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n5 + 4] = (int)(l4 += ((long)nArray[n4 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 4] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n5 + 5] = (int)(l4 += ((long)nArray[n4 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 5] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n5 + 6] = (int)(l4 += ((long)nArray[n4 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 6] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n5 + 7] = (int)(l4 += ((long)nArray[n4 + 7] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 7] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int addToEachOther(int[] nArray, int n4, int[] nArray2, int n5) {
        long l4 = 0L;
        nArray[n4 + 0] = (int)(l4 += ((long)nArray[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 0] & 0xFFFFFFFFL));
        nArray2[n5 + 0] = (int)l4;
        l4 >>>= 32;
        nArray[n4 + 1] = (int)(l4 += ((long)nArray[n4 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 1] & 0xFFFFFFFFL));
        nArray2[n5 + 1] = (int)l4;
        l4 >>>= 32;
        nArray[n4 + 2] = (int)(l4 += ((long)nArray[n4 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 2] & 0xFFFFFFFFL));
        nArray2[n5 + 2] = (int)l4;
        l4 >>>= 32;
        nArray[n4 + 3] = (int)(l4 += ((long)nArray[n4 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 3] & 0xFFFFFFFFL));
        nArray2[n5 + 3] = (int)l4;
        l4 >>>= 32;
        nArray[n4 + 4] = (int)(l4 += ((long)nArray[n4 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 4] & 0xFFFFFFFFL));
        nArray2[n5 + 4] = (int)l4;
        l4 >>>= 32;
        nArray[n4 + 5] = (int)(l4 += ((long)nArray[n4 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 5] & 0xFFFFFFFFL));
        nArray2[n5 + 5] = (int)l4;
        l4 >>>= 32;
        nArray[n4 + 6] = (int)(l4 += ((long)nArray[n4 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 6] & 0xFFFFFFFFL));
        nArray2[n5 + 6] = (int)l4;
        l4 >>>= 32;
        nArray[n4 + 7] = (int)(l4 += ((long)nArray[n4 + 7] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 7] & 0xFFFFFFFFL));
        nArray2[n5 + 7] = (int)l4;
        return (int)(l4 >>>= 32);
    }

    public static void copy(int[] nArray, int[] nArray2) {
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        nArray2[2] = nArray[2];
        nArray2[3] = nArray[3];
        nArray2[4] = nArray[4];
        nArray2[5] = nArray[5];
        nArray2[6] = nArray[6];
        nArray2[7] = nArray[7];
    }

    public static void copy64(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0];
        lArray2[1] = lArray[1];
        lArray2[2] = lArray[2];
        lArray2[3] = lArray[3];
    }

    public static int[] create() {
        return new int[8];
    }

    public static long[] create64() {
        return new long[4];
    }

    public static int[] createExt() {
        return new int[16];
    }

    public static long[] createExt64() {
        return new long[8];
    }

    public static boolean diff(int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        boolean bl = Nat256.gte(nArray, n4, nArray2, n5);
        if (bl) {
            Nat256.sub(nArray, n4, nArray2, n5, nArray3, n6);
        } else {
            Nat256.sub(nArray2, n5, nArray, n4, nArray3, n6);
        }
        return bl;
    }

    public static boolean eq(int[] nArray, int[] nArray2) {
        for (int i4 = 7; i4 >= 0; --i4) {
            if (nArray[i4] == nArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq64(long[] lArray, long[] lArray2) {
        for (int i4 = 3; i4 >= 0; --i4) {
            if (lArray[i4] == lArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > 256) {
            throw new IllegalArgumentException();
        }
        int[] nArray = Nat256.create();
        int n4 = 0;
        while (bigInteger.signum() != 0) {
            nArray[n4++] = bigInteger.intValue();
            bigInteger = bigInteger.shiftRight(32);
        }
        return nArray;
    }

    public static long[] fromBigInteger64(BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > 256) {
            throw new IllegalArgumentException();
        }
        long[] lArray = Nat256.create64();
        int n4 = 0;
        while (bigInteger.signum() != 0) {
            lArray[n4++] = bigInteger.longValue();
            bigInteger = bigInteger.shiftRight(64);
        }
        return lArray;
    }

    public static int getBit(int[] nArray, int n4) {
        if (n4 == 0) {
            return nArray[0] & 1;
        }
        if ((n4 & 0xFF) != n4) {
            return 0;
        }
        int n5 = n4 >>> 5;
        int n6 = n4 & 0x1F;
        return nArray[n5] >>> n6 & 1;
    }

    public static boolean gte(int[] nArray, int[] nArray2) {
        for (int i4 = 7; i4 >= 0; --i4) {
            int n4 = nArray[i4] ^ Integer.MIN_VALUE;
            int n5 = nArray2[i4] ^ Integer.MIN_VALUE;
            if (n4 < n5) {
                return false;
            }
            if (n4 <= n5) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] nArray, int n4, int[] nArray2, int n5) {
        for (int i4 = 7; i4 >= 0; --i4) {
            int n6 = nArray[n4 + i4] ^ Integer.MIN_VALUE;
            int n7 = nArray2[n5 + i4] ^ Integer.MIN_VALUE;
            if (n6 < n7) {
                return false;
            }
            if (n6 <= n7) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int i4 = 1; i4 < 8; ++i4) {
            if (nArray[i4] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne64(long[] lArray) {
        if (lArray[0] != 1L) {
            return false;
        }
        for (int i4 = 1; i4 < 4; ++i4) {
            if (lArray[i4] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] nArray) {
        for (int i4 = 0; i4 < 8; ++i4) {
            if (nArray[i4] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] lArray) {
        for (int i4 = 0; i4 < 4; ++i4) {
            if (lArray[i4] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[4] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[5] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[6] & 0xFFFFFFFFL;
        long l11 = (long)nArray2[7] & 0xFFFFFFFFL;
        long l12 = 0L;
        long l13 = (long)nArray[0] & 0xFFFFFFFFL;
        nArray3[0] = (int)(l12 += l13 * l4);
        l12 >>>= 32;
        nArray3[1] = (int)(l12 += l13 * l5);
        l12 >>>= 32;
        nArray3[2] = (int)(l12 += l13 * l6);
        l12 >>>= 32;
        nArray3[3] = (int)(l12 += l13 * l7);
        l12 >>>= 32;
        nArray3[4] = (int)(l12 += l13 * l8);
        l12 >>>= 32;
        nArray3[5] = (int)(l12 += l13 * l9);
        l12 >>>= 32;
        nArray3[6] = (int)(l12 += l13 * l10);
        l12 >>>= 32;
        nArray3[7] = (int)(l12 += l13 * l11);
        nArray3[8] = (int)(l12 >>>= 32);
        for (int i4 = 1; i4 < 8; ++i4) {
            long l14 = 0L;
            long l15 = (long)nArray[i4] & 0xFFFFFFFFL;
            nArray3[i4 + 0] = (int)(l14 += l15 * l4 + ((long)nArray3[i4 + 0] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[i4 + 1] = (int)(l14 += l15 * l5 + ((long)nArray3[i4 + 1] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[i4 + 2] = (int)(l14 += l15 * l6 + ((long)nArray3[i4 + 2] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[i4 + 3] = (int)(l14 += l15 * l7 + ((long)nArray3[i4 + 3] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[i4 + 4] = (int)(l14 += l15 * l8 + ((long)nArray3[i4 + 4] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[i4 + 5] = (int)(l14 += l15 * l9 + ((long)nArray3[i4 + 5] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[i4 + 6] = (int)(l14 += l15 * l10 + ((long)nArray3[i4 + 6] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[i4 + 7] = (int)(l14 += l15 * l11 + ((long)nArray3[i4 + 7] & 0xFFFFFFFFL));
            nArray3[i4 + 8] = (int)(l14 >>>= 32);
        }
    }

    public static void mul(int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l4 = (long)nArray2[n5 + 0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n5 + 1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n5 + 2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[n5 + 3] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[n5 + 4] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[n5 + 5] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[n5 + 6] & 0xFFFFFFFFL;
        long l11 = (long)nArray2[n5 + 7] & 0xFFFFFFFFL;
        long l12 = 0L;
        long l13 = (long)nArray[n4 + 0] & 0xFFFFFFFFL;
        nArray3[n6 + 0] = (int)(l12 += l13 * l4);
        l12 >>>= 32;
        nArray3[n6 + 1] = (int)(l12 += l13 * l5);
        l12 >>>= 32;
        nArray3[n6 + 2] = (int)(l12 += l13 * l6);
        l12 >>>= 32;
        nArray3[n6 + 3] = (int)(l12 += l13 * l7);
        l12 >>>= 32;
        nArray3[n6 + 4] = (int)(l12 += l13 * l8);
        l12 >>>= 32;
        nArray3[n6 + 5] = (int)(l12 += l13 * l9);
        l12 >>>= 32;
        nArray3[n6 + 6] = (int)(l12 += l13 * l10);
        l12 >>>= 32;
        nArray3[n6 + 7] = (int)(l12 += l13 * l11);
        nArray3[n6 + 8] = (int)(l12 >>>= 32);
        for (int i4 = 1; i4 < 8; ++i4) {
            long l14 = 0L;
            long l15 = (long)nArray[n4 + i4] & 0xFFFFFFFFL;
            nArray3[n6 + 0] = (int)(l14 += l15 * l4 + ((long)nArray3[++n6 + 0] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[n6 + 1] = (int)(l14 += l15 * l5 + ((long)nArray3[n6 + 1] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[n6 + 2] = (int)(l14 += l15 * l6 + ((long)nArray3[n6 + 2] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[n6 + 3] = (int)(l14 += l15 * l7 + ((long)nArray3[n6 + 3] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[n6 + 4] = (int)(l14 += l15 * l8 + ((long)nArray3[n6 + 4] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[n6 + 5] = (int)(l14 += l15 * l9 + ((long)nArray3[n6 + 5] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[n6 + 6] = (int)(l14 += l15 * l10 + ((long)nArray3[n6 + 6] & 0xFFFFFFFFL));
            l14 >>>= 32;
            nArray3[n6 + 7] = (int)(l14 += l15 * l11 + ((long)nArray3[n6 + 7] & 0xFFFFFFFFL));
            nArray3[n6 + 8] = (int)(l14 >>>= 32);
        }
    }

    public static int mulAddTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[4] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[5] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[6] & 0xFFFFFFFFL;
        long l11 = (long)nArray2[7] & 0xFFFFFFFFL;
        long l12 = 0L;
        for (int i4 = 0; i4 < 8; ++i4) {
            long l13 = 0L;
            long l14 = (long)nArray[i4] & 0xFFFFFFFFL;
            nArray3[i4 + 0] = (int)(l13 += l14 * l4 + ((long)nArray3[i4 + 0] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[i4 + 1] = (int)(l13 += l14 * l5 + ((long)nArray3[i4 + 1] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[i4 + 2] = (int)(l13 += l14 * l6 + ((long)nArray3[i4 + 2] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[i4 + 3] = (int)(l13 += l14 * l7 + ((long)nArray3[i4 + 3] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[i4 + 4] = (int)(l13 += l14 * l8 + ((long)nArray3[i4 + 4] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[i4 + 5] = (int)(l13 += l14 * l9 + ((long)nArray3[i4 + 5] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[i4 + 6] = (int)(l13 += l14 * l10 + ((long)nArray3[i4 + 6] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[i4 + 7] = (int)(l13 += l14 * l11 + ((long)nArray3[i4 + 7] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[i4 + 8] = (int)(l13 += l12 + ((long)nArray3[i4 + 8] & 0xFFFFFFFFL));
            l12 = l13 >>> 32;
        }
        return (int)l12;
    }

    public static int mulAddTo(int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l4 = (long)nArray2[n5 + 0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n5 + 1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n5 + 2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[n5 + 3] & 0xFFFFFFFFL;
        long l8 = (long)nArray2[n5 + 4] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[n5 + 5] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[n5 + 6] & 0xFFFFFFFFL;
        long l11 = (long)nArray2[n5 + 7] & 0xFFFFFFFFL;
        long l12 = 0L;
        for (int i4 = 0; i4 < 8; ++i4) {
            long l13 = 0L;
            long l14 = (long)nArray[n4 + i4] & 0xFFFFFFFFL;
            nArray3[n6 + 0] = (int)(l13 += l14 * l4 + ((long)nArray3[n6 + 0] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[n6 + 1] = (int)(l13 += l14 * l5 + ((long)nArray3[n6 + 1] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[n6 + 2] = (int)(l13 += l14 * l6 + ((long)nArray3[n6 + 2] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[n6 + 3] = (int)(l13 += l14 * l7 + ((long)nArray3[n6 + 3] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[n6 + 4] = (int)(l13 += l14 * l8 + ((long)nArray3[n6 + 4] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[n6 + 5] = (int)(l13 += l14 * l9 + ((long)nArray3[n6 + 5] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[n6 + 6] = (int)(l13 += l14 * l10 + ((long)nArray3[n6 + 6] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[n6 + 7] = (int)(l13 += l14 * l11 + ((long)nArray3[n6 + 7] & 0xFFFFFFFFL));
            l13 >>>= 32;
            nArray3[n6 + 8] = (int)(l13 += l12 + ((long)nArray3[n6 + 8] & 0xFFFFFFFFL));
            l12 = l13 >>> 32;
            ++n6;
        }
        return (int)l12;
    }

    public static long mul33Add(int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        long l6 = (long)nArray[n5 + 0] & 0xFFFFFFFFL;
        nArray3[n7 + 0] = (int)(l4 += l5 * l6 + ((long)nArray2[n6 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        long l7 = (long)nArray[n5 + 1] & 0xFFFFFFFFL;
        nArray3[n7 + 1] = (int)(l4 += l5 * l7 + l6 + ((long)nArray2[n6 + 1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        long l8 = (long)nArray[n5 + 2] & 0xFFFFFFFFL;
        nArray3[n7 + 2] = (int)(l4 += l5 * l8 + l7 + ((long)nArray2[n6 + 2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        long l9 = (long)nArray[n5 + 3] & 0xFFFFFFFFL;
        nArray3[n7 + 3] = (int)(l4 += l5 * l9 + l8 + ((long)nArray2[n6 + 3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        long l10 = (long)nArray[n5 + 4] & 0xFFFFFFFFL;
        nArray3[n7 + 4] = (int)(l4 += l5 * l10 + l9 + ((long)nArray2[n6 + 4] & 0xFFFFFFFFL));
        l4 >>>= 32;
        long l11 = (long)nArray[n5 + 5] & 0xFFFFFFFFL;
        nArray3[n7 + 5] = (int)(l4 += l5 * l11 + l10 + ((long)nArray2[n6 + 5] & 0xFFFFFFFFL));
        l4 >>>= 32;
        long l12 = (long)nArray[n5 + 6] & 0xFFFFFFFFL;
        nArray3[n7 + 6] = (int)(l4 += l5 * l12 + l11 + ((long)nArray2[n6 + 6] & 0xFFFFFFFFL));
        l4 >>>= 32;
        long l13 = (long)nArray[n5 + 7] & 0xFFFFFFFFL;
        nArray3[n7 + 7] = (int)(l4 += l5 * l13 + l12 + ((long)nArray2[n6 + 7] & 0xFFFFFFFFL));
        l4 >>>= 32;
        return l4 += l13;
    }

    public static int mulByWord(int n4, int[] nArray) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        nArray[0] = (int)(l4 += l5 * ((long)nArray[0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[1] = (int)(l4 += l5 * ((long)nArray[1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[2] = (int)(l4 += l5 * ((long)nArray[2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[3] = (int)(l4 += l5 * ((long)nArray[3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[4] = (int)(l4 += l5 * ((long)nArray[4] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[5] = (int)(l4 += l5 * ((long)nArray[5] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[6] = (int)(l4 += l5 * ((long)nArray[6] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[7] = (int)(l4 += l5 * ((long)nArray[7] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int mulByWordAddTo(int n4, int[] nArray, int[] nArray2) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        nArray2[0] = (int)(l4 += l5 * ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray[0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[1] = (int)(l4 += l5 * ((long)nArray2[1] & 0xFFFFFFFFL) + ((long)nArray[1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[2] = (int)(l4 += l5 * ((long)nArray2[2] & 0xFFFFFFFFL) + ((long)nArray[2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[3] = (int)(l4 += l5 * ((long)nArray2[3] & 0xFFFFFFFFL) + ((long)nArray[3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[4] = (int)(l4 += l5 * ((long)nArray2[4] & 0xFFFFFFFFL) + ((long)nArray[4] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[5] = (int)(l4 += l5 * ((long)nArray2[5] & 0xFFFFFFFFL) + ((long)nArray[5] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[6] = (int)(l4 += l5 * ((long)nArray2[6] & 0xFFFFFFFFL) + ((long)nArray[6] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[7] = (int)(l4 += l5 * ((long)nArray2[7] & 0xFFFFFFFFL) + ((long)nArray[7] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int mulWordAddTo(int n4, int[] nArray, int n5, int[] nArray2, int n6) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        nArray2[n6 + 0] = (int)(l4 += l5 * ((long)nArray[n5 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n6 + 1] = (int)(l4 += l5 * ((long)nArray[n5 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n6 + 2] = (int)(l4 += l5 * ((long)nArray[n5 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n6 + 3] = (int)(l4 += l5 * ((long)nArray[n5 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n6 + 4] = (int)(l4 += l5 * ((long)nArray[n5 + 4] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 4] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n6 + 5] = (int)(l4 += l5 * ((long)nArray[n5 + 5] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 5] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n6 + 6] = (int)(l4 += l5 * ((long)nArray[n5 + 6] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 6] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n6 + 7] = (int)(l4 += l5 * ((long)nArray[n5 + 7] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 7] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int mul33DWordAdd(int n4, long l4, int[] nArray, int n5) {
        long l5 = 0L;
        long l6 = (long)n4 & 0xFFFFFFFFL;
        long l7 = l4 & 0xFFFFFFFFL;
        nArray[n5 + 0] = (int)(l5 += l6 * l7 + ((long)nArray[n5 + 0] & 0xFFFFFFFFL));
        l5 >>>= 32;
        long l8 = l4 >>> 32;
        nArray[n5 + 1] = (int)(l5 += l6 * l8 + l7 + ((long)nArray[n5 + 1] & 0xFFFFFFFFL));
        l5 >>>= 32;
        nArray[n5 + 2] = (int)(l5 += l8 + ((long)nArray[n5 + 2] & 0xFFFFFFFFL));
        l5 >>>= 32;
        nArray[n5 + 3] = (int)(l5 += (long)nArray[n5 + 3] & 0xFFFFFFFFL);
        return (l5 >>>= 32) == 0L ? 0 : Nat.incAt(8, nArray, n5, 4);
    }

    public static int mul33WordAdd(int n4, int n5, int[] nArray, int n6) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        long l6 = (long)n5 & 0xFFFFFFFFL;
        nArray[n6 + 0] = (int)(l4 += l6 * l5 + ((long)nArray[n6 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[n6 + 1] = (int)(l4 += l6 + ((long)nArray[n6 + 1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[n6 + 2] = (int)(l4 += (long)nArray[n6 + 2] & 0xFFFFFFFFL);
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(8, nArray, n6, 3);
    }

    public static int mulWordDwordAdd(int n4, long l4, int[] nArray, int n5) {
        long l5 = 0L;
        long l6 = (long)n4 & 0xFFFFFFFFL;
        nArray[n5 + 0] = (int)(l5 += l6 * (l4 & 0xFFFFFFFFL) + ((long)nArray[n5 + 0] & 0xFFFFFFFFL));
        l5 >>>= 32;
        nArray[n5 + 1] = (int)(l5 += l6 * (l4 >>> 32) + ((long)nArray[n5 + 1] & 0xFFFFFFFFL));
        l5 >>>= 32;
        nArray[n5 + 2] = (int)(l5 += (long)nArray[n5 + 2] & 0xFFFFFFFFL);
        return (l5 >>>= 32) == 0L ? 0 : Nat.incAt(8, nArray, n5, 3);
    }

    public static int mulWord(int n4, int[] nArray, int[] nArray2, int n5) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        int n6 = 0;
        do {
            nArray2[n5 + n6] = (int)(l4 += l5 * ((long)nArray[n6] & 0xFFFFFFFFL));
            l4 >>>= 32;
        } while (++n6 < 8);
        return (int)l4;
    }

    public static void square(int[] nArray, int[] nArray2) {
        long l4;
        long l5;
        long l6 = (long)nArray[0] & 0xFFFFFFFFL;
        int n4 = 0;
        int n5 = 7;
        int n6 = 16;
        do {
            l5 = (long)nArray[n5--] & 0xFFFFFFFFL;
            l4 = l5 * l5;
            nArray2[--n6] = n4 << 31 | (int)(l4 >>> 33);
            nArray2[--n6] = (int)(l4 >>> 1);
            n4 = (int)l4;
        } while (n5 > 0);
        l5 = l6 * l6;
        long l7 = (long)(n4 << 31) & 0xFFFFFFFFL | l5 >>> 33;
        nArray2[0] = (int)l5;
        n4 = (int)(l5 >>> 32) & 1;
        long l8 = (long)nArray[1] & 0xFFFFFFFFL;
        l5 = (long)nArray2[2] & 0xFFFFFFFFL;
        int n7 = (int)(l7 += l8 * l6);
        nArray2[1] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        l5 += l7 >>> 32;
        l4 = (long)nArray[2] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[4] & 0xFFFFFFFFL;
        n7 = (int)(l5 += l4 * l6);
        nArray2[2] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        l9 &= 0xFFFFFFFFL;
        long l11 = (long)nArray[3] & 0xFFFFFFFFL;
        long l12 = ((long)nArray2[5] & 0xFFFFFFFFL) + ((l10 += (l9 += (l5 >>> 32) + l4 * l8) >>> 32) >>> 32);
        l10 &= 0xFFFFFFFFL;
        long l13 = ((long)nArray2[6] & 0xFFFFFFFFL) + (l12 >>> 32);
        l12 &= 0xFFFFFFFFL;
        n7 = (int)(l9 += l11 * l6);
        nArray2[3] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        l10 &= 0xFFFFFFFFL;
        l12 &= 0xFFFFFFFFL;
        long l14 = (long)nArray[4] & 0xFFFFFFFFL;
        long l15 = ((long)nArray2[7] & 0xFFFFFFFFL) + ((l13 += (l12 += ((l10 += (l9 >>> 32) + l11 * l8) >>> 32) + l11 * l4) >>> 32) >>> 32);
        l13 &= 0xFFFFFFFFL;
        long l16 = ((long)nArray2[8] & 0xFFFFFFFFL) + (l15 >>> 32);
        l15 &= 0xFFFFFFFFL;
        n7 = (int)(l10 += l14 * l6);
        nArray2[4] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        l12 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        l15 &= 0xFFFFFFFFL;
        long l17 = (long)nArray[5] & 0xFFFFFFFFL;
        long l18 = ((long)nArray2[9] & 0xFFFFFFFFL) + ((l16 += (l15 += ((l13 += ((l12 += (l10 >>> 32) + l14 * l8) >>> 32) + l14 * l4) >>> 32) + l14 * l11) >>> 32) >>> 32);
        l16 &= 0xFFFFFFFFL;
        long l19 = ((long)nArray2[10] & 0xFFFFFFFFL) + (l18 >>> 32);
        l18 &= 0xFFFFFFFFL;
        n7 = (int)(l12 += l17 * l6);
        nArray2[5] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        l13 &= 0xFFFFFFFFL;
        l15 &= 0xFFFFFFFFL;
        l16 &= 0xFFFFFFFFL;
        l18 &= 0xFFFFFFFFL;
        long l20 = (long)nArray[6] & 0xFFFFFFFFL;
        long l21 = ((long)nArray2[11] & 0xFFFFFFFFL) + ((l19 += (l18 += ((l16 += ((l15 += ((l13 += (l12 >>> 32) + l17 * l8) >>> 32) + l17 * l4) >>> 32) + l17 * l11) >>> 32) + l17 * l14) >>> 32) >>> 32);
        l19 &= 0xFFFFFFFFL;
        long l22 = ((long)nArray2[12] & 0xFFFFFFFFL) + (l21 >>> 32);
        l21 &= 0xFFFFFFFFL;
        n7 = (int)(l13 += l20 * l6);
        nArray2[6] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        l15 &= 0xFFFFFFFFL;
        l16 &= 0xFFFFFFFFL;
        l18 &= 0xFFFFFFFFL;
        l19 &= 0xFFFFFFFFL;
        l21 &= 0xFFFFFFFFL;
        long l23 = (long)nArray[7] & 0xFFFFFFFFL;
        long l24 = ((long)nArray2[13] & 0xFFFFFFFFL) + ((l22 += (l21 += ((l19 += ((l18 += ((l16 += ((l15 += (l13 >>> 32) + l20 * l8) >>> 32) + l20 * l4) >>> 32) + l20 * l11) >>> 32) + l20 * l14) >>> 32) + l20 * l17) >>> 32) >>> 32);
        l22 &= 0xFFFFFFFFL;
        long l25 = ((long)nArray2[14] & 0xFFFFFFFFL) + (l24 >>> 32);
        l24 &= 0xFFFFFFFFL;
        n7 = (int)(l15 += l23 * l6);
        nArray2[7] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        l25 += (l24 += ((l22 += ((l21 += ((l19 += ((l18 += ((l16 += (l15 >>> 32) + l23 * l8) >>> 32) + l23 * l4) >>> 32) + l23 * l11) >>> 32) + l23 * l14) >>> 32) + l23 * l17) >>> 32) + l23 * l20) >>> 32;
        n7 = (int)l16;
        nArray2[8] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        n7 = (int)l18;
        nArray2[9] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        n7 = (int)l19;
        nArray2[10] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        n7 = (int)l21;
        nArray2[11] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        n7 = (int)l22;
        nArray2[12] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        n7 = (int)l24;
        nArray2[13] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        n7 = (int)l25;
        nArray2[14] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        n7 = nArray2[15] + (int)(l25 >>> 32);
        nArray2[15] = n7 << 1 | n4;
    }

    public static void square(int[] nArray, int n4, int[] nArray2, int n5) {
        long l4;
        long l5;
        long l6 = (long)nArray[n4 + 0] & 0xFFFFFFFFL;
        int n6 = 0;
        int n7 = 7;
        int n8 = 16;
        do {
            l5 = (long)nArray[n4 + n7--] & 0xFFFFFFFFL;
            l4 = l5 * l5;
            nArray2[n5 + --n8] = n6 << 31 | (int)(l4 >>> 33);
            nArray2[n5 + --n8] = (int)(l4 >>> 1);
            n6 = (int)l4;
        } while (n7 > 0);
        l5 = l6 * l6;
        long l7 = (long)(n6 << 31) & 0xFFFFFFFFL | l5 >>> 33;
        nArray2[n5 + 0] = (int)l5;
        n6 = (int)(l5 >>> 32) & 1;
        long l8 = (long)nArray[n4 + 1] & 0xFFFFFFFFL;
        l5 = (long)nArray2[n5 + 2] & 0xFFFFFFFFL;
        int n9 = (int)(l7 += l8 * l6);
        nArray2[n5 + 1] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        l5 += l7 >>> 32;
        l4 = (long)nArray[n4 + 2] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[n5 + 3] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[n5 + 4] & 0xFFFFFFFFL;
        n9 = (int)(l5 += l4 * l6);
        nArray2[n5 + 2] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        l9 &= 0xFFFFFFFFL;
        long l11 = (long)nArray[n4 + 3] & 0xFFFFFFFFL;
        long l12 = ((long)nArray2[n5 + 5] & 0xFFFFFFFFL) + ((l10 += (l9 += (l5 >>> 32) + l4 * l8) >>> 32) >>> 32);
        l10 &= 0xFFFFFFFFL;
        long l13 = ((long)nArray2[n5 + 6] & 0xFFFFFFFFL) + (l12 >>> 32);
        l12 &= 0xFFFFFFFFL;
        n9 = (int)(l9 += l11 * l6);
        nArray2[n5 + 3] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        l10 &= 0xFFFFFFFFL;
        l12 &= 0xFFFFFFFFL;
        long l14 = (long)nArray[n4 + 4] & 0xFFFFFFFFL;
        long l15 = ((long)nArray2[n5 + 7] & 0xFFFFFFFFL) + ((l13 += (l12 += ((l10 += (l9 >>> 32) + l11 * l8) >>> 32) + l11 * l4) >>> 32) >>> 32);
        l13 &= 0xFFFFFFFFL;
        long l16 = ((long)nArray2[n5 + 8] & 0xFFFFFFFFL) + (l15 >>> 32);
        l15 &= 0xFFFFFFFFL;
        n9 = (int)(l10 += l14 * l6);
        nArray2[n5 + 4] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        l12 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        l15 &= 0xFFFFFFFFL;
        long l17 = (long)nArray[n4 + 5] & 0xFFFFFFFFL;
        long l18 = ((long)nArray2[n5 + 9] & 0xFFFFFFFFL) + ((l16 += (l15 += ((l13 += ((l12 += (l10 >>> 32) + l14 * l8) >>> 32) + l14 * l4) >>> 32) + l14 * l11) >>> 32) >>> 32);
        l16 &= 0xFFFFFFFFL;
        long l19 = ((long)nArray2[n5 + 10] & 0xFFFFFFFFL) + (l18 >>> 32);
        l18 &= 0xFFFFFFFFL;
        n9 = (int)(l12 += l17 * l6);
        nArray2[n5 + 5] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        l13 &= 0xFFFFFFFFL;
        l15 &= 0xFFFFFFFFL;
        l16 &= 0xFFFFFFFFL;
        l18 &= 0xFFFFFFFFL;
        long l20 = (long)nArray[n4 + 6] & 0xFFFFFFFFL;
        long l21 = ((long)nArray2[n5 + 11] & 0xFFFFFFFFL) + ((l19 += (l18 += ((l16 += ((l15 += ((l13 += (l12 >>> 32) + l17 * l8) >>> 32) + l17 * l4) >>> 32) + l17 * l11) >>> 32) + l17 * l14) >>> 32) >>> 32);
        l19 &= 0xFFFFFFFFL;
        long l22 = ((long)nArray2[n5 + 12] & 0xFFFFFFFFL) + (l21 >>> 32);
        l21 &= 0xFFFFFFFFL;
        n9 = (int)(l13 += l20 * l6);
        nArray2[n5 + 6] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        l15 &= 0xFFFFFFFFL;
        l16 &= 0xFFFFFFFFL;
        l18 &= 0xFFFFFFFFL;
        l19 &= 0xFFFFFFFFL;
        l21 &= 0xFFFFFFFFL;
        long l23 = (long)nArray[n4 + 7] & 0xFFFFFFFFL;
        long l24 = ((long)nArray2[n5 + 13] & 0xFFFFFFFFL) + ((l22 += (l21 += ((l19 += ((l18 += ((l16 += ((l15 += (l13 >>> 32) + l20 * l8) >>> 32) + l20 * l4) >>> 32) + l20 * l11) >>> 32) + l20 * l14) >>> 32) + l20 * l17) >>> 32) >>> 32);
        l22 &= 0xFFFFFFFFL;
        long l25 = ((long)nArray2[n5 + 14] & 0xFFFFFFFFL) + (l24 >>> 32);
        l24 &= 0xFFFFFFFFL;
        n9 = (int)(l15 += l23 * l6);
        nArray2[n5 + 7] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        l25 += (l24 += ((l22 += ((l21 += ((l19 += ((l18 += ((l16 += (l15 >>> 32) + l23 * l8) >>> 32) + l23 * l4) >>> 32) + l23 * l11) >>> 32) + l23 * l14) >>> 32) + l23 * l17) >>> 32) + l23 * l20) >>> 32;
        n9 = (int)l16;
        nArray2[n5 + 8] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        n9 = (int)l18;
        nArray2[n5 + 9] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        n9 = (int)l19;
        nArray2[n5 + 10] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        n9 = (int)l21;
        nArray2[n5 + 11] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        n9 = (int)l22;
        nArray2[n5 + 12] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        n9 = (int)l24;
        nArray2[n5 + 13] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        n9 = (int)l25;
        nArray2[n5 + 14] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        n9 = nArray2[n5 + 15] + (int)(l25 >>> 32);
        nArray2[n5 + 15] = n9 << 1 | n6;
    }

    public static int sub(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        nArray3[0] = (int)(l4 += ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[1] = (int)(l4 += ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[2] = (int)(l4 += ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[3] = (int)(l4 += ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[4] = (int)(l4 += ((long)nArray[4] & 0xFFFFFFFFL) - ((long)nArray2[4] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[5] = (int)(l4 += ((long)nArray[5] & 0xFFFFFFFFL) - ((long)nArray2[5] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[6] = (int)(l4 += ((long)nArray[6] & 0xFFFFFFFFL) - ((long)nArray2[6] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[7] = (int)(l4 += ((long)nArray[7] & 0xFFFFFFFFL) - ((long)nArray2[7] & 0xFFFFFFFFL));
        return (int)(l4 >>= 32);
    }

    public static int sub(int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l4 = 0L;
        nArray3[n6 + 0] = (int)(l4 += ((long)nArray[n4 + 0] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 0] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[n6 + 1] = (int)(l4 += ((long)nArray[n4 + 1] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 1] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[n6 + 2] = (int)(l4 += ((long)nArray[n4 + 2] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 2] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[n6 + 3] = (int)(l4 += ((long)nArray[n4 + 3] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 3] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[n6 + 4] = (int)(l4 += ((long)nArray[n4 + 4] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 4] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[n6 + 5] = (int)(l4 += ((long)nArray[n4 + 5] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 5] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[n6 + 6] = (int)(l4 += ((long)nArray[n4 + 6] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 6] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[n6 + 7] = (int)(l4 += ((long)nArray[n4 + 7] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 7] & 0xFFFFFFFFL));
        return (int)(l4 >>= 32);
    }

    public static int subBothFrom(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        nArray3[0] = (int)(l4 += ((long)nArray3[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[1] = (int)(l4 += ((long)nArray3[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[2] = (int)(l4 += ((long)nArray3[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[3] = (int)(l4 += ((long)nArray3[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[4] = (int)(l4 += ((long)nArray3[4] & 0xFFFFFFFFL) - ((long)nArray[4] & 0xFFFFFFFFL) - ((long)nArray2[4] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[5] = (int)(l4 += ((long)nArray3[5] & 0xFFFFFFFFL) - ((long)nArray[5] & 0xFFFFFFFFL) - ((long)nArray2[5] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[6] = (int)(l4 += ((long)nArray3[6] & 0xFFFFFFFFL) - ((long)nArray[6] & 0xFFFFFFFFL) - ((long)nArray2[6] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[7] = (int)(l4 += ((long)nArray3[7] & 0xFFFFFFFFL) - ((long)nArray[7] & 0xFFFFFFFFL) - ((long)nArray2[7] & 0xFFFFFFFFL));
        return (int)(l4 >>= 32);
    }

    public static int subFrom(int[] nArray, int[] nArray2) {
        long l4 = 0L;
        nArray2[0] = (int)(l4 += ((long)nArray2[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[1] = (int)(l4 += ((long)nArray2[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[2] = (int)(l4 += ((long)nArray2[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[3] = (int)(l4 += ((long)nArray2[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[4] = (int)(l4 += ((long)nArray2[4] & 0xFFFFFFFFL) - ((long)nArray[4] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[5] = (int)(l4 += ((long)nArray2[5] & 0xFFFFFFFFL) - ((long)nArray[5] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[6] = (int)(l4 += ((long)nArray2[6] & 0xFFFFFFFFL) - ((long)nArray[6] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[7] = (int)(l4 += ((long)nArray2[7] & 0xFFFFFFFFL) - ((long)nArray[7] & 0xFFFFFFFFL));
        return (int)(l4 >>= 32);
    }

    public static int subFrom(int[] nArray, int n4, int[] nArray2, int n5) {
        long l4 = 0L;
        nArray2[n5 + 0] = (int)(l4 += ((long)nArray2[n5 + 0] & 0xFFFFFFFFL) - ((long)nArray[n4 + 0] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[n5 + 1] = (int)(l4 += ((long)nArray2[n5 + 1] & 0xFFFFFFFFL) - ((long)nArray[n4 + 1] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[n5 + 2] = (int)(l4 += ((long)nArray2[n5 + 2] & 0xFFFFFFFFL) - ((long)nArray[n4 + 2] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[n5 + 3] = (int)(l4 += ((long)nArray2[n5 + 3] & 0xFFFFFFFFL) - ((long)nArray[n4 + 3] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[n5 + 4] = (int)(l4 += ((long)nArray2[n5 + 4] & 0xFFFFFFFFL) - ((long)nArray[n4 + 4] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[n5 + 5] = (int)(l4 += ((long)nArray2[n5 + 5] & 0xFFFFFFFFL) - ((long)nArray[n4 + 5] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[n5 + 6] = (int)(l4 += ((long)nArray2[n5 + 6] & 0xFFFFFFFFL) - ((long)nArray[n4 + 6] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[n5 + 7] = (int)(l4 += ((long)nArray2[n5 + 7] & 0xFFFFFFFFL) - ((long)nArray[n4 + 7] & 0xFFFFFFFFL));
        return (int)(l4 >>= 32);
    }

    public static BigInteger toBigInteger(int[] nArray) {
        byte[] byArray = new byte[32];
        for (int i4 = 0; i4 < 8; ++i4) {
            int n4 = nArray[i4];
            if (n4 == 0) continue;
            Pack.intToBigEndian(n4, byArray, 7 - i4 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static BigInteger toBigInteger64(long[] lArray) {
        byte[] byArray = new byte[32];
        for (int i4 = 0; i4 < 4; ++i4) {
            long l4 = lArray[i4];
            if (l4 == 0L) continue;
            Pack.longToBigEndian(l4, byArray, 3 - i4 << 3);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] nArray) {
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
    }
}

