/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat512;

public class SecP521R1Field {
    static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 511};
    private static final int P16 = 511;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n4 = Nat.add(16, nArray, nArray2, nArray3) + nArray[16] + nArray2[16];
        if (n4 > 511 || n4 == 511 && Nat.eq(16, nArray3, P)) {
            n4 += Nat.inc(16, nArray3);
            n4 &= 0x1FF;
        }
        nArray3[16] = n4;
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        int n4 = Nat.inc(16, nArray, nArray2) + nArray[16];
        if (n4 > 511 || n4 == 511 && Nat.eq(16, nArray2, P)) {
            n4 += Nat.inc(16, nArray2);
            n4 &= 0x1FF;
        }
        nArray2[16] = n4;
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        int[] nArray = Nat.fromBigInteger(521, bigInteger);
        if (Nat.eq(17, nArray, P)) {
            Nat.zero(17, nArray);
        }
        return nArray;
    }

    public static void half(int[] nArray, int[] nArray2) {
        int n4 = nArray[16];
        int n5 = Nat.shiftDownBit(16, nArray, n4, nArray2);
        nArray2[16] = n4 >>> 1 | n5 >>> 23;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat.create(33);
        SecP521R1Field.implMultiply(nArray, nArray2, nArray4);
        SecP521R1Field.reduce(nArray4, nArray3);
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (Nat.isZero(17, nArray)) {
            Nat.zero(17, nArray2);
        } else {
            Nat.sub(17, P, nArray, nArray2);
        }
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        int n4 = nArray[32];
        int n5 = Nat.shiftDownBits(16, nArray, 16, 9, n4, nArray2, 0) >>> 23;
        n5 += n4 >>> 9;
        if ((n5 += Nat.addTo(16, nArray, nArray2)) > 511 || n5 == 511 && Nat.eq(16, nArray2, P)) {
            n5 += Nat.inc(16, nArray2);
            n5 &= 0x1FF;
        }
        nArray2[16] = n5;
    }

    public static void reduce23(int[] nArray) {
        int n4 = nArray[16];
        int n5 = Nat.addWordTo(16, n4 >>> 9, nArray) + (n4 & 0x1FF);
        if (n5 > 511 || n5 == 511 && Nat.eq(16, nArray, P)) {
            n5 += Nat.inc(16, nArray);
            n5 &= 0x1FF;
        }
        nArray[16] = n5;
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat.create(33);
        SecP521R1Field.implSquare(nArray, nArray3);
        SecP521R1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n4, int[] nArray2) {
        int[] nArray3 = Nat.create(33);
        SecP521R1Field.implSquare(nArray, nArray3);
        SecP521R1Field.reduce(nArray3, nArray2);
        while (--n4 > 0) {
            SecP521R1Field.implSquare(nArray2, nArray3);
            SecP521R1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        int n4 = Nat.sub(16, nArray, nArray2, nArray3) + nArray[16] - nArray2[16];
        if (n4 < 0) {
            n4 += Nat.dec(16, nArray3);
            n4 &= 0x1FF;
        }
        nArray3[16] = n4;
    }

    public static void twice(int[] nArray, int[] nArray2) {
        int n4 = nArray[16];
        int n5 = Nat.shiftUpBit(16, nArray, n4 << 23, nArray2) | n4 << 1;
        nArray2[16] = n5 & 0x1FF;
    }

    protected static void implMultiply(int[] nArray, int[] nArray2, int[] nArray3) {
        Nat512.mul(nArray, nArray2, nArray3);
        int n4 = nArray[16];
        int n5 = nArray2[16];
        nArray3[32] = Nat.mul31BothAdd(16, n4, nArray2, n5, nArray, nArray3, 16) + n4 * n5;
    }

    protected static void implSquare(int[] nArray, int[] nArray2) {
        Nat512.square(nArray, nArray2);
        int n4 = nArray[16];
        nArray2[32] = Nat.mulWordAddTo(16, n4 << 1, nArray, 0, nArray2, 16) + n4 * n4;
    }
}

