/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.bouncycastle.math.ec.PreCompInfo;

public class FixedPointUtil {
    public static final String PRECOMP_NAME = "bc_fixed_point";

    public static int getCombSize(ECCurve eCCurve) {
        BigInteger bigInteger = eCCurve.getOrder();
        return bigInteger == null ? eCCurve.getFieldSize() + 1 : bigInteger.bitLength();
    }

    public static FixedPointPreCompInfo getFixedPointPreCompInfo(PreCompInfo preCompInfo) {
        if (preCompInfo != null && preCompInfo instanceof FixedPointPreCompInfo) {
            return (FixedPointPreCompInfo)preCompInfo;
        }
        return new FixedPointPreCompInfo();
    }

    public static FixedPointPreCompInfo precompute(ECPoint eCPoint, int n4) {
        ECCurve eCCurve = eCPoint.getCurve();
        int n5 = 1 << n4;
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.getFixedPointPreCompInfo(eCCurve.getPreCompInfo(eCPoint, PRECOMP_NAME));
        ECPoint[] eCPointArray = fixedPointPreCompInfo.getPreComp();
        if (eCPointArray == null || eCPointArray.length < n5) {
            int n6;
            int n7 = FixedPointUtil.getCombSize(eCCurve);
            int n8 = (n7 + n4 - 1) / n4;
            ECPoint[] eCPointArray2 = new ECPoint[n4];
            eCPointArray2[0] = eCPoint;
            for (n6 = 1; n6 < n4; ++n6) {
                eCPointArray2[n6] = eCPointArray2[n6 - 1].timesPow2(n8);
            }
            eCCurve.normalizeAll(eCPointArray2);
            eCPointArray = new ECPoint[n5];
            eCPointArray[0] = eCCurve.getInfinity();
            for (n6 = n4 - 1; n6 >= 0; --n6) {
                int n9;
                ECPoint eCPoint2 = eCPointArray2[n6];
                for (int i4 = n9 = 1 << n6; i4 < n5; i4 += n9 << 1) {
                    eCPointArray[i4] = eCPointArray[i4 - n9].add(eCPoint2);
                }
            }
            eCCurve.normalizeAll(eCPointArray);
            fixedPointPreCompInfo.setPreComp(eCPointArray);
            fixedPointPreCompInfo.setWidth(n4);
            eCCurve.setPreCompInfo(eCPoint, PRECOMP_NAME, fixedPointPreCompInfo);
        }
        return fixedPointPreCompInfo;
    }
}

