/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECMultiplier;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.bouncycastle.math.ec.FixedPointUtil;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECCurve eCCurve = eCPoint.getCurve();
        int n4 = FixedPointUtil.getCombSize(eCCurve);
        if (bigInteger.bitLength() > n4) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        int n5 = this.getWidthForCombSize(n4);
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute(eCPoint, n5);
        ECPoint[] eCPointArray = fixedPointPreCompInfo.getPreComp();
        int n6 = fixedPointPreCompInfo.getWidth();
        int n7 = (n4 + n6 - 1) / n6;
        ECPoint eCPoint2 = eCCurve.getInfinity();
        int n8 = n7 * n6 - 1;
        for (int i4 = 0; i4 < n7; ++i4) {
            int n9 = 0;
            for (int i5 = n8 - i4; i5 >= 0; i5 -= n7) {
                n9 <<= 1;
                if (!bigInteger.testBit(i5)) continue;
                n9 |= 1;
            }
            eCPoint2 = eCPoint2.twicePlus(eCPointArray[n9]);
        }
        return eCPoint2;
    }

    protected int getWidthForCombSize(int n4) {
        return n4 > 257 ? 6 : 5;
    }
}

