/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsAEADCipher
implements TlsCipher {
    public static final int NONCE_RFC5288 = 1;
    static final int NONCE_DRAFT_CHACHA20_POLY1305 = 2;
    protected TlsContext context;
    protected int macSize;
    protected int record_iv_length;
    protected AEADBlockCipher encryptCipher;
    protected AEADBlockCipher decryptCipher;
    protected byte[] encryptImplicitNonce;
    protected byte[] decryptImplicitNonce;
    protected int nonceMode;

    public TlsAEADCipher(TlsContext tlsContext, AEADBlockCipher aEADBlockCipher, AEADBlockCipher aEADBlockCipher2, int n4, int n5) throws IOException {
        this(tlsContext, aEADBlockCipher, aEADBlockCipher2, n4, n5, 1);
    }

    TlsAEADCipher(TlsContext tlsContext, AEADBlockCipher aEADBlockCipher, AEADBlockCipher aEADBlockCipher2, int n4, int n5, int n6) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        int n7;
        if (!TlsUtils.isTLSv12(tlsContext)) {
            throw new TlsFatalAlert(80);
        }
        this.nonceMode = n6;
        switch (n6) {
            case 1: {
                n7 = 4;
                this.record_iv_length = 8;
                break;
            }
            case 2: {
                n7 = 12;
                this.record_iv_length = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        this.context = tlsContext;
        this.macSize = n5;
        int n8 = 2 * n4 + 2 * n7;
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, n8);
        int n9 = 0;
        KeyParameter keyParameter3 = new KeyParameter(byArray, n9, n4);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n9 += n4, n4);
        byte[] byArray2 = Arrays.copyOfRange(byArray, n9 += n4, n9 + n7);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n9 += n7, n9 + n7);
        if ((n9 += n7) != n8) {
            throw new TlsFatalAlert(80);
        }
        if (tlsContext.isServer()) {
            this.encryptCipher = aEADBlockCipher2;
            this.decryptCipher = aEADBlockCipher;
            this.encryptImplicitNonce = byArray3;
            this.decryptImplicitNonce = byArray2;
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
        } else {
            this.encryptCipher = aEADBlockCipher;
            this.decryptCipher = aEADBlockCipher2;
            this.encryptImplicitNonce = byArray2;
            this.decryptImplicitNonce = byArray3;
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
        }
        byte[] byArray4 = new byte[n7 + this.record_iv_length];
        this.encryptCipher.init(true, new AEADParameters(keyParameter2, 8 * n5, byArray4));
        this.decryptCipher.init(false, new AEADParameters(keyParameter, 8 * n5, byArray4));
    }

    public int getPlaintextLimit(int n4) {
        return n4 - this.macSize - this.record_iv_length;
    }

    public byte[] encodePlaintext(long l4, short s4, byte[] byArray, int n4, int n5) throws IOException {
        int n6;
        byte[] byArray2 = new byte[this.encryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.encryptImplicitNonce, 0, byArray2, 0, this.encryptImplicitNonce.length);
                TlsUtils.writeUint64(l4, byArray2, this.encryptImplicitNonce.length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(l4, byArray2, byArray2.length - 8);
                for (n6 = 0; n6 < this.encryptImplicitNonce.length; ++n6) {
                    int n7 = n6;
                    byArray2[n7] = (byte)(byArray2[n7] ^ this.encryptImplicitNonce[n6]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n6 = n4;
        int n8 = n5;
        int n9 = this.encryptCipher.getOutputSize(n8);
        byte[] byArray3 = new byte[this.record_iv_length + n9];
        if (this.record_iv_length != 0) {
            System.arraycopy(byArray2, byArray2.length - this.record_iv_length, byArray3, 0, this.record_iv_length);
        }
        int n10 = this.record_iv_length;
        byte[] byArray4 = this.getAdditionalData(l4, s4, n8);
        AEADParameters aEADParameters = new AEADParameters(null, 8 * this.macSize, byArray2, byArray4);
        try {
            this.encryptCipher.init(true, aEADParameters);
            n10 += this.encryptCipher.processBytes(byArray, n6, n8, byArray3, n10);
            n10 += this.encryptCipher.doFinal(byArray3, n10);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(80, (Throwable)exception);
        }
        if (n10 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray3;
    }

    public byte[] decodeCiphertext(long l4, short s4, byte[] byArray, int n4, int n5) throws IOException {
        int n6;
        if (this.getPlaintextLimit(n5) < 0) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray2 = new byte[this.decryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.decryptImplicitNonce, 0, byArray2, 0, this.decryptImplicitNonce.length);
                System.arraycopy(byArray, n4, byArray2, byArray2.length - this.record_iv_length, this.record_iv_length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(l4, byArray2, byArray2.length - 8);
                for (n6 = 0; n6 < this.decryptImplicitNonce.length; ++n6) {
                    int n7 = n6;
                    byArray2[n7] = (byte)(byArray2[n7] ^ this.decryptImplicitNonce[n6]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n6 = n4 + this.record_iv_length;
        int n8 = n5 - this.record_iv_length;
        int n9 = this.decryptCipher.getOutputSize(n8);
        byte[] byArray3 = new byte[n9];
        int n10 = 0;
        byte[] byArray4 = this.getAdditionalData(l4, s4, n9);
        AEADParameters aEADParameters = new AEADParameters(null, 8 * this.macSize, byArray2, byArray4);
        try {
            this.decryptCipher.init(false, aEADParameters);
            n10 += this.decryptCipher.processBytes(byArray, n6, n8, byArray3, n10);
            n10 += this.decryptCipher.doFinal(byArray3, n10);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(20, (Throwable)exception);
        }
        if (n10 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray3;
    }

    protected byte[] getAdditionalData(long l4, short s4, int n4) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(l4, byArray, 0);
        TlsUtils.writeUint8(s4, byArray, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(n4, byArray, 11);
        return byArray;
    }
}

