/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

class DTLSReplayWindow {
    private static final long VALID_SEQ_MASK = 0xFFFFFFFFFFFFL;
    private static final long WINDOW_SIZE = 64L;
    private long latestConfirmedSeq = -1L;
    private long bitmap = 0L;

    DTLSReplayWindow() {
    }

    boolean shouldDiscard(long l4) {
        if ((l4 & 0xFFFFFFFFFFFFL) != l4) {
            return true;
        }
        if (l4 <= this.latestConfirmedSeq) {
            long l5 = this.latestConfirmedSeq - l4;
            if (l5 >= 64L) {
                return true;
            }
            if ((this.bitmap & 1L << (int)l5) != 0L) {
                return true;
            }
        }
        return false;
    }

    void reportAuthenticated(long l4) {
        if ((l4 & 0xFFFFFFFFFFFFL) != l4) {
            throw new IllegalArgumentException("'seq' out of range");
        }
        if (l4 <= this.latestConfirmedSeq) {
            long l5 = this.latestConfirmedSeq - l4;
            if (l5 < 64L) {
                this.bitmap |= 1L << (int)l5;
            }
        } else {
            long l6 = l4 - this.latestConfirmedSeq;
            if (l6 >= 64L) {
                this.bitmap = 1L;
            } else {
                this.bitmap <<= (int)l6;
                this.bitmap |= 1L;
            }
            this.latestConfirmedSeq = l4;
        }
    }

    void reset() {
        this.latestConfirmedSeq = -1L;
        this.bitmap = 0L;
    }
}

