/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.prng.drbg;

import org.bouncycastle.math.ec.ECPoint;

public class DualECPoints {
    private final ECPoint p;
    private final ECPoint q;
    private final int securityStrength;
    private final int cofactor;

    public DualECPoints(int n4, ECPoint eCPoint, ECPoint eCPoint2, int n5) {
        if (!eCPoint.getCurve().equals(eCPoint2.getCurve())) {
            throw new IllegalArgumentException("points need to be on the same curve");
        }
        this.securityStrength = n4;
        this.p = eCPoint;
        this.q = eCPoint2;
        this.cofactor = n5;
    }

    public int getSeedLen() {
        return this.p.getCurve().getFieldSize();
    }

    public int getMaxOutlen() {
        return (this.p.getCurve().getFieldSize() - (13 + DualECPoints.log2(this.cofactor))) / 8 * 8;
    }

    public ECPoint getP() {
        return this.p;
    }

    public ECPoint getQ() {
        return this.q;
    }

    public int getSecurityStrength() {
        return this.securityStrength;
    }

    public int getCofactor() {
        return this.cofactor;
    }

    private static int log2(int n4) {
        int n5 = 0;
        while ((n4 >>= 1) != 0) {
            ++n5;
        }
        return n5;
    }
}

