/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.util.Pack;

public abstract class GCMUtil {
    private static final int E1 = -520093696;
    private static final long E1L = -2233785415175766016L;
    private static final int[] LOOKUP = GCMUtil.generateLookup();

    private static int[] generateLookup() {
        int[] nArray = new int[256];
        for (int i4 = 0; i4 < 256; ++i4) {
            int n4 = 0;
            for (int i5 = 7; i5 >= 0; --i5) {
                if ((i4 & 1 << i5) == 0) continue;
                n4 ^= -520093696 >>> 7 - i5;
            }
            nArray[i4] = n4;
        }
        return nArray;
    }

    public static byte[] oneAsBytes() {
        byte[] byArray = new byte[16];
        byArray[0] = -128;
        return byArray;
    }

    public static int[] oneAsInts() {
        int[] nArray = new int[4];
        nArray[0] = Integer.MIN_VALUE;
        return nArray;
    }

    public static long[] oneAsLongs() {
        long[] lArray = new long[2];
        lArray[0] = Long.MIN_VALUE;
        return lArray;
    }

    public static byte[] asBytes(int[] nArray) {
        byte[] byArray = new byte[16];
        Pack.intToBigEndian(nArray, byArray, 0);
        return byArray;
    }

    public static void asBytes(int[] nArray, byte[] byArray) {
        Pack.intToBigEndian(nArray, byArray, 0);
    }

    public static byte[] asBytes(long[] lArray) {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(lArray, byArray, 0);
        return byArray;
    }

    public static void asBytes(long[] lArray, byte[] byArray) {
        Pack.longToBigEndian(lArray, byArray, 0);
    }

    public static int[] asInts(byte[] byArray) {
        int[] nArray = new int[4];
        Pack.bigEndianToInt(byArray, 0, nArray);
        return nArray;
    }

    public static void asInts(byte[] byArray, int[] nArray) {
        Pack.bigEndianToInt(byArray, 0, nArray);
    }

    public static long[] asLongs(byte[] byArray) {
        long[] lArray = new long[2];
        Pack.bigEndianToLong(byArray, 0, lArray);
        return lArray;
    }

    public static void asLongs(byte[] byArray, long[] lArray) {
        Pack.bigEndianToLong(byArray, 0, lArray);
    }

    public static void multiply(byte[] byArray, byte[] byArray2) {
        int[] nArray = GCMUtil.asInts(byArray);
        int[] nArray2 = GCMUtil.asInts(byArray2);
        GCMUtil.multiply(nArray, nArray2);
        GCMUtil.asBytes(nArray, byArray);
    }

    public static void multiply(int[] nArray, int[] nArray2) {
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        int n7 = nArray[3];
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (int i4 = 0; i4 < 4; ++i4) {
            int n12 = nArray2[i4];
            for (int i5 = 0; i5 < 32; ++i5) {
                int n13 = n12 >> 31;
                n12 <<= 1;
                n8 ^= n4 & n13;
                n9 ^= n5 & n13;
                n10 ^= n6 & n13;
                n11 ^= n7 & n13;
                int n14 = n7 << 31 >> 8;
                n7 = n7 >>> 1 | n6 << 31;
                n6 = n6 >>> 1 | n5 << 31;
                n5 = n5 >>> 1 | n4 << 31;
                n4 = n4 >>> 1 ^ n14 & 0xE1000000;
            }
        }
        nArray[0] = n8;
        nArray[1] = n9;
        nArray[2] = n10;
        nArray[3] = n11;
    }

    public static void multiply(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = 0L;
        long l7 = 0L;
        for (int i4 = 0; i4 < 2; ++i4) {
            long l8 = lArray2[i4];
            for (int i5 = 0; i5 < 64; ++i5) {
                long l9 = l8 >> 63;
                l8 <<= 1;
                l6 ^= l4 & l9;
                l7 ^= l5 & l9;
                long l10 = l5 << 63 >> 8;
                l5 = l5 >>> 1 | l4 << 63;
                l4 = l4 >>> 1 ^ l10 & 0xE100000000000000L;
            }
        }
        lArray[0] = l6;
        lArray[1] = l7;
    }

    public static void multiplyP(int[] nArray) {
        int n4 = GCMUtil.shiftRight(nArray) >> 8;
        nArray[0] = nArray[0] ^ n4 & 0xE1000000;
    }

    public static void multiplyP(int[] nArray, int[] nArray2) {
        int n4 = GCMUtil.shiftRight(nArray, nArray2) >> 8;
        nArray2[0] = nArray2[0] ^ n4 & 0xE1000000;
    }

    public static void multiplyP8(int[] nArray) {
        int n4 = GCMUtil.shiftRightN(nArray, 8);
        nArray[0] = nArray[0] ^ LOOKUP[n4 >>> 24];
    }

    public static void multiplyP8(int[] nArray, int[] nArray2) {
        int n4 = GCMUtil.shiftRightN(nArray, 8, nArray2);
        nArray2[0] = nArray2[0] ^ LOOKUP[n4 >>> 24];
    }

    static int shiftRight(int[] nArray) {
        int n4 = nArray[0];
        nArray[0] = n4 >>> 1;
        int n5 = n4 << 31;
        n4 = nArray[1];
        nArray[1] = n4 >>> 1 | n5;
        n5 = n4 << 31;
        n4 = nArray[2];
        nArray[2] = n4 >>> 1 | n5;
        n5 = n4 << 31;
        n4 = nArray[3];
        nArray[3] = n4 >>> 1 | n5;
        return n4 << 31;
    }

    static int shiftRight(int[] nArray, int[] nArray2) {
        int n4 = nArray[0];
        nArray2[0] = n4 >>> 1;
        int n5 = n4 << 31;
        n4 = nArray[1];
        nArray2[1] = n4 >>> 1 | n5;
        n5 = n4 << 31;
        n4 = nArray[2];
        nArray2[2] = n4 >>> 1 | n5;
        n5 = n4 << 31;
        n4 = nArray[3];
        nArray2[3] = n4 >>> 1 | n5;
        return n4 << 31;
    }

    static long shiftRight(long[] lArray) {
        long l4 = lArray[0];
        lArray[0] = l4 >>> 1;
        long l5 = l4 << 63;
        l4 = lArray[1];
        lArray[1] = l4 >>> 1 | l5;
        return l4 << 63;
    }

    static long shiftRight(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        lArray2[0] = l4 >>> 1;
        long l5 = l4 << 63;
        l4 = lArray[1];
        lArray2[1] = l4 >>> 1 | l5;
        return l4 << 63;
    }

    static int shiftRightN(int[] nArray, int n4) {
        int n5 = nArray[0];
        int n6 = 32 - n4;
        nArray[0] = n5 >>> n4;
        int n7 = n5 << n6;
        n5 = nArray[1];
        nArray[1] = n5 >>> n4 | n7;
        n7 = n5 << n6;
        n5 = nArray[2];
        nArray[2] = n5 >>> n4 | n7;
        n7 = n5 << n6;
        n5 = nArray[3];
        nArray[3] = n5 >>> n4 | n7;
        return n5 << n6;
    }

    static int shiftRightN(int[] nArray, int n4, int[] nArray2) {
        int n5 = nArray[0];
        int n6 = 32 - n4;
        nArray2[0] = n5 >>> n4;
        int n7 = n5 << n6;
        n5 = nArray[1];
        nArray2[1] = n5 >>> n4 | n7;
        n7 = n5 << n6;
        n5 = nArray[2];
        nArray2[2] = n5 >>> n4 | n7;
        n7 = n5 << n6;
        n5 = nArray[3];
        nArray2[3] = n5 >>> n4 | n7;
        return n5 << n6;
    }

    public static void xor(byte[] byArray, byte[] byArray2) {
        int n4 = 0;
        do {
            int n5 = n4;
            byArray[n5] = (byte)(byArray[n5] ^ byArray2[n4]);
            int n6 = ++n4;
            byArray[n6] = (byte)(byArray[n6] ^ byArray2[n4]);
            int n7 = ++n4;
            byArray[n7] = (byte)(byArray[n7] ^ byArray2[n4]);
            int n8 = ++n4;
            byArray[n8] = (byte)(byArray[n8] ^ byArray2[n4]);
        } while (++n4 < 16);
    }

    public static void xor(byte[] byArray, byte[] byArray2, int n4, int n5) {
        while (--n5 >= 0) {
            int n6 = n5;
            byArray[n6] = (byte)(byArray[n6] ^ byArray2[n4 + n5]);
        }
    }

    public static void xor(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n4 = 0;
        do {
            byArray3[n4] = (byte)(byArray[n4] ^ byArray2[n4]);
            byArray3[++n4] = (byte)(byArray[n4] ^ byArray2[n4]);
            byArray3[++n4] = (byte)(byArray[n4] ^ byArray2[n4]);
            byArray3[++n4] = (byte)(byArray[n4] ^ byArray2[n4]);
        } while (++n4 < 16);
    }

    public static void xor(int[] nArray, int[] nArray2) {
        nArray[0] = nArray[0] ^ nArray2[0];
        nArray[1] = nArray[1] ^ nArray2[1];
        nArray[2] = nArray[2] ^ nArray2[2];
        nArray[3] = nArray[3] ^ nArray2[3];
    }

    public static void xor(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray3[0] = nArray[0] ^ nArray2[0];
        nArray3[1] = nArray[1] ^ nArray2[1];
        nArray3[2] = nArray[2] ^ nArray2[2];
        nArray3[3] = nArray[3] ^ nArray2[3];
    }

    public static void xor(long[] lArray, long[] lArray2) {
        lArray[0] = lArray[0] ^ lArray2[0];
        lArray[1] = lArray[1] ^ lArray2[1];
    }

    public static void xor(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
    }
}

