/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class CBCBlockCipherMac
implements Mac {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private BlockCipherPadding padding;
    private int macSize;

    public CBCBlockCipherMac(BlockCipher blockCipher) {
        this(blockCipher, blockCipher.getBlockSize() * 8 / 2, null);
    }

    public CBCBlockCipherMac(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        this(blockCipher, blockCipher.getBlockSize() * 8 / 2, blockCipherPadding);
    }

    public CBCBlockCipherMac(BlockCipher blockCipher, int n4) {
        this(blockCipher, n4, null);
    }

    public CBCBlockCipherMac(BlockCipher blockCipher, int n4, BlockCipherPadding blockCipherPadding) {
        if (n4 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        this.cipher = new CBCBlockCipher(blockCipher);
        this.padding = blockCipherPadding;
        this.macSize = n4 / 8;
        this.mac = new byte[blockCipher.getBlockSize()];
        this.buf = new byte[blockCipher.getBlockSize()];
        this.bufOff = 0;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    public void init(CipherParameters cipherParameters) {
        this.reset();
        this.cipher.init(true, cipherParameters);
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void update(byte by) {
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by;
    }

    public void update(byte[] byArray, int n4, int n5) {
        if (n5 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n6 = this.cipher.getBlockSize();
        int n7 = n6 - this.bufOff;
        if (n5 > n7) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n7);
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            n5 -= n7;
            n4 += n7;
            while (n5 > n6) {
                this.cipher.processBlock(byArray, n4, this.mac, 0);
                n5 -= n6;
                n4 += n6;
            }
        }
        System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
        this.bufOff += n5;
    }

    public int doFinal(byte[] byArray, int n4) {
        int n5 = this.cipher.getBlockSize();
        if (this.padding == null) {
            while (this.bufOff < n5) {
                this.buf[this.bufOff] = 0;
                ++this.bufOff;
            }
        } else {
            if (this.bufOff == n5) {
                this.cipher.processBlock(this.buf, 0, this.mac, 0);
                this.bufOff = 0;
            }
            this.padding.addPadding(this.buf, this.bufOff);
        }
        this.cipher.processBlock(this.buf, 0, this.mac, 0);
        System.arraycopy(this.mac, 0, byArray, n4, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i4 = 0; i4 < this.buf.length; ++i4) {
            this.buf[i4] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

