/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;

public class RFC3394WrapEngine
implements Wrapper {
    private BlockCipher engine;
    private boolean wrapCipherMode;
    private KeyParameter param;
    private boolean forWrapping;
    private byte[] iv = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    public RFC3394WrapEngine(BlockCipher blockCipher) {
        this(blockCipher, false);
    }

    public RFC3394WrapEngine(BlockCipher blockCipher, boolean bl) {
        this.engine = blockCipher;
        this.wrapCipherMode = !bl;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forWrapping = bl;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof KeyParameter) {
            this.param = (KeyParameter)cipherParameters;
        } else if (cipherParameters instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)cipherParameters).getIV();
            this.param = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            if (this.iv.length != 8) {
                throw new IllegalArgumentException("IV not equal to 8");
            }
        }
    }

    public String getAlgorithmName() {
        return this.engine.getAlgorithmName();
    }

    public byte[] wrap(byte[] byArray, int n4, int n5) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n6 = n5 / 8;
        if (n6 * 8 != n5) {
            throw new DataLengthException("wrap data must be a multiple of 8 bytes");
        }
        byte[] byArray2 = new byte[n5 + this.iv.length];
        byte[] byArray3 = new byte[8 + this.iv.length];
        System.arraycopy(this.iv, 0, byArray2, 0, this.iv.length);
        System.arraycopy(byArray, n4, byArray2, this.iv.length, n5);
        this.engine.init(this.wrapCipherMode, this.param);
        for (int i4 = 0; i4 != 6; ++i4) {
            for (int i5 = 1; i5 <= n6; ++i5) {
                System.arraycopy(byArray2, 0, byArray3, 0, this.iv.length);
                System.arraycopy(byArray2, 8 * i5, byArray3, this.iv.length, 8);
                this.engine.processBlock(byArray3, 0, byArray3, 0);
                int n7 = n6 * i4 + i5;
                int n8 = 1;
                while (n7 != 0) {
                    byte by = (byte)n7;
                    int n9 = this.iv.length - n8;
                    byArray3[n9] = (byte)(byArray3[n9] ^ by);
                    n7 >>>= 8;
                    ++n8;
                }
                System.arraycopy(byArray3, 0, byArray2, 0, 8);
                System.arraycopy(byArray3, 8, byArray2, 8 * i5, 8);
            }
        }
        return byArray2;
    }

    public byte[] unwrap(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n6 = n5 / 8;
        if (n6 * 8 != n5) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        byte[] byArray2 = new byte[n5 - this.iv.length];
        byte[] byArray3 = new byte[this.iv.length];
        byte[] byArray4 = new byte[8 + this.iv.length];
        System.arraycopy(byArray, n4, byArray3, 0, this.iv.length);
        System.arraycopy(byArray, n4 + this.iv.length, byArray2, 0, n5 - this.iv.length);
        this.engine.init(!this.wrapCipherMode, this.param);
        --n6;
        for (int i4 = 5; i4 >= 0; --i4) {
            for (int i5 = n6; i5 >= 1; --i5) {
                System.arraycopy(byArray3, 0, byArray4, 0, this.iv.length);
                System.arraycopy(byArray2, 8 * (i5 - 1), byArray4, this.iv.length, 8);
                int n7 = n6 * i4 + i5;
                int n8 = 1;
                while (n7 != 0) {
                    byte by = (byte)n7;
                    int n9 = this.iv.length - n8;
                    byArray4[n9] = (byte)(byArray4[n9] ^ by);
                    n7 >>>= 8;
                    ++n8;
                }
                this.engine.processBlock(byArray4, 0, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray3, 0, 8);
                System.arraycopy(byArray4, 8, byArray2, 8 * (i5 - 1), 8);
            }
        }
        if (!Arrays.constantTimeAreEqual(byArray3, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return byArray2;
    }
}

