/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.RC5Parameters;

public class RC564Engine
implements BlockCipher {
    private static final int wordSize = 64;
    private static final int bytesPerWord = 8;
    private int _noRounds = 12;
    private long[] _S = null;
    private static final long P64 = -5196783011329398165L;
    private static final long Q64 = -7046029254386353131L;
    private boolean forEncryption;

    public String getAlgorithmName() {
        return "RC5-64";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof RC5Parameters)) {
            throw new IllegalArgumentException("invalid parameter passed to RC564 init - " + cipherParameters.getClass().getName());
        }
        RC5Parameters rC5Parameters = (RC5Parameters)cipherParameters;
        this.forEncryption = bl;
        this._noRounds = rC5Parameters.getRounds();
        this.setKey(rC5Parameters.getKey());
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        return this.forEncryption ? this.encryptBlock(byArray, n4, byArray2, n5) : this.decryptBlock(byArray, n4, byArray2, n5);
    }

    public void reset() {
    }

    private void setKey(byte[] byArray) {
        int n4;
        long[] lArray = new long[(byArray.length + 7) / 8];
        for (n4 = 0; n4 != byArray.length; ++n4) {
            int n5 = n4 / 8;
            lArray[n5] = lArray[n5] + ((long)(byArray[n4] & 0xFF) << 8 * (n4 % 8));
        }
        this._S = new long[2 * (this._noRounds + 1)];
        this._S[0] = -5196783011329398165L;
        for (n4 = 1; n4 < this._S.length; ++n4) {
            this._S[n4] = this._S[n4 - 1] + -7046029254386353131L;
        }
        n4 = lArray.length > this._S.length ? 3 * lArray.length : 3 * this._S.length;
        long l4 = 0L;
        long l5 = 0L;
        int n6 = 0;
        int n7 = 0;
        for (int i4 = 0; i4 < n4; ++i4) {
            l4 = this._S[n6] = this.rotateLeft(this._S[n6] + l4 + l5, 3L);
            l5 = lArray[n7] = this.rotateLeft(lArray[n7] + l4 + l5, l4 + l5);
            n6 = (n6 + 1) % this._S.length;
            n7 = (n7 + 1) % lArray.length;
        }
    }

    private int encryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        long l4 = this.bytesToWord(byArray, n4) + this._S[0];
        long l5 = this.bytesToWord(byArray, n4 + 8) + this._S[1];
        for (int i4 = 1; i4 <= this._noRounds; ++i4) {
            l4 = this.rotateLeft(l4 ^ l5, l5) + this._S[2 * i4];
            l5 = this.rotateLeft(l5 ^ l4, l4) + this._S[2 * i4 + 1];
        }
        this.wordToBytes(l4, byArray2, n5);
        this.wordToBytes(l5, byArray2, n5 + 8);
        return 16;
    }

    private int decryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        long l4 = this.bytesToWord(byArray, n4);
        long l5 = this.bytesToWord(byArray, n4 + 8);
        for (int i4 = this._noRounds; i4 >= 1; --i4) {
            l5 = this.rotateRight(l5 - this._S[2 * i4 + 1], l4) ^ l4;
            l4 = this.rotateRight(l4 - this._S[2 * i4], l5) ^ l5;
        }
        this.wordToBytes(l4 - this._S[0], byArray2, n5);
        this.wordToBytes(l5 - this._S[1], byArray2, n5 + 8);
        return 16;
    }

    private long rotateLeft(long l4, long l5) {
        return l4 << (int)(l5 & 0x3FL) | l4 >>> (int)(64L - (l5 & 0x3FL));
    }

    private long rotateRight(long l4, long l5) {
        return l4 >>> (int)(l5 & 0x3FL) | l4 << (int)(64L - (l5 & 0x3FL));
    }

    private long bytesToWord(byte[] byArray, int n4) {
        long l4 = 0L;
        for (int i4 = 7; i4 >= 0; --i4) {
            l4 = (l4 << 8) + (long)(byArray[i4 + n4] & 0xFF);
        }
        return l4;
    }

    private void wordToBytes(long l4, byte[] byArray, int n4) {
        for (int i4 = 0; i4 < 8; ++i4) {
            byArray[i4 + n4] = (byte)l4;
            l4 >>>= 8;
        }
    }
}

