/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RC2Parameters;

public class RC2Engine
implements BlockCipher {
    private static byte[] piTable = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};
    private static final int BLOCK_SIZE = 8;
    private int[] workingKey;
    private boolean encrypting;

    private int[] generateWorkingKey(byte[] byArray, int n4) {
        int n5;
        int n6;
        int n7;
        int[] nArray = new int[128];
        for (n7 = 0; n7 != byArray.length; ++n7) {
            nArray[n7] = byArray[n7] & 0xFF;
        }
        n7 = byArray.length;
        if (n7 < 128) {
            n6 = 0;
            n5 = nArray[n7 - 1];
            do {
                n5 = piTable[n5 + nArray[n6++] & 0xFF] & 0xFF;
                nArray[n7++] = n5;
            } while (n7 < 128);
        }
        n7 = n4 + 7 >> 3;
        nArray[128 - n7] = n5 = piTable[nArray[128 - n7] & 255 >> (7 & -n4)] & 0xFF;
        for (n6 = 128 - n7 - 1; n6 >= 0; --n6) {
            nArray[n6] = n5 = piTable[n5 ^ nArray[n6 + n7]] & 0xFF;
        }
        int[] nArray2 = new int[64];
        for (int i4 = 0; i4 != nArray2.length; ++i4) {
            nArray2[i4] = nArray[2 * i4] + (nArray[2 * i4 + 1] << 8);
        }
        return nArray2;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.encrypting = bl;
        if (cipherParameters instanceof RC2Parameters) {
            RC2Parameters rC2Parameters = (RC2Parameters)cipherParameters;
            this.workingKey = this.generateWorkingKey(rC2Parameters.getKey(), rC2Parameters.getEffectiveKeyBits());
        } else if (cipherParameters instanceof KeyParameter) {
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            this.workingKey = this.generateWorkingKey(byArray, byArray.length * 8);
        } else {
            throw new IllegalArgumentException("invalid parameter passed to RC2 init - " + cipherParameters.getClass().getName());
        }
    }

    public void reset() {
    }

    public String getAlgorithmName() {
        return "RC2";
    }

    public int getBlockSize() {
        return 8;
    }

    public final int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        if (this.workingKey == null) {
            throw new IllegalStateException("RC2 engine not initialised");
        }
        if (n4 + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.encrypting) {
            this.encryptBlock(byArray, n4, byArray2, n5);
        } else {
            this.decryptBlock(byArray, n4, byArray2, n5);
        }
        return 8;
    }

    private int rotateWordLeft(int n4, int n5) {
        return (n4 &= 0xFFFF) << n5 | n4 >> 16 - n5;
    }

    private void encryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6;
        int n7 = ((byArray[n4 + 7] & 0xFF) << 8) + (byArray[n4 + 6] & 0xFF);
        int n8 = ((byArray[n4 + 5] & 0xFF) << 8) + (byArray[n4 + 4] & 0xFF);
        int n9 = ((byArray[n4 + 3] & 0xFF) << 8) + (byArray[n4 + 2] & 0xFF);
        int n10 = ((byArray[n4 + 1] & 0xFF) << 8) + (byArray[n4 + 0] & 0xFF);
        for (n6 = 0; n6 <= 16; n6 += 4) {
            n10 = this.rotateWordLeft(n10 + (n9 & ~n7) + (n8 & n7) + this.workingKey[n6], 1);
            n9 = this.rotateWordLeft(n9 + (n8 & ~n10) + (n7 & n10) + this.workingKey[n6 + 1], 2);
            n8 = this.rotateWordLeft(n8 + (n7 & ~n9) + (n10 & n9) + this.workingKey[n6 + 2], 3);
            n7 = this.rotateWordLeft(n7 + (n10 & ~n8) + (n9 & n8) + this.workingKey[n6 + 3], 5);
        }
        n8 += this.workingKey[(n9 += this.workingKey[(n10 += this.workingKey[n7 & 0x3F]) & 0x3F]) & 0x3F];
        n7 += this.workingKey[n8 & 0x3F];
        for (n6 = 20; n6 <= 40; n6 += 4) {
            n10 = this.rotateWordLeft(n10 + (n9 & ~n7) + (n8 & n7) + this.workingKey[n6], 1);
            n9 = this.rotateWordLeft(n9 + (n8 & ~n10) + (n7 & n10) + this.workingKey[n6 + 1], 2);
            n8 = this.rotateWordLeft(n8 + (n7 & ~n9) + (n10 & n9) + this.workingKey[n6 + 2], 3);
            n7 = this.rotateWordLeft(n7 + (n10 & ~n8) + (n9 & n8) + this.workingKey[n6 + 3], 5);
        }
        n8 += this.workingKey[(n9 += this.workingKey[(n10 += this.workingKey[n7 & 0x3F]) & 0x3F]) & 0x3F];
        n7 += this.workingKey[n8 & 0x3F];
        for (n6 = 44; n6 < 64; n6 += 4) {
            n10 = this.rotateWordLeft(n10 + (n9 & ~n7) + (n8 & n7) + this.workingKey[n6], 1);
            n9 = this.rotateWordLeft(n9 + (n8 & ~n10) + (n7 & n10) + this.workingKey[n6 + 1], 2);
            n8 = this.rotateWordLeft(n8 + (n7 & ~n9) + (n10 & n9) + this.workingKey[n6 + 2], 3);
            n7 = this.rotateWordLeft(n7 + (n10 & ~n8) + (n9 & n8) + this.workingKey[n6 + 3], 5);
        }
        byArray2[n5 + 0] = (byte)n10;
        byArray2[n5 + 1] = (byte)(n10 >> 8);
        byArray2[n5 + 2] = (byte)n9;
        byArray2[n5 + 3] = (byte)(n9 >> 8);
        byArray2[n5 + 4] = (byte)n8;
        byArray2[n5 + 5] = (byte)(n8 >> 8);
        byArray2[n5 + 6] = (byte)n7;
        byArray2[n5 + 7] = (byte)(n7 >> 8);
    }

    private void decryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6;
        int n7 = ((byArray[n4 + 7] & 0xFF) << 8) + (byArray[n4 + 6] & 0xFF);
        int n8 = ((byArray[n4 + 5] & 0xFF) << 8) + (byArray[n4 + 4] & 0xFF);
        int n9 = ((byArray[n4 + 3] & 0xFF) << 8) + (byArray[n4 + 2] & 0xFF);
        int n10 = ((byArray[n4 + 1] & 0xFF) << 8) + (byArray[n4 + 0] & 0xFF);
        for (n6 = 60; n6 >= 44; n6 -= 4) {
            n7 = this.rotateWordLeft(n7, 11) - ((n10 & ~n8) + (n9 & n8) + this.workingKey[n6 + 3]);
            n8 = this.rotateWordLeft(n8, 13) - ((n7 & ~n9) + (n10 & n9) + this.workingKey[n6 + 2]);
            n9 = this.rotateWordLeft(n9, 14) - ((n8 & ~n10) + (n7 & n10) + this.workingKey[n6 + 1]);
            n10 = this.rotateWordLeft(n10, 15) - ((n9 & ~n7) + (n8 & n7) + this.workingKey[n6]);
        }
        n7 -= this.workingKey[n8 & 0x3F];
        n8 -= this.workingKey[n9 & 0x3F];
        n9 -= this.workingKey[n10 & 0x3F];
        n10 -= this.workingKey[n7 & 0x3F];
        for (n6 = 40; n6 >= 20; n6 -= 4) {
            n7 = this.rotateWordLeft(n7, 11) - ((n10 & ~n8) + (n9 & n8) + this.workingKey[n6 + 3]);
            n8 = this.rotateWordLeft(n8, 13) - ((n7 & ~n9) + (n10 & n9) + this.workingKey[n6 + 2]);
            n9 = this.rotateWordLeft(n9, 14) - ((n8 & ~n10) + (n7 & n10) + this.workingKey[n6 + 1]);
            n10 = this.rotateWordLeft(n10, 15) - ((n9 & ~n7) + (n8 & n7) + this.workingKey[n6]);
        }
        n7 -= this.workingKey[n8 & 0x3F];
        n8 -= this.workingKey[n9 & 0x3F];
        n9 -= this.workingKey[n10 & 0x3F];
        n10 -= this.workingKey[n7 & 0x3F];
        for (n6 = 16; n6 >= 0; n6 -= 4) {
            n7 = this.rotateWordLeft(n7, 11) - ((n10 & ~n8) + (n9 & n8) + this.workingKey[n6 + 3]);
            n8 = this.rotateWordLeft(n8, 13) - ((n7 & ~n9) + (n10 & n9) + this.workingKey[n6 + 2]);
            n9 = this.rotateWordLeft(n9, 14) - ((n8 & ~n10) + (n7 & n10) + this.workingKey[n6 + 1]);
            n10 = this.rotateWordLeft(n10, 15) - ((n9 & ~n7) + (n8 & n7) + this.workingKey[n6]);
        }
        byArray2[n5 + 0] = (byte)n10;
        byArray2[n5 + 1] = (byte)(n10 >> 8);
        byArray2[n5 + 2] = (byte)n9;
        byArray2[n5 + 3] = (byte)(n9 >> 8);
        byArray2[n5 + 4] = (byte)n8;
        byArray2[n5 + 5] = (byte)(n8 >> 8);
        byArray2[n5 + 6] = (byte)n7;
        byArray2[n5 + 7] = (byte)(n7 >> 8);
    }
}

