/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class HC256Engine
implements StreamCipher {
    private int[] p = new int[1024];
    private int[] q = new int[1024];
    private int cnt = 0;
    private byte[] key;
    private byte[] iv;
    private boolean initialised;
    private byte[] buf = new byte[4];
    private int idx = 0;

    private int step() {
        int n4;
        int n5 = this.cnt & 0x3FF;
        if (this.cnt < 1024) {
            int n6 = this.p[n5 - 3 & 0x3FF];
            int n7 = this.p[n5 - 1023 & 0x3FF];
            int n8 = n5;
            this.p[n8] = this.p[n8] + (this.p[n5 - 10 & 0x3FF] + (HC256Engine.rotateRight(n6, 10) ^ HC256Engine.rotateRight(n7, 23)) + this.q[(n6 ^ n7) & 0x3FF]);
            n6 = this.p[n5 - 12 & 0x3FF];
            n4 = this.q[n6 & 0xFF] + this.q[(n6 >> 8 & 0xFF) + 256] + this.q[(n6 >> 16 & 0xFF) + 512] + this.q[(n6 >> 24 & 0xFF) + 768] ^ this.p[n5];
        } else {
            int n9 = this.q[n5 - 3 & 0x3FF];
            int n10 = this.q[n5 - 1023 & 0x3FF];
            int n11 = n5;
            this.q[n11] = this.q[n11] + (this.q[n5 - 10 & 0x3FF] + (HC256Engine.rotateRight(n9, 10) ^ HC256Engine.rotateRight(n10, 23)) + this.p[(n9 ^ n10) & 0x3FF]);
            n9 = this.q[n5 - 12 & 0x3FF];
            n4 = this.p[n9 & 0xFF] + this.p[(n9 >> 8 & 0xFF) + 256] + this.p[(n9 >> 16 & 0xFF) + 512] + this.p[(n9 >> 24 & 0xFF) + 768] ^ this.q[n5];
        }
        this.cnt = this.cnt + 1 & 0x7FF;
        return n4;
    }

    private void init() {
        int n4;
        Object[] objectArray;
        if (this.key.length != 32 && this.key.length != 16) {
            throw new IllegalArgumentException("The key must be 128/256 bits long");
        }
        if (this.iv.length < 16) {
            throw new IllegalArgumentException("The IV must be at least 128 bits long");
        }
        if (this.key.length != 32) {
            objectArray = new byte[32];
            System.arraycopy(this.key, 0, objectArray, 0, this.key.length);
            System.arraycopy(this.key, 0, objectArray, 16, this.key.length);
            this.key = objectArray;
        }
        if (this.iv.length < 32) {
            objectArray = new byte[32];
            System.arraycopy(this.iv, 0, objectArray, 0, this.iv.length);
            System.arraycopy(this.iv, 0, objectArray, this.iv.length, objectArray.length - this.iv.length);
            this.iv = objectArray;
        }
        this.idx = 0;
        this.cnt = 0;
        objectArray = new int[2560];
        for (n4 = 0; n4 < 32; ++n4) {
            int n5 = n4 >> 2;
            objectArray[n5] = objectArray[n5] | (this.key[n4] & 0xFF) << 8 * (n4 & 3);
        }
        for (n4 = 0; n4 < 32; ++n4) {
            int n6 = (n4 >> 2) + 8;
            objectArray[n6] = objectArray[n6] | (this.iv[n4] & 0xFF) << 8 * (n4 & 3);
        }
        for (n4 = 16; n4 < 2560; ++n4) {
            byte by = objectArray[n4 - 2];
            byte by2 = objectArray[n4 - 15];
            objectArray[n4] = (HC256Engine.rotateRight(by, 17) ^ HC256Engine.rotateRight(by, 19) ^ by >>> 10) + objectArray[n4 - 7] + (HC256Engine.rotateRight(by2, 7) ^ HC256Engine.rotateRight(by2, 18) ^ by2 >>> 3) + objectArray[n4 - 16] + n4;
        }
        System.arraycopy(objectArray, 512, this.p, 0, 1024);
        System.arraycopy(objectArray, 1536, this.q, 0, 1024);
        for (n4 = 0; n4 < 4096; ++n4) {
            this.step();
        }
        this.cnt = 0;
    }

    public String getAlgorithmName() {
        return "HC-256";
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2 = cipherParameters;
        if (cipherParameters instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)cipherParameters).getIV();
            cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
        } else {
            this.iv = new byte[0];
        }
        if (!(cipherParameters2 instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to HC256 init - " + cipherParameters.getClass().getName());
        }
        this.key = ((KeyParameter)cipherParameters2).getKey();
        this.init();
        this.initialised = true;
    }

    private byte getByte() {
        int n4;
        if (this.idx == 0) {
            n4 = this.step();
            this.buf[0] = (byte)(n4 & 0xFF);
            this.buf[1] = (byte)((n4 >>= 8) & 0xFF);
            this.buf[2] = (byte)((n4 >>= 8) & 0xFF);
            this.buf[3] = (byte)((n4 >>= 8) & 0xFF);
        }
        n4 = this.buf[this.idx];
        this.idx = this.idx + 1 & 3;
        return (byte)n4;
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n4 + n5 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n6 + n5 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i4 = 0; i4 < n5; ++i4) {
            byArray2[n6 + i4] = (byte)(byArray[n4 + i4] ^ this.getByte());
        }
        return n5;
    }

    public void reset() {
        this.init();
    }

    public byte returnByte(byte by) {
        return (byte)(by ^ this.getByte());
    }

    private static int rotateRight(int n4, int n5) {
        return n4 >>> n5 | n4 << -n5;
    }
}

