/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.engines.CAST5Engine;

public final class CAST6Engine
extends CAST5Engine {
    protected static final int ROUNDS = 12;
    protected static final int BLOCK_SIZE = 16;
    protected int[] _Kr = new int[48];
    protected int[] _Km = new int[48];
    protected int[] _Tr = new int[192];
    protected int[] _Tm = new int[192];
    private int[] _workingKey = new int[8];

    public String getAlgorithmName() {
        return "CAST6";
    }

    public void reset() {
    }

    public int getBlockSize() {
        return 16;
    }

    protected void setKey(byte[] byArray) {
        int n4;
        int n5;
        int n6 = 1518500249;
        int n7 = 1859775393;
        int n8 = 19;
        int n9 = 17;
        for (int i4 = 0; i4 < 24; ++i4) {
            for (n5 = 0; n5 < 8; ++n5) {
                this._Tm[i4 * 8 + n5] = n6;
                n6 += n7;
                this._Tr[i4 * 8 + n5] = n8;
                n8 = n8 + n9 & 0x1F;
            }
        }
        byte[] byArray2 = new byte[64];
        n5 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n5);
        for (n4 = 0; n4 < 8; ++n4) {
            this._workingKey[n4] = this.BytesTo32bits(byArray2, n4 * 4);
        }
        for (n4 = 0; n4 < 12; ++n4) {
            int n10 = n4 * 2 * 8;
            this._workingKey[6] = this._workingKey[6] ^ this.F1(this._workingKey[7], this._Tm[n10], this._Tr[n10]);
            this._workingKey[5] = this._workingKey[5] ^ this.F2(this._workingKey[6], this._Tm[n10 + 1], this._Tr[n10 + 1]);
            this._workingKey[4] = this._workingKey[4] ^ this.F3(this._workingKey[5], this._Tm[n10 + 2], this._Tr[n10 + 2]);
            this._workingKey[3] = this._workingKey[3] ^ this.F1(this._workingKey[4], this._Tm[n10 + 3], this._Tr[n10 + 3]);
            this._workingKey[2] = this._workingKey[2] ^ this.F2(this._workingKey[3], this._Tm[n10 + 4], this._Tr[n10 + 4]);
            this._workingKey[1] = this._workingKey[1] ^ this.F3(this._workingKey[2], this._Tm[n10 + 5], this._Tr[n10 + 5]);
            this._workingKey[0] = this._workingKey[0] ^ this.F1(this._workingKey[1], this._Tm[n10 + 6], this._Tr[n10 + 6]);
            this._workingKey[7] = this._workingKey[7] ^ this.F2(this._workingKey[0], this._Tm[n10 + 7], this._Tr[n10 + 7]);
            n10 = (n4 * 2 + 1) * 8;
            this._workingKey[6] = this._workingKey[6] ^ this.F1(this._workingKey[7], this._Tm[n10], this._Tr[n10]);
            this._workingKey[5] = this._workingKey[5] ^ this.F2(this._workingKey[6], this._Tm[n10 + 1], this._Tr[n10 + 1]);
            this._workingKey[4] = this._workingKey[4] ^ this.F3(this._workingKey[5], this._Tm[n10 + 2], this._Tr[n10 + 2]);
            this._workingKey[3] = this._workingKey[3] ^ this.F1(this._workingKey[4], this._Tm[n10 + 3], this._Tr[n10 + 3]);
            this._workingKey[2] = this._workingKey[2] ^ this.F2(this._workingKey[3], this._Tm[n10 + 4], this._Tr[n10 + 4]);
            this._workingKey[1] = this._workingKey[1] ^ this.F3(this._workingKey[2], this._Tm[n10 + 5], this._Tr[n10 + 5]);
            this._workingKey[0] = this._workingKey[0] ^ this.F1(this._workingKey[1], this._Tm[n10 + 6], this._Tr[n10 + 6]);
            this._workingKey[7] = this._workingKey[7] ^ this.F2(this._workingKey[0], this._Tm[n10 + 7], this._Tr[n10 + 7]);
            this._Kr[n4 * 4] = this._workingKey[0] & 0x1F;
            this._Kr[n4 * 4 + 1] = this._workingKey[2] & 0x1F;
            this._Kr[n4 * 4 + 2] = this._workingKey[4] & 0x1F;
            this._Kr[n4 * 4 + 3] = this._workingKey[6] & 0x1F;
            this._Km[n4 * 4] = this._workingKey[7];
            this._Km[n4 * 4 + 1] = this._workingKey[5];
            this._Km[n4 * 4 + 2] = this._workingKey[3];
            this._Km[n4 * 4 + 3] = this._workingKey[1];
        }
    }

    protected int encryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int[] nArray = new int[4];
        int n6 = this.BytesTo32bits(byArray, n4);
        int n7 = this.BytesTo32bits(byArray, n4 + 4);
        int n8 = this.BytesTo32bits(byArray, n4 + 8);
        int n9 = this.BytesTo32bits(byArray, n4 + 12);
        this.CAST_Encipher(n6, n7, n8, n9, nArray);
        this.Bits32ToBytes(nArray[0], byArray2, n5);
        this.Bits32ToBytes(nArray[1], byArray2, n5 + 4);
        this.Bits32ToBytes(nArray[2], byArray2, n5 + 8);
        this.Bits32ToBytes(nArray[3], byArray2, n5 + 12);
        return 16;
    }

    protected int decryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int[] nArray = new int[4];
        int n6 = this.BytesTo32bits(byArray, n4);
        int n7 = this.BytesTo32bits(byArray, n4 + 4);
        int n8 = this.BytesTo32bits(byArray, n4 + 8);
        int n9 = this.BytesTo32bits(byArray, n4 + 12);
        this.CAST_Decipher(n6, n7, n8, n9, nArray);
        this.Bits32ToBytes(nArray[0], byArray2, n5);
        this.Bits32ToBytes(nArray[1], byArray2, n5 + 4);
        this.Bits32ToBytes(nArray[2], byArray2, n5 + 8);
        this.Bits32ToBytes(nArray[3], byArray2, n5 + 12);
        return 16;
    }

    protected final void CAST_Encipher(int n4, int n5, int n6, int n7, int[] nArray) {
        int n8;
        int n9;
        for (n9 = 0; n9 < 6; ++n9) {
            n8 = n9 * 4;
            n7 ^= this.F1(n4 ^= this.F3(n5 ^= this.F2(n6 ^= this.F1(n7, this._Km[n8], this._Kr[n8]), this._Km[n8 + 1], this._Kr[n8 + 1]), this._Km[n8 + 2], this._Kr[n8 + 2]), this._Km[n8 + 3], this._Kr[n8 + 3]);
        }
        for (n9 = 6; n9 < 12; ++n9) {
            n8 = n9 * 4;
            n5 ^= this.F2(n6, this._Km[n8 + 1], this._Kr[n8 + 1]);
            n6 ^= this.F1(n7 ^= this.F1(n4 ^= this.F3(n5, this._Km[n8 + 2], this._Kr[n8 + 2]), this._Km[n8 + 3], this._Kr[n8 + 3]), this._Km[n8], this._Kr[n8]);
        }
        nArray[0] = n4;
        nArray[1] = n5;
        nArray[2] = n6;
        nArray[3] = n7;
    }

    protected final void CAST_Decipher(int n4, int n5, int n6, int n7, int[] nArray) {
        int n8;
        int n9;
        for (n9 = 0; n9 < 6; ++n9) {
            n8 = (11 - n9) * 4;
            n7 ^= this.F1(n4 ^= this.F3(n5 ^= this.F2(n6 ^= this.F1(n7, this._Km[n8], this._Kr[n8]), this._Km[n8 + 1], this._Kr[n8 + 1]), this._Km[n8 + 2], this._Kr[n8 + 2]), this._Km[n8 + 3], this._Kr[n8 + 3]);
        }
        for (n9 = 6; n9 < 12; ++n9) {
            n8 = (11 - n9) * 4;
            n5 ^= this.F2(n6, this._Km[n8 + 1], this._Kr[n8 + 1]);
            n6 ^= this.F1(n7 ^= this.F1(n4 ^= this.F3(n5, this._Km[n8 + 2], this._Kr[n8 + 2]), this._Km[n8 + 3], this._Kr[n8 + 3]), this._Km[n8], this._Kr[n8]);
        }
        nArray[0] = n4;
        nArray[1] = n5;
        nArray[2] = n6;
        nArray[3] = n7;
    }
}

