/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Memoable;

public final class WhirlpoolDigest
implements ExtendedDigest,
Memoable {
    private static final int BYTE_LENGTH = 64;
    private static final int DIGEST_LENGTH_BYTES = 64;
    private static final int ROUNDS = 10;
    private static final int REDUCTION_POLYNOMIAL = 285;
    private static final int[] SBOX = new int[]{24, 35, 198, 232, 135, 184, 1, 79, 54, 166, 210, 245, 121, 111, 145, 82, 96, 188, 155, 142, 163, 12, 123, 53, 29, 224, 215, 194, 46, 75, 254, 87, 21, 119, 55, 229, 159, 240, 74, 218, 88, 201, 41, 10, 177, 160, 107, 133, 189, 93, 16, 244, 203, 62, 5, 103, 228, 39, 65, 139, 167, 125, 149, 216, 251, 238, 124, 102, 221, 23, 71, 158, 202, 45, 191, 7, 173, 90, 131, 51, 99, 2, 170, 113, 200, 25, 73, 217, 242, 227, 91, 136, 154, 38, 50, 176, 233, 15, 213, 128, 190, 205, 52, 72, 255, 122, 144, 95, 32, 104, 26, 174, 180, 84, 147, 34, 100, 241, 115, 18, 64, 8, 195, 236, 219, 161, 141, 61, 151, 0, 207, 43, 118, 130, 214, 27, 181, 175, 106, 80, 69, 243, 48, 239, 63, 85, 162, 234, 101, 186, 47, 192, 222, 28, 253, 77, 146, 117, 6, 138, 178, 230, 14, 31, 98, 212, 168, 150, 249, 197, 37, 89, 132, 114, 57, 76, 94, 120, 56, 140, 209, 165, 226, 97, 179, 33, 156, 30, 67, 199, 252, 4, 81, 153, 109, 13, 250, 223, 126, 36, 59, 171, 206, 17, 143, 78, 183, 235, 60, 129, 148, 247, 185, 19, 44, 211, 231, 110, 196, 3, 86, 68, 127, 169, 42, 187, 193, 83, 220, 11, 157, 108, 49, 116, 246, 70, 172, 137, 20, 225, 22, 58, 105, 9, 112, 182, 208, 237, 204, 66, 152, 164, 40, 92, 248, 134};
    private static final long[] C0 = new long[256];
    private static final long[] C1 = new long[256];
    private static final long[] C2 = new long[256];
    private static final long[] C3 = new long[256];
    private static final long[] C4 = new long[256];
    private static final long[] C5 = new long[256];
    private static final long[] C6 = new long[256];
    private static final long[] C7 = new long[256];
    private final long[] _rc = new long[11];
    private static final int BITCOUNT_ARRAY_SIZE = 32;
    private byte[] _buffer = new byte[64];
    private int _bufferPos = 0;
    private short[] _bitCount = new short[32];
    private long[] _hash = new long[8];
    private long[] _K = new long[8];
    private long[] _L = new long[8];
    private long[] _block = new long[8];
    private long[] _state = new long[8];
    private static final short[] EIGHT = new short[32];

    public WhirlpoolDigest() {
        int n4;
        int n5;
        for (n5 = 0; n5 < 256; ++n5) {
            n4 = SBOX[n5];
            int n6 = this.maskWithReductionPolynomial(n4 << 1);
            int n7 = this.maskWithReductionPolynomial(n6 << 1);
            int n8 = n7 ^ n4;
            int n9 = this.maskWithReductionPolynomial(n7 << 1);
            int n10 = n9 ^ n4;
            WhirlpoolDigest.C0[n5] = this.packIntoLong(n4, n4, n7, n4, n9, n8, n6, n10);
            WhirlpoolDigest.C1[n5] = this.packIntoLong(n10, n4, n4, n7, n4, n9, n8, n6);
            WhirlpoolDigest.C2[n5] = this.packIntoLong(n6, n10, n4, n4, n7, n4, n9, n8);
            WhirlpoolDigest.C3[n5] = this.packIntoLong(n8, n6, n10, n4, n4, n7, n4, n9);
            WhirlpoolDigest.C4[n5] = this.packIntoLong(n9, n8, n6, n10, n4, n4, n7, n4);
            WhirlpoolDigest.C5[n5] = this.packIntoLong(n4, n9, n8, n6, n10, n4, n4, n7);
            WhirlpoolDigest.C6[n5] = this.packIntoLong(n7, n4, n9, n8, n6, n10, n4, n4);
            WhirlpoolDigest.C7[n5] = this.packIntoLong(n4, n7, n4, n9, n8, n6, n10, n4);
        }
        this._rc[0] = 0L;
        for (n5 = 1; n5 <= 10; ++n5) {
            n4 = 8 * (n5 - 1);
            this._rc[n5] = C0[n4] & 0xFF00000000000000L ^ C1[n4 + 1] & 0xFF000000000000L ^ C2[n4 + 2] & 0xFF0000000000L ^ C3[n4 + 3] & 0xFF00000000L ^ C4[n4 + 4] & 0xFF000000L ^ C5[n4 + 5] & 0xFF0000L ^ C6[n4 + 6] & 0xFF00L ^ C7[n4 + 7] & 0xFFL;
        }
    }

    private long packIntoLong(int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        return (long)n4 << 56 ^ (long)n5 << 48 ^ (long)n6 << 40 ^ (long)n7 << 32 ^ (long)n8 << 24 ^ (long)n9 << 16 ^ (long)n10 << 8 ^ (long)n11;
    }

    private int maskWithReductionPolynomial(int n4) {
        int n5 = n4;
        if ((long)n5 >= 256L) {
            n5 ^= 0x11D;
        }
        return n5;
    }

    public WhirlpoolDigest(WhirlpoolDigest whirlpoolDigest) {
        this.reset(whirlpoolDigest);
    }

    public String getAlgorithmName() {
        return "Whirlpool";
    }

    public int getDigestSize() {
        return 64;
    }

    public int doFinal(byte[] byArray, int n4) {
        this.finish();
        for (int i4 = 0; i4 < 8; ++i4) {
            this.convertLongToByteArray(this._hash[i4], byArray, n4 + i4 * 8);
        }
        this.reset();
        return this.getDigestSize();
    }

    public void reset() {
        this._bufferPos = 0;
        Arrays.fill(this._bitCount, (short)0);
        Arrays.fill(this._buffer, (byte)0);
        Arrays.fill(this._hash, 0L);
        Arrays.fill(this._K, 0L);
        Arrays.fill(this._L, 0L);
        Arrays.fill(this._block, 0L);
        Arrays.fill(this._state, 0L);
    }

    private void processFilledBuffer(byte[] byArray, int n4) {
        for (int i4 = 0; i4 < this._state.length; ++i4) {
            this._block[i4] = this.bytesToLongFromBuffer(this._buffer, i4 * 8);
        }
        this.processBlock();
        this._bufferPos = 0;
        Arrays.fill(this._buffer, (byte)0);
    }

    private long bytesToLongFromBuffer(byte[] byArray, int n4) {
        long l4 = ((long)byArray[n4 + 0] & 0xFFL) << 56 | ((long)byArray[n4 + 1] & 0xFFL) << 48 | ((long)byArray[n4 + 2] & 0xFFL) << 40 | ((long)byArray[n4 + 3] & 0xFFL) << 32 | ((long)byArray[n4 + 4] & 0xFFL) << 24 | ((long)byArray[n4 + 5] & 0xFFL) << 16 | ((long)byArray[n4 + 6] & 0xFFL) << 8 | (long)byArray[n4 + 7] & 0xFFL;
        return l4;
    }

    private void convertLongToByteArray(long l4, byte[] byArray, int n4) {
        for (int i4 = 0; i4 < 8; ++i4) {
            byArray[n4 + i4] = (byte)(l4 >> 56 - i4 * 8 & 0xFFL);
        }
    }

    protected void processBlock() {
        int n4;
        for (n4 = 0; n4 < 8; ++n4) {
            this._K[n4] = this._hash[n4];
            this._state[n4] = this._block[n4] ^ this._K[n4];
        }
        for (n4 = 1; n4 <= 10; ++n4) {
            int n5;
            for (n5 = 0; n5 < 8; ++n5) {
                this._L[n5] = 0L;
                int n6 = n5;
                this._L[n6] = this._L[n6] ^ C0[(int)(this._K[n5 - 0 & 7] >>> 56) & 0xFF];
                int n7 = n5;
                this._L[n7] = this._L[n7] ^ C1[(int)(this._K[n5 - 1 & 7] >>> 48) & 0xFF];
                int n8 = n5;
                this._L[n8] = this._L[n8] ^ C2[(int)(this._K[n5 - 2 & 7] >>> 40) & 0xFF];
                int n9 = n5;
                this._L[n9] = this._L[n9] ^ C3[(int)(this._K[n5 - 3 & 7] >>> 32) & 0xFF];
                int n10 = n5;
                this._L[n10] = this._L[n10] ^ C4[(int)(this._K[n5 - 4 & 7] >>> 24) & 0xFF];
                int n11 = n5;
                this._L[n11] = this._L[n11] ^ C5[(int)(this._K[n5 - 5 & 7] >>> 16) & 0xFF];
                int n12 = n5;
                this._L[n12] = this._L[n12] ^ C6[(int)(this._K[n5 - 6 & 7] >>> 8) & 0xFF];
                int n13 = n5;
                this._L[n13] = this._L[n13] ^ C7[(int)this._K[n5 - 7 & 7] & 0xFF];
            }
            System.arraycopy(this._L, 0, this._K, 0, this._K.length);
            this._K[0] = this._K[0] ^ this._rc[n4];
            for (n5 = 0; n5 < 8; ++n5) {
                this._L[n5] = this._K[n5];
                int n14 = n5;
                this._L[n14] = this._L[n14] ^ C0[(int)(this._state[n5 - 0 & 7] >>> 56) & 0xFF];
                int n15 = n5;
                this._L[n15] = this._L[n15] ^ C1[(int)(this._state[n5 - 1 & 7] >>> 48) & 0xFF];
                int n16 = n5;
                this._L[n16] = this._L[n16] ^ C2[(int)(this._state[n5 - 2 & 7] >>> 40) & 0xFF];
                int n17 = n5;
                this._L[n17] = this._L[n17] ^ C3[(int)(this._state[n5 - 3 & 7] >>> 32) & 0xFF];
                int n18 = n5;
                this._L[n18] = this._L[n18] ^ C4[(int)(this._state[n5 - 4 & 7] >>> 24) & 0xFF];
                int n19 = n5;
                this._L[n19] = this._L[n19] ^ C5[(int)(this._state[n5 - 5 & 7] >>> 16) & 0xFF];
                int n20 = n5;
                this._L[n20] = this._L[n20] ^ C6[(int)(this._state[n5 - 6 & 7] >>> 8) & 0xFF];
                int n21 = n5;
                this._L[n21] = this._L[n21] ^ C7[(int)this._state[n5 - 7 & 7] & 0xFF];
            }
            System.arraycopy(this._L, 0, this._state, 0, this._state.length);
        }
        for (n4 = 0; n4 < 8; ++n4) {
            int n22 = n4;
            this._hash[n22] = this._hash[n22] ^ (this._state[n4] ^ this._block[n4]);
        }
    }

    public void update(byte by) {
        this._buffer[this._bufferPos] = by;
        ++this._bufferPos;
        if (this._bufferPos == this._buffer.length) {
            this.processFilledBuffer(this._buffer, 0);
        }
        this.increment();
    }

    private void increment() {
        int n4 = 0;
        for (int i4 = this._bitCount.length - 1; i4 >= 0; --i4) {
            int n5 = (this._bitCount[i4] & 0xFF) + EIGHT[i4] + n4;
            n4 = n5 >>> 8;
            this._bitCount[i4] = (short)(n5 & 0xFF);
        }
    }

    public void update(byte[] byArray, int n4, int n5) {
        while (n5 > 0) {
            this.update(byArray[n4]);
            ++n4;
            --n5;
        }
    }

    private void finish() {
        byte[] byArray = this.copyBitLength();
        int n4 = this._bufferPos++;
        this._buffer[n4] = (byte)(this._buffer[n4] | 0x80);
        if (this._bufferPos == this._buffer.length) {
            this.processFilledBuffer(this._buffer, 0);
        }
        if (this._bufferPos > 32) {
            while (this._bufferPos != 0) {
                this.update((byte)0);
            }
        }
        while (this._bufferPos <= 32) {
            this.update((byte)0);
        }
        System.arraycopy(byArray, 0, this._buffer, 32, byArray.length);
        this.processFilledBuffer(this._buffer, 0);
    }

    private byte[] copyBitLength() {
        byte[] byArray = new byte[32];
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            byArray[i4] = (byte)(this._bitCount[i4] & 0xFF);
        }
        return byArray;
    }

    public int getByteLength() {
        return 64;
    }

    public Memoable copy() {
        return new WhirlpoolDigest(this);
    }

    public void reset(Memoable memoable) {
        WhirlpoolDigest whirlpoolDigest = (WhirlpoolDigest)memoable;
        System.arraycopy(whirlpoolDigest._rc, 0, this._rc, 0, this._rc.length);
        System.arraycopy(whirlpoolDigest._buffer, 0, this._buffer, 0, this._buffer.length);
        this._bufferPos = whirlpoolDigest._bufferPos;
        System.arraycopy(whirlpoolDigest._bitCount, 0, this._bitCount, 0, this._bitCount.length);
        System.arraycopy(whirlpoolDigest._hash, 0, this._hash, 0, this._hash.length);
        System.arraycopy(whirlpoolDigest._K, 0, this._K, 0, this._K.length);
        System.arraycopy(whirlpoolDigest._L, 0, this._L, 0, this._L.length);
        System.arraycopy(whirlpoolDigest._block, 0, this._block, 0, this._block.length);
        System.arraycopy(whirlpoolDigest._state, 0, this._state, 0, this._state.length);
    }

    static {
        WhirlpoolDigest.EIGHT[31] = 8;
    }
}

