/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.util.Memoable;

public class RIPEMD256Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 32;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;
    private int[] X = new int[16];
    private int xOff;

    public RIPEMD256Digest() {
        this.reset();
    }

    public RIPEMD256Digest(RIPEMD256Digest rIPEMD256Digest) {
        super(rIPEMD256Digest);
        this.copyIn(rIPEMD256Digest);
    }

    private void copyIn(RIPEMD256Digest rIPEMD256Digest) {
        super.copyIn(rIPEMD256Digest);
        this.H0 = rIPEMD256Digest.H0;
        this.H1 = rIPEMD256Digest.H1;
        this.H2 = rIPEMD256Digest.H2;
        this.H3 = rIPEMD256Digest.H3;
        this.H4 = rIPEMD256Digest.H4;
        this.H5 = rIPEMD256Digest.H5;
        this.H6 = rIPEMD256Digest.H6;
        this.H7 = rIPEMD256Digest.H7;
        System.arraycopy(rIPEMD256Digest.X, 0, this.X, 0, rIPEMD256Digest.X.length);
        this.xOff = rIPEMD256Digest.xOff;
    }

    public String getAlgorithmName() {
        return "RIPEMD256";
    }

    public int getDigestSize() {
        return 32;
    }

    protected void processWord(byte[] byArray, int n4) {
        this.X[this.xOff++] = byArray[n4] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8 | (byArray[n4 + 2] & 0xFF) << 16 | (byArray[n4 + 3] & 0xFF) << 24;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long l4) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(l4 & 0xFFFFFFFFFFFFFFFFL);
        this.X[15] = (int)(l4 >>> 32);
    }

    private void unpackWord(int n4, byte[] byArray, int n5) {
        byArray[n5] = (byte)n4;
        byArray[n5 + 1] = (byte)(n4 >>> 8);
        byArray[n5 + 2] = (byte)(n4 >>> 16);
        byArray[n5 + 3] = (byte)(n4 >>> 24);
    }

    public int doFinal(byte[] byArray, int n4) {
        this.finish();
        this.unpackWord(this.H0, byArray, n4);
        this.unpackWord(this.H1, byArray, n4 + 4);
        this.unpackWord(this.H2, byArray, n4 + 8);
        this.unpackWord(this.H3, byArray, n4 + 12);
        this.unpackWord(this.H4, byArray, n4 + 16);
        this.unpackWord(this.H5, byArray, n4 + 20);
        this.unpackWord(this.H6, byArray, n4 + 24);
        this.unpackWord(this.H7, byArray, n4 + 28);
        this.reset();
        return 32;
    }

    public void reset() {
        super.reset();
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = 1985229328;
        this.H5 = -19088744;
        this.H6 = -1985229329;
        this.H7 = 19088743;
        this.xOff = 0;
        for (int i4 = 0; i4 != this.X.length; ++i4) {
            this.X[i4] = 0;
        }
    }

    private int RL(int n4, int n5) {
        return n4 << n5 | n4 >>> 32 - n5;
    }

    private int f1(int n4, int n5, int n6) {
        return n4 ^ n5 ^ n6;
    }

    private int f2(int n4, int n5, int n6) {
        return n4 & n5 | ~n4 & n6;
    }

    private int f3(int n4, int n5, int n6) {
        return (n4 | ~n5) ^ n6;
    }

    private int f4(int n4, int n5, int n6) {
        return n4 & n6 | n5 & ~n6;
    }

    private int F1(int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.RL(n4 + this.f1(n5, n6, n7) + n8, n9);
    }

    private int F2(int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.RL(n4 + this.f2(n5, n6, n7) + n8 + 1518500249, n9);
    }

    private int F3(int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.RL(n4 + this.f3(n5, n6, n7) + n8 + 1859775393, n9);
    }

    private int F4(int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.RL(n4 + this.f4(n5, n6, n7) + n8 + -1894007588, n9);
    }

    private int FF1(int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.RL(n4 + this.f1(n5, n6, n7) + n8, n9);
    }

    private int FF2(int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.RL(n4 + this.f2(n5, n6, n7) + n8 + 1836072691, n9);
    }

    private int FF3(int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.RL(n4 + this.f3(n5, n6, n7) + n8 + 1548603684, n9);
    }

    private int FF4(int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.RL(n4 + this.f4(n5, n6, n7) + n8 + 1352829926, n9);
    }

    protected void processBlock() {
        int n4 = this.H0;
        int n5 = this.H1;
        int n6 = this.H2;
        int n7 = this.H3;
        int n8 = this.H4;
        int n9 = this.H5;
        int n10 = this.H6;
        int n11 = this.H7;
        n4 = this.F1(n4, n5, n6, n7, this.X[0], 11);
        n7 = this.F1(n7, n4, n5, n6, this.X[1], 14);
        n6 = this.F1(n6, n7, n4, n5, this.X[2], 15);
        n5 = this.F1(n5, n6, n7, n4, this.X[3], 12);
        n4 = this.F1(n4, n5, n6, n7, this.X[4], 5);
        n7 = this.F1(n7, n4, n5, n6, this.X[5], 8);
        n6 = this.F1(n6, n7, n4, n5, this.X[6], 7);
        n5 = this.F1(n5, n6, n7, n4, this.X[7], 9);
        n4 = this.F1(n4, n5, n6, n7, this.X[8], 11);
        n7 = this.F1(n7, n4, n5, n6, this.X[9], 13);
        n6 = this.F1(n6, n7, n4, n5, this.X[10], 14);
        n5 = this.F1(n5, n6, n7, n4, this.X[11], 15);
        n4 = this.F1(n4, n5, n6, n7, this.X[12], 6);
        n7 = this.F1(n7, n4, n5, n6, this.X[13], 7);
        n6 = this.F1(n6, n7, n4, n5, this.X[14], 9);
        n5 = this.F1(n5, n6, n7, n4, this.X[15], 8);
        n8 = this.FF4(n8, n9, n10, n11, this.X[5], 8);
        n11 = this.FF4(n11, n8, n9, n10, this.X[14], 9);
        n10 = this.FF4(n10, n11, n8, n9, this.X[7], 9);
        n9 = this.FF4(n9, n10, n11, n8, this.X[0], 11);
        n8 = this.FF4(n8, n9, n10, n11, this.X[9], 13);
        n11 = this.FF4(n11, n8, n9, n10, this.X[2], 15);
        n10 = this.FF4(n10, n11, n8, n9, this.X[11], 15);
        n9 = this.FF4(n9, n10, n11, n8, this.X[4], 5);
        n8 = this.FF4(n8, n9, n10, n11, this.X[13], 7);
        n11 = this.FF4(n11, n8, n9, n10, this.X[6], 7);
        n10 = this.FF4(n10, n11, n8, n9, this.X[15], 8);
        n9 = this.FF4(n9, n10, n11, n8, this.X[8], 11);
        n8 = this.FF4(n8, n9, n10, n11, this.X[1], 14);
        n11 = this.FF4(n11, n8, n9, n10, this.X[10], 14);
        n10 = this.FF4(n10, n11, n8, n9, this.X[3], 12);
        n9 = this.FF4(n9, n10, n11, n8, this.X[12], 6);
        int n12 = n4;
        n4 = n8;
        n8 = n12;
        n4 = this.F2(n4, n5, n6, n7, this.X[7], 7);
        n7 = this.F2(n7, n4, n5, n6, this.X[4], 6);
        n6 = this.F2(n6, n7, n4, n5, this.X[13], 8);
        n5 = this.F2(n5, n6, n7, n4, this.X[1], 13);
        n4 = this.F2(n4, n5, n6, n7, this.X[10], 11);
        n7 = this.F2(n7, n4, n5, n6, this.X[6], 9);
        n6 = this.F2(n6, n7, n4, n5, this.X[15], 7);
        n5 = this.F2(n5, n6, n7, n4, this.X[3], 15);
        n4 = this.F2(n4, n5, n6, n7, this.X[12], 7);
        n7 = this.F2(n7, n4, n5, n6, this.X[0], 12);
        n6 = this.F2(n6, n7, n4, n5, this.X[9], 15);
        n5 = this.F2(n5, n6, n7, n4, this.X[5], 9);
        n4 = this.F2(n4, n5, n6, n7, this.X[2], 11);
        n7 = this.F2(n7, n4, n5, n6, this.X[14], 7);
        n6 = this.F2(n6, n7, n4, n5, this.X[11], 13);
        n5 = this.F2(n5, n6, n7, n4, this.X[8], 12);
        n8 = this.FF3(n8, n9, n10, n11, this.X[6], 9);
        n11 = this.FF3(n11, n8, n9, n10, this.X[11], 13);
        n10 = this.FF3(n10, n11, n8, n9, this.X[3], 15);
        n9 = this.FF3(n9, n10, n11, n8, this.X[7], 7);
        n8 = this.FF3(n8, n9, n10, n11, this.X[0], 12);
        n11 = this.FF3(n11, n8, n9, n10, this.X[13], 8);
        n10 = this.FF3(n10, n11, n8, n9, this.X[5], 9);
        n9 = this.FF3(n9, n10, n11, n8, this.X[10], 11);
        n8 = this.FF3(n8, n9, n10, n11, this.X[14], 7);
        n11 = this.FF3(n11, n8, n9, n10, this.X[15], 7);
        n10 = this.FF3(n10, n11, n8, n9, this.X[8], 12);
        n9 = this.FF3(n9, n10, n11, n8, this.X[12], 7);
        n8 = this.FF3(n8, n9, n10, n11, this.X[4], 6);
        n11 = this.FF3(n11, n8, n9, n10, this.X[9], 15);
        n10 = this.FF3(n10, n11, n8, n9, this.X[1], 13);
        n9 = this.FF3(n9, n10, n11, n8, this.X[2], 11);
        n12 = n5;
        n5 = n9;
        n9 = n12;
        n4 = this.F3(n4, n5, n6, n7, this.X[3], 11);
        n7 = this.F3(n7, n4, n5, n6, this.X[10], 13);
        n6 = this.F3(n6, n7, n4, n5, this.X[14], 6);
        n5 = this.F3(n5, n6, n7, n4, this.X[4], 7);
        n4 = this.F3(n4, n5, n6, n7, this.X[9], 14);
        n7 = this.F3(n7, n4, n5, n6, this.X[15], 9);
        n6 = this.F3(n6, n7, n4, n5, this.X[8], 13);
        n5 = this.F3(n5, n6, n7, n4, this.X[1], 15);
        n4 = this.F3(n4, n5, n6, n7, this.X[2], 14);
        n7 = this.F3(n7, n4, n5, n6, this.X[7], 8);
        n6 = this.F3(n6, n7, n4, n5, this.X[0], 13);
        n5 = this.F3(n5, n6, n7, n4, this.X[6], 6);
        n4 = this.F3(n4, n5, n6, n7, this.X[13], 5);
        n7 = this.F3(n7, n4, n5, n6, this.X[11], 12);
        n6 = this.F3(n6, n7, n4, n5, this.X[5], 7);
        n5 = this.F3(n5, n6, n7, n4, this.X[12], 5);
        n8 = this.FF2(n8, n9, n10, n11, this.X[15], 9);
        n11 = this.FF2(n11, n8, n9, n10, this.X[5], 7);
        n10 = this.FF2(n10, n11, n8, n9, this.X[1], 15);
        n9 = this.FF2(n9, n10, n11, n8, this.X[3], 11);
        n8 = this.FF2(n8, n9, n10, n11, this.X[7], 8);
        n11 = this.FF2(n11, n8, n9, n10, this.X[14], 6);
        n10 = this.FF2(n10, n11, n8, n9, this.X[6], 6);
        n9 = this.FF2(n9, n10, n11, n8, this.X[9], 14);
        n8 = this.FF2(n8, n9, n10, n11, this.X[11], 12);
        n11 = this.FF2(n11, n8, n9, n10, this.X[8], 13);
        n10 = this.FF2(n10, n11, n8, n9, this.X[12], 5);
        n9 = this.FF2(n9, n10, n11, n8, this.X[2], 14);
        n8 = this.FF2(n8, n9, n10, n11, this.X[10], 13);
        n11 = this.FF2(n11, n8, n9, n10, this.X[0], 13);
        n10 = this.FF2(n10, n11, n8, n9, this.X[4], 7);
        n9 = this.FF2(n9, n10, n11, n8, this.X[13], 5);
        n12 = n6;
        n6 = n10;
        n10 = n12;
        n4 = this.F4(n4, n5, n6, n7, this.X[1], 11);
        n7 = this.F4(n7, n4, n5, n6, this.X[9], 12);
        n6 = this.F4(n6, n7, n4, n5, this.X[11], 14);
        n5 = this.F4(n5, n6, n7, n4, this.X[10], 15);
        n4 = this.F4(n4, n5, n6, n7, this.X[0], 14);
        n7 = this.F4(n7, n4, n5, n6, this.X[8], 15);
        n6 = this.F4(n6, n7, n4, n5, this.X[12], 9);
        n5 = this.F4(n5, n6, n7, n4, this.X[4], 8);
        n4 = this.F4(n4, n5, n6, n7, this.X[13], 9);
        n7 = this.F4(n7, n4, n5, n6, this.X[3], 14);
        n6 = this.F4(n6, n7, n4, n5, this.X[7], 5);
        n5 = this.F4(n5, n6, n7, n4, this.X[15], 6);
        n4 = this.F4(n4, n5, n6, n7, this.X[14], 8);
        n7 = this.F4(n7, n4, n5, n6, this.X[5], 6);
        n6 = this.F4(n6, n7, n4, n5, this.X[6], 5);
        n5 = this.F4(n5, n6, n7, n4, this.X[2], 12);
        n8 = this.FF1(n8, n9, n10, n11, this.X[8], 15);
        n11 = this.FF1(n11, n8, n9, n10, this.X[6], 5);
        n10 = this.FF1(n10, n11, n8, n9, this.X[4], 8);
        n9 = this.FF1(n9, n10, n11, n8, this.X[1], 11);
        n8 = this.FF1(n8, n9, n10, n11, this.X[3], 14);
        n11 = this.FF1(n11, n8, n9, n10, this.X[11], 14);
        n10 = this.FF1(n10, n11, n8, n9, this.X[15], 6);
        n9 = this.FF1(n9, n10, n11, n8, this.X[0], 14);
        n8 = this.FF1(n8, n9, n10, n11, this.X[5], 6);
        n11 = this.FF1(n11, n8, n9, n10, this.X[12], 9);
        n10 = this.FF1(n10, n11, n8, n9, this.X[2], 12);
        n9 = this.FF1(n9, n10, n11, n8, this.X[13], 9);
        n8 = this.FF1(n8, n9, n10, n11, this.X[9], 12);
        n11 = this.FF1(n11, n8, n9, n10, this.X[7], 5);
        n10 = this.FF1(n10, n11, n8, n9, this.X[10], 15);
        n9 = this.FF1(n9, n10, n11, n8, this.X[14], 8);
        n12 = n7;
        n7 = n11;
        n11 = n12;
        this.H0 += n4;
        this.H1 += n5;
        this.H2 += n6;
        this.H3 += n7;
        this.H4 += n8;
        this.H5 += n9;
        this.H6 += n10;
        this.H7 += n11;
        this.xOff = 0;
        for (int i4 = 0; i4 != this.X.length; ++i4) {
            this.X[i4] = 0;
        }
    }

    public Memoable copy() {
        return new RIPEMD256Digest(this);
    }

    public void reset(Memoable memoable) {
        RIPEMD256Digest rIPEMD256Digest = (RIPEMD256Digest)memoable;
        this.copyIn(rIPEMD256Digest);
    }
}

