/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.crmf.bc;

import java.security.SecureRandom;
import org.bouncycastle.cert.crmf.EncryptedValuePadder;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.MGF1BytesGenerator;
import org.bouncycastle.crypto.params.MGFParameters;

public class BcFixedLengthMGF1Padder
implements EncryptedValuePadder {
    private int length;
    private SecureRandom random;
    private Digest dig = new SHA1Digest();

    public BcFixedLengthMGF1Padder(int n4) {
        this(n4, null);
    }

    public BcFixedLengthMGF1Padder(int n4, SecureRandom secureRandom) {
        this.length = n4;
        this.random = secureRandom;
    }

    public byte[] getPaddedData(byte[] byArray) {
        int n4;
        byte[] byArray2 = new byte[this.length];
        byte[] byArray3 = new byte[this.dig.getDigestSize()];
        byte[] byArray4 = new byte[this.length - this.dig.getDigestSize()];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray3);
        MGF1BytesGenerator mGF1BytesGenerator = new MGF1BytesGenerator(this.dig);
        mGF1BytesGenerator.init(new MGFParameters(byArray3));
        mGF1BytesGenerator.generateBytes(byArray4, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, byArray3.length, byArray.length);
        for (n4 = byArray3.length + byArray.length + 1; n4 != byArray2.length; ++n4) {
            byArray2[n4] = (byte)(1 + this.random.nextInt(255));
        }
        for (n4 = 0; n4 != byArray4.length; ++n4) {
            int n5 = n4 + byArray3.length;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray4[n4]);
        }
        return byArray2;
    }

    public byte[] getUnpaddedData(byte[] byArray) {
        int n4;
        byte[] byArray2 = new byte[this.dig.getDigestSize()];
        byte[] byArray3 = new byte[this.length - this.dig.getDigestSize()];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        MGF1BytesGenerator mGF1BytesGenerator = new MGF1BytesGenerator(this.dig);
        mGF1BytesGenerator.init(new MGFParameters(byArray2));
        mGF1BytesGenerator.generateBytes(byArray3, 0, byArray3.length);
        for (n4 = 0; n4 != byArray3.length; ++n4) {
            int n5 = n4 + byArray2.length;
            byArray[n5] = (byte)(byArray[n5] ^ byArray3[n4]);
        }
        n4 = 0;
        for (int i4 = byArray.length - 1; i4 != byArray2.length; --i4) {
            if (byArray[i4] != 0) continue;
            n4 = i4;
            break;
        }
        if (n4 == 0) {
            throw new IllegalStateException("bad padding in encoding");
        }
        byte[] byArray4 = new byte[n4 - byArray2.length];
        System.arraycopy(byArray, byArray2.length, byArray4, 0, byArray4.length);
        return byArray4;
    }
}

