/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.Attributes;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(Hashtable hashtable) {
        this.attributes = this.copyTable(hashtable);
    }

    public AttributeTable(ASN1EncodableVector aSN1EncodableVector) {
        for (int i4 = 0; i4 != aSN1EncodableVector.size(); ++i4) {
            Attribute attribute = Attribute.getInstance(aSN1EncodableVector.get(i4));
            this.addAttribute(attribute.getAttrType(), attribute);
        }
    }

    public AttributeTable(ASN1Set aSN1Set) {
        for (int i4 = 0; i4 != aSN1Set.size(); ++i4) {
            Attribute attribute = Attribute.getInstance(aSN1Set.getObjectAt(i4));
            this.addAttribute(attribute.getAttrType(), attribute);
        }
    }

    public AttributeTable(Attribute attribute) {
        this.addAttribute(attribute.getAttrType(), attribute);
    }

    public AttributeTable(Attributes attributes) {
        this(ASN1Set.getInstance(attributes.toASN1Primitive()));
    }

    private void addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, Attribute attribute) {
        Object v4 = this.attributes.get(aSN1ObjectIdentifier);
        if (v4 == null) {
            this.attributes.put(aSN1ObjectIdentifier, attribute);
        } else {
            Vector<Object> vector;
            if (v4 instanceof Attribute) {
                vector = new Vector<Object>();
                vector.addElement(v4);
                vector.addElement(attribute);
            } else {
                vector = (Vector<Object>)v4;
                vector.addElement(attribute);
            }
            this.attributes.put(aSN1ObjectIdentifier, vector);
        }
    }

    public Attribute get(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Object v4 = this.attributes.get(aSN1ObjectIdentifier);
        if (v4 instanceof Vector) {
            return (Attribute)((Vector)v4).elementAt(0);
        }
        return (Attribute)v4;
    }

    public ASN1EncodableVector getAll(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Object v4 = this.attributes.get(aSN1ObjectIdentifier);
        if (v4 instanceof Vector) {
            Enumeration enumeration = ((Vector)v4).elements();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector.add((Attribute)enumeration.nextElement());
            }
        } else if (v4 != null) {
            aSN1EncodableVector.add((Attribute)v4);
        }
        return aSN1EncodableVector;
    }

    public int size() {
        int n4 = 0;
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Object v4 = enumeration.nextElement();
            if (v4 instanceof Vector) {
                n4 += ((Vector)v4).size();
                continue;
            }
            ++n4;
        }
        return n4;
    }

    public Hashtable toHashtable() {
        return this.copyTable(this.attributes);
    }

    public ASN1EncodableVector toASN1EncodableVector() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Object v4 = enumeration.nextElement();
            if (v4 instanceof Vector) {
                Enumeration enumeration2 = ((Vector)v4).elements();
                while (enumeration2.hasMoreElements()) {
                    aSN1EncodableVector.add(Attribute.getInstance(enumeration2.nextElement()));
                }
                continue;
            }
            aSN1EncodableVector.add(Attribute.getInstance(v4));
        }
        return aSN1EncodableVector;
    }

    public Attributes toASN1Structure() {
        return new Attributes(this.toASN1EncodableVector());
    }

    private Hashtable copyTable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k4 = enumeration.nextElement();
            hashtable2.put(k4, hashtable.get(k4));
        }
        return hashtable2;
    }

    public AttributeTable add(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        AttributeTable attributeTable = new AttributeTable(this.attributes);
        attributeTable.addAttribute(aSN1ObjectIdentifier, new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1Encodable)));
        return attributeTable;
    }

    public AttributeTable remove(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        AttributeTable attributeTable = new AttributeTable(this.attributes);
        attributeTable.attributes.remove(aSN1ObjectIdentifier);
        return attributeTable;
    }
}

