/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class ASN1GeneralizedTime
extends ASN1Primitive {
    private byte[] time;

    public static ASN1GeneralizedTime getInstance(Object object) {
        if (object == null || object instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)object;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1GeneralizedTime)ASN1GeneralizedTime.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1GeneralizedTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl || aSN1Primitive instanceof ASN1GeneralizedTime) {
            return ASN1GeneralizedTime.getInstance(aSN1Primitive);
        }
        return new ASN1GeneralizedTime(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    public ASN1GeneralizedTime(String string) {
        this.time = Strings.toByteArray(string);
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    public ASN1GeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(simpleDateFormat.format(date));
    }

    public ASN1GeneralizedTime(Date date, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'", locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(simpleDateFormat.format(date));
    }

    ASN1GeneralizedTime(byte[] byArray) {
        this.time = byArray;
    }

    public String getTimeString() {
        return Strings.fromByteArray(this.time);
    }

    public String getTime() {
        String string = Strings.fromByteArray(this.time);
        if (string.charAt(string.length() - 1) == 'Z') {
            return string.substring(0, string.length() - 1) + "GMT+00:00";
        }
        int n4 = string.length() - 5;
        char c4 = string.charAt(n4);
        if (c4 == '-' || c4 == '+') {
            return string.substring(0, n4) + "GMT" + string.substring(n4, n4 + 3) + ":" + string.substring(n4 + 3);
        }
        n4 = string.length() - 3;
        c4 = string.charAt(n4);
        if (c4 == '-' || c4 == '+') {
            return string.substring(0, n4) + "GMT" + string.substring(n4) + ":00";
        }
        return string + this.calculateGMTOffset();
    }

    private String calculateGMTOffset() {
        String string = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int n4 = timeZone.getRawOffset();
        if (n4 < 0) {
            string = "-";
            n4 = -n4;
        }
        int n5 = n4 / 3600000;
        int n6 = (n4 - n5 * 60 * 60 * 1000) / 60000;
        try {
            if (timeZone.useDaylightTime() && timeZone.inDaylightTime(this.getDate())) {
                n5 += string.equals("+") ? 1 : -1;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return "GMT" + string + this.convert(n5) + ":" + this.convert(n6);
    }

    private String convert(int n4) {
        if (n4 < 10) {
            return "0" + n4;
        }
        return Integer.toString(n4);
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat;
        String string;
        String string2 = string = Strings.fromByteArray(this.time);
        if (string.endsWith("Z")) {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'") : new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (string.indexOf(45) > 0 || string.indexOf(43) > 0) {
            string2 = this.getTime();
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSz") : new SimpleDateFormat("yyyyMMddHHmmssz");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : new SimpleDateFormat("yyyyMMddHHmmss");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        if (this.hasFractionalSeconds()) {
            char c4;
            int n4;
            String string3 = string2.substring(14);
            for (n4 = 1; n4 < string3.length() && '0' <= (c4 = string3.charAt(n4)) && c4 <= '9'; ++n4) {
            }
            if (n4 - 1 > 3) {
                string3 = string3.substring(0, 4) + string3.substring(n4);
                string2 = string2.substring(0, 14) + string3;
            } else if (n4 - 1 == 1) {
                string3 = string3.substring(0, n4) + "00" + string3.substring(n4);
                string2 = string2.substring(0, 14) + string3;
            } else if (n4 - 1 == 2) {
                string3 = string3.substring(0, n4) + "0" + string3.substring(n4);
                string2 = string2.substring(0, 14) + string3;
            }
        }
        return simpleDateFormat.parse(string2);
    }

    private boolean hasFractionalSeconds() {
        for (int i4 = 0; i4 != this.time.length; ++i4) {
            if (this.time[i4] != 46 || i4 != 14) continue;
            return true;
        }
        return false;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        int n4 = this.time.length;
        return 1 + StreamUtil.calculateBodyLength(n4) + n4;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeEncoded(24, this.time);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1GeneralizedTime)) {
            return false;
        }
        return Arrays.areEqual(this.time, ((ASN1GeneralizedTime)aSN1Primitive).time);
    }

    public int hashCode() {
        return Arrays.hashCode(this.time);
    }
}

