/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.DaggerCollections;
import dagger.internal.Factory;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;

public final class SetFactory<T>
implements Factory<Set<T>> {
    private static final Factory<Set<Object>> EMPTY_FACTORY = InstanceFactory.create(Collections.emptySet());
    private final List<Provider<T>> individualProviders;
    private final List<Provider<Collection<T>>> collectionProviders;

    public static <T> Factory<Set<T>> empty() {
        return EMPTY_FACTORY;
    }

    public static <T> Builder<T> builder(int individualProviderSize, int collectionProviderSize) {
        return new Builder(individualProviderSize, collectionProviderSize);
    }

    private SetFactory(List<Provider<T>> individualProviders, List<Provider<Collection<T>>> collectionProviders) {
        this.individualProviders = individualProviders;
        this.collectionProviders = collectionProviders;
    }

    @Override
    public Set<T> get() {
        int i4;
        int size = this.individualProviders.size();
        ArrayList<Collection<T>> providedCollections = new ArrayList<Collection<T>>(this.collectionProviders.size());
        int c4 = this.collectionProviders.size();
        for (int i5 = 0; i5 < c4; ++i5) {
            Collection<T> providedCollection = this.collectionProviders.get(i5).get();
            size += providedCollection.size();
            providedCollections.add(providedCollection);
        }
        HashSet providedValues = DaggerCollections.newHashSetWithExpectedSize(size);
        int c5 = this.individualProviders.size();
        for (i4 = 0; i4 < c5; ++i4) {
            providedValues.add(Preconditions.checkNotNull(this.individualProviders.get(i4).get()));
        }
        c5 = providedCollections.size();
        for (i4 = 0; i4 < c5; ++i4) {
            for (Object element : (Collection)providedCollections.get(i4)) {
                providedValues.add(Preconditions.checkNotNull(element));
            }
        }
        return Collections.unmodifiableSet(providedValues);
    }

    public static final class Builder<T> {
        private final List<Provider<T>> individualProviders;
        private final List<Provider<Collection<T>>> collectionProviders;

        private Builder(int individualProviderSize, int collectionProviderSize) {
            this.individualProviders = DaggerCollections.presizedList(individualProviderSize);
            this.collectionProviders = DaggerCollections.presizedList(collectionProviderSize);
        }

        public Builder<T> addProvider(Provider<? extends T> individualProvider) {
            assert (individualProvider != null) : "Codegen error? Null provider";
            this.individualProviders.add(individualProvider);
            return this;
        }

        public Builder<T> addCollectionProvider(Provider<? extends Collection<? extends T>> collectionProvider) {
            assert (collectionProvider != null) : "Codegen error? Null provider";
            this.collectionProviders.add(collectionProvider);
            return this;
        }

        public SetFactory<T> build() {
            assert (!DaggerCollections.hasDuplicates(this.individualProviders)) : "Codegen error?  Duplicates in the provider list";
            assert (!DaggerCollections.hasDuplicates(this.collectionProviders)) : "Codegen error?  Duplicates in the provider list";
            return new SetFactory(this.individualProviders, this.collectionProviders);
        }
    }
}

