/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.common.primitives.ParseRequest;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;

@Beta
@GwtCompatible
public final class UnsignedLongs {
    public static final long MAX_VALUE = -1L;

    private UnsignedLongs() {
    }

    private static long flip(long a5) {
        return a5 ^ Long.MIN_VALUE;
    }

    public static int compare(long a5, long b4) {
        return Longs.compare(UnsignedLongs.flip(a5), UnsignedLongs.flip(b4));
    }

    public static long min(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long min2 = UnsignedLongs.flip(array[0]);
        for (int i4 = 1; i4 < array.length; ++i4) {
            long next = UnsignedLongs.flip(array[i4]);
            if (next >= min2) continue;
            min2 = next;
        }
        return UnsignedLongs.flip(min2);
    }

    public static long max(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long max = UnsignedLongs.flip(array[0]);
        for (int i4 = 1; i4 < array.length; ++i4) {
            long next = UnsignedLongs.flip(array[i4]);
            if (next <= max) continue;
            max = next;
        }
        return UnsignedLongs.flip(max);
    }

    public static String join(String separator, long ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(UnsignedLongs.toString(array[0]));
        for (int i4 = 1; i4 < array.length; ++i4) {
            builder.append(separator).append(UnsignedLongs.toString(array[i4]));
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(long[] array) {
        Preconditions.checkNotNull(array);
        UnsignedLongs.sort(array, 0, array.length);
    }

    public static void sort(long[] array, int fromIndex, int toIndex) {
        int i4;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (i4 = fromIndex; i4 < toIndex; ++i4) {
            array[i4] = UnsignedLongs.flip(array[i4]);
        }
        Arrays.sort(array, fromIndex, toIndex);
        for (i4 = fromIndex; i4 < toIndex; ++i4) {
            array[i4] = UnsignedLongs.flip(array[i4]);
        }
    }

    public static void sortDescending(long[] array) {
        Preconditions.checkNotNull(array);
        UnsignedLongs.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(long[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i4 = fromIndex;
        while (i4 < toIndex) {
            int n4 = i4++;
            array[n4] = array[n4] ^ Long.MAX_VALUE;
        }
        Arrays.sort(array, fromIndex, toIndex);
        i4 = fromIndex;
        while (i4 < toIndex) {
            int n5 = i4++;
            array[n5] = array[n5] ^ Long.MAX_VALUE;
        }
    }

    public static long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(UnsignedLongs.compare(rem, divisor) >= 0 ? 1 : 0);
    }

    public static long remainder(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (UnsignedLongs.compare(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }

    @CanIgnoreReturnValue
    public static long parseUnsignedLong(String string) {
        return UnsignedLongs.parseUnsignedLong(string, 10);
    }

    @CanIgnoreReturnValue
    public static long parseUnsignedLong(String string, int radix) {
        Preconditions.checkNotNull(string);
        if (string.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException(new StringBuilder(26).append("illegal radix: ").append(radix).toString());
        }
        int maxSafePos = ParseOverflowDetection.maxSafeDigits[radix] - 1;
        long value = 0L;
        for (int pos = 0; pos < string.length(); ++pos) {
            int digit = Character.digit(string.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(string);
            }
            if (pos > maxSafePos && ParseOverflowDetection.overflowInParse(value, digit, radix)) {
                String string2 = String.valueOf(string);
                throw new NumberFormatException(string2.length() != 0 ? "Too large for unsigned long: ".concat(string2) : new String("Too large for unsigned long: "));
            }
            value = value * (long)radix + (long)digit;
        }
        return value;
    }

    @CanIgnoreReturnValue
    public static long decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedLongs.parseUnsignedLong(request.rawValue, request.radix);
        }
        catch (NumberFormatException e4) {
            String string = String.valueOf(stringValue);
            NumberFormatException decodeException = new NumberFormatException(string.length() != 0 ? "Error parsing value: ".concat(string) : new String("Error parsing value: "));
            decodeException.initCause(e4);
            throw decodeException;
        }
    }

    public static String toString(long x4) {
        return UnsignedLongs.toString(x4, 10);
    }

    public static String toString(long x4, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        if (x4 == 0L) {
            return "0";
        }
        if (x4 > 0L) {
            return Long.toString(x4, radix);
        }
        char[] buf = new char[64];
        int i4 = buf.length;
        if ((radix & radix - 1) == 0) {
            int shift = Integer.numberOfTrailingZeros(radix);
            int mask = radix - 1;
            do {
                buf[--i4] = Character.forDigit((int)x4 & mask, radix);
            } while ((x4 >>>= shift) != 0L);
        } else {
            long quotient = (radix & 1) == 0 ? (x4 >>> 1) / (long)(radix >>> 1) : UnsignedLongs.divide(x4, radix);
            long rem = x4 - quotient * (long)radix;
            buf[--i4] = Character.forDigit((int)rem, radix);
            for (x4 = quotient; x4 > 0L; x4 /= (long)radix) {
                buf[--i4] = Character.forDigit((int)(x4 % (long)radix), radix);
            }
        }
        return new String(buf, i4, buf.length - i4);
    }

    private static final class ParseOverflowDetection {
        static final long[] maxValueDivs = new long[37];
        static final int[] maxValueMods = new int[37];
        static final int[] maxSafeDigits = new int[37];

        private ParseOverflowDetection() {
        }

        static boolean overflowInParse(long current, int digit, int radix) {
            if (current >= 0L) {
                if (current < maxValueDivs[radix]) {
                    return false;
                }
                if (current > maxValueDivs[radix]) {
                    return true;
                }
                return digit > maxValueMods[radix];
            }
            return true;
        }

        static {
            BigInteger overflow = new BigInteger("10000000000000000", 16);
            for (int i4 = 2; i4 <= 36; ++i4) {
                ParseOverflowDetection.maxValueDivs[i4] = UnsignedLongs.divide(-1L, i4);
                ParseOverflowDetection.maxValueMods[i4] = (int)UnsignedLongs.remainder(-1L, i4);
                ParseOverflowDetection.maxSafeDigits[i4] = overflow.toString(i4).length() - 1;
            }
        }
    }

    static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left, long[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i4 = 0; i4 < minLength; ++i4) {
                if (left[i4] == right[i4]) continue;
                return UnsignedLongs.compare(left[i4], right[i4]);
            }
            return left.length - right.length;
        }

        public String toString() {
            return "UnsignedLongs.lexicographicalComparator()";
        }
    }
}

