/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@Beta
@GwtIncompatible
public final class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    public LittleEndianDataOutputStream(OutputStream out) {
        super(new DataOutputStream(Preconditions.checkNotNull(out)));
    }

    @Override
    public void write(byte[] b4, int off, int len) throws IOException {
        this.out.write(b4, off, len);
    }

    @Override
    public void writeBoolean(boolean v4) throws IOException {
        ((DataOutputStream)this.out).writeBoolean(v4);
    }

    @Override
    public void writeByte(int v4) throws IOException {
        ((DataOutputStream)this.out).writeByte(v4);
    }

    @Override
    @Deprecated
    public void writeBytes(String s4) throws IOException {
        ((DataOutputStream)this.out).writeBytes(s4);
    }

    @Override
    public void writeChar(int v4) throws IOException {
        this.writeShort(v4);
    }

    @Override
    public void writeChars(String s4) throws IOException {
        for (int i4 = 0; i4 < s4.length(); ++i4) {
            this.writeChar(s4.charAt(i4));
        }
    }

    @Override
    public void writeDouble(double v4) throws IOException {
        this.writeLong(Double.doubleToLongBits(v4));
    }

    @Override
    public void writeFloat(float v4) throws IOException {
        this.writeInt(Float.floatToIntBits(v4));
    }

    @Override
    public void writeInt(int v4) throws IOException {
        this.out.write(0xFF & v4);
        this.out.write(0xFF & v4 >> 8);
        this.out.write(0xFF & v4 >> 16);
        this.out.write(0xFF & v4 >> 24);
    }

    @Override
    public void writeLong(long v4) throws IOException {
        byte[] bytes = Longs.toByteArray(Long.reverseBytes(v4));
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeShort(int v4) throws IOException {
        this.out.write(0xFF & v4);
        this.out.write(0xFF & v4 >> 8);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        ((DataOutputStream)this.out).writeUTF(str);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

