/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.TokenizedCommandLine;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/android/utils/StringHelperPOSIX;", "", "()V", "splitCommandLine", "", "", "commandLine", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "common"})
public final class StringHelperPOSIX {
    @NotNull
    public static final StringHelperPOSIX INSTANCE = new StringHelperPOSIX();

    private StringHelperPOSIX() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitCommandLine(@NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull(commandLine, "commandLine");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "newArrayList()");
        List commands = arrayList;
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        int commandStart = 0;
        int i4 = 0;
        while (i4 < commandLine.length()) {
            char c4 = commandLine.charAt(i4);
            if (escaping) {
                escaping = false;
                ++i4;
                continue;
            }
            if (!(c4 != '\\' || quoting && quote != '\"')) {
                escaping = true;
                ++i4;
                continue;
            }
            if (!(quoting || c4 != '\"' && c4 != '\'')) {
                quoting = true;
                quote = c4;
                ++i4;
                continue;
            }
            if (quoting && c4 == quote) {
                quoting = false;
                quote = '\u0000';
                ++i4;
                continue;
            }
            if (!quoting) {
                int matched = 0;
                if (commandLine.length() > i4 + 1 && commandLine.charAt(i4) == '&' && commandLine.charAt(i4 + 1) == '&') {
                    matched = 2;
                } else if (commandLine.charAt(i4) == ';') {
                    matched = 1;
                }
                if (matched > 0) {
                    String string = commandLine;
                    boolean bl = false;
                    String string2 = string.substring(commandStart, i4);
                    Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    commands.add(string2);
                    commandStart = i4 += matched;
                }
            }
            ++i4;
        }
        if (commandStart < commandLine.length()) {
            String string = commandLine;
            boolean bl = false;
            String string3 = string.substring(commandStart);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
            commands.add(string3);
        }
        return commands;
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull(commandLine, "commandLine");
        return new TokenizedCommandLine(commandLine, false, 1, null, 8, null).toTokenList();
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull(commandLine, "commandLine");
        return new TokenizedCommandLine(commandLine, true, 1, null, 8, null).toTokenList();
    }
}

