/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Config;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;

public final class BundleValidationUtils {
    public static void checkHasValuesOrAlternatives(Targeting.AbiTargeting targeting, String directoryPath) {
        if (targeting.getValueCount() == 0 && targeting.getAlternativesCount() == 0) {
            throw InvalidBundleException.builder().withUserMessage("Directory '%s' has set but empty ABI targeting.", directoryPath).build();
        }
    }

    public static void checkHasValuesOrAlternatives(Targeting.LanguageTargeting targeting, String directoryPath) {
        if (targeting.getValueCount() == 0 && targeting.getAlternativesCount() == 0) {
            throw InvalidBundleException.builder().withUserMessage("Directory '%s' has set but empty language targeting.", directoryPath).build();
        }
    }

    public static void checkHasValuesOrAlternatives(Targeting.TextureCompressionFormatTargeting targeting, String directoryPath) {
        if (targeting.getValueCount() == 0 && targeting.getAlternativesCount() == 0) {
            throw InvalidBundleException.builder().withUserMessage("Directory '%s' has set but empty Texture Compression Format targeting.", directoryPath).build();
        }
    }

    public static boolean directoryContainsNoFiles(BundleModule module, ZipPath dir) {
        return module.findEntriesUnderPath(dir).count() == 0L;
    }

    public static boolean isAssetOnlyBundle(ImmutableList<BundleModule> modules) {
        return ((Config.BundleConfig)modules.stream().map(BundleModule::getBundleConfig).distinct().collect(MoreCollectors.toOptional()).orElseThrow(() -> InvalidBundleException.builder().withUserMessage("Bundle without modules.").build())).getType().equals(Config.BundleConfig.BundleType.ASSET_ONLY);
    }

    public static BundleModule expectBaseModule(ImmutableList<BundleModule> modules) {
        return modules.stream().filter(BundleModule::isBaseModule).findFirst().orElseThrow(BundleValidationUtils::createNoBaseModuleException);
    }

    public static InvalidBundleException createNoBaseModuleException() {
        return InvalidBundleException.createWithUserMessage("App Bundle does not contain a mandatory 'base' module.");
    }

    private BundleValidationUtils() {
    }
}

