/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.bundle.CodeTransparencyOuterClass;
import com.android.tools.build.bundletool.transparency.AutoValue_TransparencyCheckResult;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;

@AutoValue
public abstract class TransparencyCheckResult {
    abstract ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> codeRelatedFilesFromTransparencyMetadata();

    abstract ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> codeRelatedFilesFromBundle();

    abstract MapDifference<String, CodeTransparencyOuterClass.CodeRelatedFile> codeTransparencyDiff();

    public boolean verified() {
        return this.codeTransparencyDiff().areEqual();
    }

    public String getDiffAsString() {
        return "Files deleted after transparency metadata generation: " + this.codeTransparencyDiff().entriesOnlyOnLeft().keySet() + "\nFiles added after transparency metadata generation: " + this.codeTransparencyDiff().entriesOnlyOnRight().keySet() + "\nFiles modified after transparency metadata generation: " + this.codeTransparencyDiff().entriesDiffering().keySet();
    }

    public static TransparencyCheckResult create(ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> codeRelatedFilesFromTransparencyMetadata, ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> codeRelatedFilesFromBundle) {
        return new AutoValue_TransparencyCheckResult(codeRelatedFilesFromTransparencyMetadata, codeRelatedFilesFromBundle, Maps.difference(codeRelatedFilesFromTransparencyMetadata, codeRelatedFilesFromBundle));
    }
}

