/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Optional;

public final class WearApkLocator {
    static final String WEAR_APK_1_0_METADATA_KEY = "com.google.android.wearable.beta.app";

    public static ImmutableCollection<ZipPath> findEmbeddedWearApkPaths(ModuleSplit split) {
        if (!split.getResourceTable().isPresent()) {
            return ImmutableList.of();
        }
        Resources.ResourceTable resourceTable = split.getResourceTable().get();
        AndroidManifest manifest = split.getAndroidManifest();
        ImmutableCollection embeddedWearApkPaths = manifest.getMetadataResourceId(WEAR_APK_1_0_METADATA_KEY).map(resourceId -> WearApkLocator.findXmlDescriptionResourceEntry(resourceTable, resourceId)).map(entry -> WearApkLocator.getXmlDescriptionPath(entry)).map(xmlDescriptionPath -> WearApkLocator.findXmlDescriptionZipEntry(split, xmlDescriptionPath)).flatMap(xmlDescriptionEntry -> WearApkLocator.extractWearApkName(xmlDescriptionEntry)).flatMap(resourceName -> ResourcesUtils.lookupEntryByResourceTypeAndName(resourceTable, "raw", resourceName)).map(entry -> entry.getConfigValueList().stream().map(configValue -> configValue.getValue().getItem().getFile().getPath()).filter(Predicates.not(String::isEmpty)).map(ZipPath::create).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
        embeddedWearApkPaths.forEach(path -> {
            if (!split.findEntry((ZipPath)path).isPresent()) {
                throw InvalidBundleException.builder().withUserMessage("Wear APK expected at location '%s' but was not found.", path).build();
            }
        });
        return embeddedWearApkPaths;
    }

    private static Resources.Entry findXmlDescriptionResourceEntry(Resources.ResourceTable resourceTable, int resourceId) {
        return ResourcesUtils.lookupEntryByResourceId(resourceTable, resourceId).orElseThrow(() -> InvalidBundleException.builder().withUserMessage("Resource 0x%08x is referenced in the manifest in the '%s' metadata, but was not found in the resource table.", resourceId, WEAR_APK_1_0_METADATA_KEY).build());
    }

    private static String getXmlDescriptionPath(Resources.Entry entry) {
        Preconditions.checkState(entry.getConfigValueCount() > 0, "Resource table entry without value: %s", (Object)entry);
        if (entry.getConfigValueCount() > 1) {
            throw InvalidBundleException.createWithUserMessage("More than one embedded Wear APK is not supported.");
        }
        Resources.ConfigValue configValue = Iterables.getOnlyElement(entry.getConfigValueList());
        String xmlDescriptionPath = configValue.getValue().getItem().getFile().getPath();
        if (xmlDescriptionPath.isEmpty()) {
            throw InvalidBundleException.createWithUserMessage("No XML description file path found for Wear APK.");
        }
        return xmlDescriptionPath;
    }

    private static ModuleEntry findXmlDescriptionZipEntry(ModuleSplit split, String xmlDescPath) {
        return split.findEntry(xmlDescPath).orElseThrow(() -> InvalidBundleException.builder().withUserMessage("Wear APK XML description file expected at '%s' but was not found.", xmlDescPath).build());
    }

    private static Optional<String> extractWearApkName(ModuleEntry wearApkDescriptionXmlEntry) {
        XmlProtoNode root;
        try (InputStream content = wearApkDescriptionXmlEntry.getContent().openStream();){
            root = new XmlProtoNode(Resources.XmlNode.parseFrom(content));
        }
        catch (InvalidProtocolBufferException e4) {
            throw InvalidBundleException.builder().withCause(e4).withUserMessage("The wear APK description file '%s' could not be parsed.", wearApkDescriptionXmlEntry.getPath()).build();
        }
        catch (IOException e5) {
            throw new UncheckedIOException(String.format("An unexpected error occurred while reading APK description file '%s'.", wearApkDescriptionXmlEntry.getPath()), e5);
        }
        if (((XmlProtoElement)root.getElement()).getOptionalChildElement("unbundled").isPresent()) {
            return Optional.empty();
        }
        Optional rawPathResId = ((XmlProtoElement)root.getElement()).getOptionalChildElement("rawPathResId");
        if (!rawPathResId.isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("The wear APK description file '%s' does not contain 'unbundled' or 'rawPathResId'.", wearApkDescriptionXmlEntry.getPath()).build();
        }
        return Optional.of(((XmlProtoNode)((XmlProtoElement)rawPathResId.get()).getChildText().get()).getText());
    }

    private WearApkLocator() {
    }
}

