/*
 * Decompiled with CFR 0.152.
 */
package com.android.incfs.install.adb.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutException;
import com.android.incfs.install.IDeviceConnection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class DeviceConnection
implements IDeviceConnection {
    private final SocketChannel mChannel;
    private final Selector mReadSelector;
    private final Selector mWriteSelector;

    public static Factory getFactory(String deviceSerialNumber) throws IOException {
        AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
        if (adb == null) {
            throw new IOException("Unable to connect to adb");
        }
        for (IDevice device : adb.getDevices()) {
            if (!deviceSerialNumber.equals(device.getSerialNumber())) continue;
            return new Factory(device);
        }
        throw new IOException("Failed to find device with serial \"" + deviceSerialNumber + "\"");
    }

    private DeviceConnection(SocketChannel channel) throws IOException {
        this.mChannel = channel;
        this.mChannel.configureBlocking(false);
        this.mReadSelector = Selector.open();
        this.mChannel.register(this.mReadSelector, 1);
        this.mWriteSelector = Selector.open();
        this.mChannel.register(this.mWriteSelector, 4);
    }

    @Override
    public int read(ByteBuffer dst, long timeoutMs) throws IOException {
        this.mReadSelector.select(timeoutMs);
        return this.mChannel.read(dst);
    }

    @Override
    public int write(ByteBuffer src, long timeoutMs) throws IOException {
        this.mWriteSelector.select(timeoutMs);
        return this.mChannel.write(src);
    }

    @Override
    public void close() throws Exception {
        try (SocketChannel c4 = this.mChannel;
             Selector r4 = this.mReadSelector;){
            Selector w4 = this.mWriteSelector;
            if (w4 != null) {
                w4.close();
            }
        }
    }

    public static class Factory
    implements IDeviceConnection.Factory {
        private final IDevice mDevice;

        private Factory(IDevice device) {
            this.mDevice = device;
        }

        @Override
        public IDeviceConnection connectToService(String service, String[] parameters) throws IOException {
            SocketChannel channel;
            try {
                channel = this.mDevice.rawBinder(service, parameters);
            }
            catch (AdbCommandRejectedException | TimeoutException e4) {
                throw new IOException(String.format("Failed invoking binder command \"%s %s\"", service, String.join((CharSequence)" ", parameters)), e4);
            }
            channel.configureBlocking(false);
            return new DeviceConnection(channel);
        }
    }
}

