/*
 * Decompiled with CFR 0.152.
 */
package com.android.incfs.install;

import com.android.incfs.install.IBlockFilter;
import com.android.incfs.install.IDeviceConnection;
import com.android.incfs.install.ILogger;
import com.android.incfs.install.IncrementalInstallSessionImpl;
import com.android.incfs.install.StreamingApk;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class IncrementalInstallSession
implements AutoCloseable {
    private final String[] mCommandArgs;
    private final ArrayList<StreamingApk> mApks;
    private final long mResponseTimeoutNs;
    private final ILogger mLogger;
    private IncrementalInstallSessionImpl mImpl;

    private IncrementalInstallSession(String[] commandArgs, ArrayList<StreamingApk> apks, long responseTimeoutNs, ILogger logger) {
        this.mCommandArgs = commandArgs;
        this.mApks = apks;
        this.mResponseTimeoutNs = responseTimeoutNs;
        this.mLogger = logger;
    }

    public synchronized IncrementalInstallSession start(Executor executor, IDeviceConnection.Factory conFactory) throws IOException {
        if (this.mImpl != null) {
            throw new IllegalStateException("Session cannot be started multiple time.");
        }
        IDeviceConnection con = conFactory.connectToService("package", this.mCommandArgs);
        this.mImpl = new IncrementalInstallSessionImpl(con, this.mApks, this.mResponseTimeoutNs, this.mLogger);
        this.mImpl.execute(executor);
        return this;
    }

    public void waitForInstallCompleted(long timeout, TimeUnit units) throws IOException, InterruptedException {
        this.mImpl.waitForInstallCompleted(timeout, units);
    }

    public void waitForServingCompleted(long timeout, TimeUnit units) throws IOException, InterruptedException {
        this.mImpl.waitForServingCompleted(timeout, units);
    }

    @Override
    public void close() {
        IncrementalInstallSessionImpl impl = this.mImpl;
        if (impl != null) {
            impl.close();
        }
    }

    private static class NullLogger
    implements ILogger {
        private NullLogger() {
        }

        @Override
        public void error(Throwable t4, String msgFormat, Object ... args2) {
        }

        @Override
        public void warning(String msgFormat, Object ... args2) {
        }

        @Override
        public void info(String msgFormat, Object ... args2) {
        }

        @Override
        public void verbose(String msgFormat, Object ... args2) {
        }
    }

    public static class Builder {
        private final List<Path> mApks = new ArrayList<Path>();
        private final List<Path> mSignatures = new ArrayList<Path>();
        private final List<String> mArgs = new ArrayList<String>();
        private IBlockFilter mFilter = PendingBlock2 -> true;
        private ILogger mLogger = new NullLogger();
        private long mResponseTimeoutNs = 0L;
        private boolean mReinstall;

        public Builder addApk(Path apk, Path signature) {
            this.mApks.add(apk);
            this.mSignatures.add(signature);
            return this;
        }

        public Builder addExtraArgs(String ... extraArgs) {
            this.mArgs.addAll(Arrays.asList(extraArgs));
            return this;
        }

        public Builder setAllowReinstall(boolean reinstall) {
            this.mReinstall = reinstall;
            return this;
        }

        public Builder setBlockFilter(IBlockFilter filter) {
            this.mFilter = filter;
            return this;
        }

        public Builder setLogger(ILogger logger) {
            this.mLogger = logger;
            return this;
        }

        public Builder setResponseTimeout(long timeout, TimeUnit maxTimeUnits) {
            this.mResponseTimeoutNs = maxTimeUnits.toNanos(timeout);
            return this;
        }

        public IncrementalInstallSession build() throws IOException {
            ArrayList<String> commandBuilder = new ArrayList<String>();
            commandBuilder.add("install-incremental");
            if (this.mReinstall) {
                commandBuilder.add("-r");
            }
            commandBuilder.addAll(this.mArgs);
            ArrayList<StreamingApk> apkArguments = new ArrayList<StreamingApk>();
            for (int i4 = 0; i4 < this.mApks.size(); ++i4) {
                Path apk = this.mApks.get(i4);
                Path signature = this.mSignatures.get(i4);
                StreamingApk apkArgument = StreamingApk.generate(apk, signature, this.mFilter, this.mLogger);
                apkArguments.add(apkArgument);
                commandBuilder.add(String.format(Locale.US, "arg%1$d.apk:%2$d:%1$d:%3$s:1", i4, Files.size(apk), apkArgument.getSignatureBase64()));
            }
            return new IncrementalInstallSession(commandBuilder.toArray(new String[0]), apkArguments, this.mResponseTimeoutNs, this.mLogger);
        }
    }
}

