/*
 * Decompiled with CFR 0.152.
 */
package com.excelliance.lbsdk.life;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import com.excelliance.lbsdk.LBSdkHelper;
import com.excelliance.lbsdk.base.BaseUtil;
import com.excelliance.lbsdk.base.h;
import com.excelliance.lbsdk.e.i;
import com.excelliance.lbsdk.life.LifeCycleContentProvider;
import com.excelliance.lbsdk.life.c;
import java.io.File;

public class LifeCycleHelper {
    private static final String TAG = "LifeCycle";
    public static final String PROVIDER_NAME = "com.excelliance.lbsdk.life.LifeCycleContentProvider";
    private static String sAuthority;
    public static final int CREATE = 1;
    public static final int START = 2;
    public static final int RESUME = 3;
    public static final int PAUSE = 4;
    public static final int STOP = 5;
    public static final int DESTROY = 6;
    public static final String MODULE_FIRST = "first";
    public static final String MODULE_ITEM = "item";
    public static final String MODULE_LBMAIN = "lbmain";
    private static Uri mContentUri;
    private static Uri mContentUriLBMain;
    private static LifeCycleHelper instance;
    private static boolean mInit = false;
    private static boolean mHasRegistered = false;
    private Context mContext;
    private ContentResolver mResolver;

    private LifeCycleHelper(Context context) {
        this.mContext = context;
        boolean bl = mInit = h.a(context, "DONT_USE_ACTIVITY_TASK", false) && this.hasLifeCycleProvider(LBSdkHelper.a(context));
        if (mInit) {
            Context context2 = context;
            this.mResolver = context.getContentResolver();
            mContentUri = LifeCycleHelper.generateContentUri(context2, MODULE_ITEM);
            mContentUriLBMain = LifeCycleHelper.generateContentUri(context2, MODULE_LBMAIN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LifeCycleHelper getInstance(Context context) {
        if (instance != null) return instance;
        Class<LifeCycleHelper> clazz = LifeCycleHelper.class;
        synchronized (LifeCycleHelper.class) {
            if (instance != null) return instance;
            instance = new LifeCycleHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isLBMainOnTop(Context context) {
        return LifeCycleHelper.isLBMainOnTop(context, false);
    }

    public static boolean isLBMainOnTop(Context object, boolean bl) {
        if (mInit) {
            int n2;
            int n3;
            int n4;
            object = object.getContentResolver().query(mContentUriLBMain, null, null, null, null);
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            if (object != null) {
                while (object.moveToNext()) {
                    Object object2 = object;
                    n5 = object2.getInt(0);
                    n6 = object2.getInt(1);
                    n7 = object2.getInt(2);
                }
                object.close();
            }
            a.a(TAG, "isLBMainOnTop: nc:" + n5 + " p:" + n6 + " a:" + n7);
            return n5 > 0 && n5 < (n4 = bl ? 5 : 4) || n6 > 0 && n6 < (n3 = bl ? 5 : 4) || n7 > 0 && n7 < (n2 = bl ? 5 : 4);
        }
        return (object = BaseUtil.d((Context)object)) != null && (((String)object).contains("com.excelliance.open.NextChapter") || ((String)object).contains("com.excelliance.open.PromptActivity"));
    }

    public static boolean isNextChapterOnTop(Context object) {
        if (mInit) {
            object = object.getContentResolver().query(mContentUriLBMain, null, null, null, null);
            int n2 = -1;
            if (object != null) {
                while (object.moveToNext()) {
                    n2 = object.getInt(0);
                }
                object.close();
            }
            a.a(TAG, "isNextChapterOnTop: nc:" + n2);
            return n2 > 0 && n2 < 4;
        }
        return (object = BaseUtil.d((Context)object)) != null && ((String)object).contains("com.excelliance.open.NextChapter");
    }

    public static boolean isPromptOnTop(Context object) {
        if (mInit) {
            object = object.getContentResolver().query(mContentUriLBMain, null, null, null, null);
            int n2 = -1;
            if (object != null) {
                while (object.moveToNext()) {
                    n2 = object.getInt(1);
                }
                object.close();
            }
            a.a(TAG, "isPromptOnTop: p:" + n2);
            return n2 > 0 && n2 < 4;
        }
        return (object = BaseUtil.d((Context)object)) != null && ((String)object).contains("com.excelliance.open.PromptActivity");
    }

    public static boolean isAssistOnTop(Context object) {
        if (mInit) {
            object = object.getContentResolver().query(mContentUriLBMain, null, null, null, null);
            int n2 = -1;
            if (object != null) {
                while (object.moveToNext()) {
                    n2 = object.getInt(2);
                }
                object.close();
            }
            a.a(TAG, "isAssistOnTop: a:" + n2);
            return n2 > 0 && n2 < 4;
        }
        return (object = BaseUtil.d((Context)object)) != null && ((String)object).contains("com.excelliance.open.AssistActivity");
    }

    public static boolean isForeground(Context context) {
        if (mInit) {
            return !LifeCycleHelper.isFirstActivityCreate(context) || LifeCycleHelper.getForegroundTopActivity(context) != null;
        }
        return BaseUtil.g(context);
    }

    public static boolean isTopActivity(Context context) {
        if (mInit) {
            return LifeCycleHelper.getForegroundTopActivity(context) != null;
        }
        return BaseUtil.j(context);
    }

    public static boolean isFirstActivityCreate(Context context) {
        context = context.getContentResolver().query(LifeCycleHelper.generateContentUri(context, MODULE_FIRST), null, null, null, null);
        int n2 = 0;
        if (context != null) {
            while (context.moveToNext()) {
                n2 = context.getInt(0);
            }
            context.close();
        }
        return n2 == 1;
    }

    public static String getTopActivity(Context context) {
        if (mInit) {
            context = context.getContentResolver().query(LifeCycleHelper.generateContentUri(context, MODULE_ITEM), null, null, null, null);
            Object object = null;
            if (context != null) {
                while (context.moveToNext()) {
                    c c2;
                    object = c2;
                    ((c)object)();
                    ((c)object).a = context.getInt(0);
                    ((c)object).b = context.getInt(1);
                    ((c)object).c = context.getString(2);
                    c2.d = context.getInt(3);
                    object = c2.c;
                }
                context.close();
            }
            return object;
        }
        return BaseUtil.d(context);
    }

    public static String getForegroundTopActivity(Context context) {
        context = context.getContentResolver().query(LifeCycleHelper.generateContentUri(context, MODULE_ITEM), null, null, null, null);
        String string = null;
        if (context != null) {
            while (context.moveToNext()) {
                c c2;
                c c3 = c2;
                c3();
                c3.a = context.getInt(0);
                c3.b = context.getInt(1);
                c3.c = context.getString(2);
                c2.d = context.getInt(3);
                if (c2.d <= 4) {
                    string = c3.c;
                }
                a.a(TAG, "getForegroundTopActivity: " + string + " status:" + c3.d);
            }
            context.close();
        }
        return string;
    }

    public static void clearActivityStack(Context stringArray, int n2) {
        if (mInit) {
            ContentResolver contentResolver = stringArray.getContentResolver();
            Uri uri = LifeCycleHelper.generateContentUri((Context)stringArray, MODULE_ITEM);
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String.valueOf(n2);
            contentResolver.delete(uri, "", stringArray);
        }
    }

    private static synchronized String getAuthority(Context context) {
        PackageManager packageManager;
        String string = sAuthority;
        if (string != null) {
            return string;
        }
        try {
            ComponentName componentName;
            string = componentName;
            componentName = new ComponentName(context.getPackageName(), LifeCycleContentProvider.class.getName());
            packageManager = context.getPackageManager();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            throw new i("LifeCycleProvider should be defined in your AndroidManifest.xml");
        }
        sAuthority = packageManager.getProviderInfo((ComponentName)string, (int)65536).authority;
        return sAuthority;
    }

    private static Uri generateContentUri(Context context, String string) {
        StringBuilder stringBuilder;
        String string2;
        try {
            string2 = LifeCycleHelper.getAuthority(context);
            stringBuilder = new StringBuilder();
        }
        catch (Exception exception) {
            a.a(TAG, "no provider");
            mInit = false;
            return null;
        }
        return Uri.withAppendedPath((Uri)Uri.parse((String)stringBuilder.append("content://").append(string2).toString()), (String)string);
    }

    private boolean hasLifeCycleProvider(PackageInfo packageInfo) {
        if (packageInfo != null) {
            ProviderInfo[] providerInfoArray = packageInfo.providers;
            if (packageInfo.providers != null && providerInfoArray.length != 0) {
                int n2 = providerInfoArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!PROVIDER_NAME.equals(providerInfoArray[i2].name)) continue;
                    a.a(TAG, "has LifeCycleProvider");
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void checkDisableLifeCycle() {
        if (mInit) {
            mInit = new File(this.mContext.getCacheDir().getParent(), "disable_life_cycle").exists() ^ true;
        }
    }

    public void setActivityStatus(c c2) {
        if (mInit) {
            ContentValues contentValues;
            LifeCycleHelper lifeCycleHelper = lifeCycleHelper2;
            LifeCycleHelper lifeCycleHelper2 = contentValues;
            lifeCycleHelper2();
            lifeCycleHelper2.put("hashcode", c2.a);
            lifeCycleHelper2.put("pid", c2.b);
            lifeCycleHelper2.put("name", c2.c);
            contentValues.put("status", Integer.valueOf(c2.d));
            lifeCycleHelper.mResolver.insert(mContentUri, (ContentValues)lifeCycleHelper2);
        }
    }

    @TargetApi(value=14)
    public void registerLifeCycle(Application application) {
        if (!mInit) {
            return;
        }
        if (mHasRegistered) {
            a.a(TAG, "has Registered");
            return;
        }
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new com.excelliance.lbsdk.life.a(this));
        mHasRegistered = true;
    }

    public static class a {
        public static void a(String string, String string2) {
            com.excelliance.lbsdk.f.c.a(string, string2, new Object[0]);
        }
    }
}

