package com.excelliance.open.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.TextView;

import com.excelliance.lbui.R;
import com.excelliance.open.BaseActivity;
import com.excelliance.open.BwbxUI;

import java.lang.reflect.Field;

/**
 * 资源文件加载对话框
 */
public class LoadingDialog extends Dialog {

    public LoadingDialog(Context context, int theme) {
        super(context, theme);
    }

    public LoadingDialog(Context context) {
        super(context);
    }

    /**
     * 设置表示loading进度的文字
     * @param progress 文字内容
     */
    public void setProgress(String progress) {
        TextView textProgress = (TextView) this.findViewById(R.id.lebian_text_progress_loading);
        if (textProgress != null) {
            textProgress.setText(progress);
        }
    }

    /**
     * Helper class for creating a custom dialog
     */
    public static class Builder {

        private Context context;
        private View contentView;
        private String progressText;

		public Builder(Context context) {
			this.context = context;
		}

        public Builder(Context context, Context topActivity) {
            this.context = new BaseActivity.LebianContext(topActivity,android.R.style.Theme, BwbxUI.getResources(context));
        }

        /**
         * 设置表示loading进度的文字
         * @param progress 文字内容
         * @return
         */
        public Builder setProgress(String progress) {
            this.progressText = progress;
            return this;
        }

        /**
         * Create the loading dialog
         */
        public LoadingDialog create() {
            LayoutInflater inflater = (LayoutInflater) context
                                      .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            // instantiate the dialog with the custom Theme
            inflater = inflater.cloneInContext(context);
            try {
                Class inflateClass = Class.forName("android.view.LayoutInflater", false, context.getClassLoader());
                Field f1 = inflateClass.getDeclaredField("mFactory");
                f1.setAccessible(true);
                Field f2 = inflateClass.getDeclaredField("mFactory2");
                f2.setAccessible(true);
                f1.set(inflater,null);
                f2.set(inflater,null);
            } catch (Exception e) {
                e.printStackTrace();
            }

            // TODO style 不一样
            final LoadingDialog dialog = new LoadingDialog(context, R.style.lebian_dialog_theme);
			dialog.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);

            View layout = contentView;
            if (null == layout) {
                layout = inflater.inflate(R.layout.lebian_progress_dialog, null);
            }
            dialog.setContentView(layout);
            dialog.setProgress(progressText);
            return dialog;
        }
    }
}


