package com.excelliance.open;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;

import java.lang.ref.WeakReference;

/**
 * 用来获取当前window信息的类
 */
public class LbUiWindowManager {
    private static LbUiWindowManager mLbUiWindowManager;
    private WeakReference<Context> mContextWeakReference;
    private WindowManager mWindowManager;

    private LbUiWindowManager(Context context) {
        mContextWeakReference = new WeakReference<>(context);
        mWindowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    }

    public static LbUiWindowManager getInstance(Context context) {
        if (mLbUiWindowManager == null) {
            synchronized (LbUiWindowManager.class) {
                if (mLbUiWindowManager == null) {
                    mLbUiWindowManager = new LbUiWindowManager(context);
                }
            }
        }
        return mLbUiWindowManager;
    }

    /**
     * 获取当前窗口的宽度。
     *
     * @param context context
     * @return 窗口宽度
     */
    public int getScreenWidth(Context context) {
        int screenWidth = 0;
        if (mWindowManager != null && context != null) {
            int screenHeight;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                mWindowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
                screenWidth = displayMetrics.widthPixels;
                screenHeight = displayMetrics.heightPixels;
            } else {
                screenWidth = mWindowManager.getDefaultDisplay().getWidth();
                screenHeight = mWindowManager.getDefaultDisplay().getHeight();
            }
            String className = NextChapter.class.getName();
            if (context instanceof LProgressActivity) {
                className = LProgressActivity.class.getName();
            } else if (context instanceof PProgressActivity) {
                className = PProgressActivity.class.getName();
            }
            if (BwbxUI.isLandscape(mContextWeakReference.get(), className)) {
                screenWidth = Math.max(screenHeight, screenWidth);
            }
        }
        return screenWidth;
    }

    /**
     * 获取当前窗口高度
     *
     * @param context context
     * @return 窗口高度
     */
    public int getScreenHeight(Context context) {
        int screenHeight = 0;
        if (mWindowManager != null && context != null) {
            int screenWidth;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                mWindowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
                screenWidth = displayMetrics.widthPixels;
                screenHeight = displayMetrics.heightPixels;
            } else {
                screenWidth = mWindowManager.getDefaultDisplay().getWidth();
                screenHeight = mWindowManager.getDefaultDisplay().getHeight();
            }
            String className = NextChapter.class.getName();
            if (context instanceof LProgressActivity) {
                className = LProgressActivity.class.getName();
            } else if (context instanceof PProgressActivity) {
                className = PProgressActivity.class.getName();
            }
            if (BwbxUI.isLandscape(mContextWeakReference.get(), className)) {
                screenHeight = Math.min(screenHeight, screenWidth);
            }
        }
        return screenHeight;
    }
}
