package com.excelliance.open;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

/**
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 * LProgressActivity 只是为了方便客户在修改了“layout”和“res”后查看ui效果，这里的代码集成后的包里并不会执行，如需修改代码请修改com.excelliance.open.NextChapter
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
public class LProgressActivity extends Activity {
    private Resources mResources;
    private String mPackageName;
    private TextView textStatus;
    private TextView textProgress;
    private ProgressBar progressBar;
    private TextView resStatus;
    private String strStatus;
    private Runnable runnable = null;
    private int timer = 0;
    Handler mHandler = new Handler(){
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what){
                case 1://textStatus
                    textStatus.setText((String)msg.obj);
                    break;
                case 2://textProgress
                    textProgress.setText((String)msg.obj);
                    break;
                case 3://progressBar
                    progressBar.setProgress(msg.arg1);
                    break;
                case 4://textProgress visible
                    textProgress.setVisibility(msg.arg1);
                    break;
            }
        }
    };
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mResources = getResources();
        mPackageName = getPackageName();
        setContentView(mResources.getIdentifier("lebian_next_chapter", "layout", mPackageName));
        int resId = getResources().getIdentifier("lebian_text_status", "id", mPackageName);
        int resId2 = mResources.getIdentifier("lebian_text_progress", "id", mPackageName);
        int resId3 = mResources.getIdentifier("lebian_progressBar", "id", mPackageName);
        int resId4 = mResources.getIdentifier("lebian_resource_status", "id", mPackageName);
        textStatus = findViewById(resId);
        textProgress = findViewById(resId2);
        progressBar = findViewById(resId3);
        resStatus = findViewById(resId4);
        //设置布满全屏
        WindowManager wm = (WindowManager)getSystemService(Context.WINDOW_SERVICE);
        int screenWidth = 0;
        int screenHeight = 0;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            wm.getDefaultDisplay().getRealMetrics(displayMetrics);
            screenWidth = displayMetrics.widthPixels;
            screenHeight = displayMetrics.heightPixels;
        } else {
            screenWidth = wm.getDefaultDisplay().getWidth();
            screenHeight = wm.getDefaultDisplay().getHeight();
        }
        if (BwbxUI.isLandscape(this, LProgressActivity.class.getName())) {
            screenWidth = screenWidth > screenHeight ? screenWidth : screenHeight;
        }
        int progressResId = mResources.getIdentifier("lebian_barcolor", "drawable", mPackageName);
        Drawable progressDrawable = mResources.getDrawable(progressResId);
        progressBar.setProgressDrawable(progressDrawable);
        progressBar.setLayoutParams(new FrameLayout.LayoutParams((int)(screenWidth*0.8), dip2px(this, 14)));

    }

    /**
     * 根据手机的分辨率从 dp 的单位 转成为 px(像素)
     */
    public static int dip2px(Context context, float dpValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }

    @Override
    protected void onResume() {
        super.onResume();
        runnable = new Runnable() {
            @Override
            public void run() {
                if (timer >= 4){
                    timer = 0;
                }
                switch (timer) {
                    case 0:
                        textStatus.setText(strStatus);
                        break;
                    case 1:
                        textStatus.setText(strStatus + ".");
                        break;
                    case 2:
                        textStatus.setText(strStatus + "..");
                        break;
                    case 3:
                        textStatus.setText(strStatus + "...");
                        break;
                }
                timer++;
                mHandler.postDelayed(this, 800);
            }
        };
        progressBar.setVisibility(View.VISIBLE);
        textProgress.setVisibility(View.VISIBLE);
        textStatus.setVisibility(View.VISIBLE);
        resStatus.setVisibility(View.INVISIBLE);
        progressBar.setMax(100);
        int resId = getResources().getIdentifier("lebian_dl_status_updating", "string", mPackageName);
        strStatus = getResources().getString(resId);
        textStatus.setText(strStatus);
        mHandler.removeCallbacks(runnable);
        mHandler.postDelayed(runnable, 800);
        //开始下载
        new Thread(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i <= 100; i++) {
                    Message message = new Message();
                    message.what= 3; // 更新进度
                    message.arg1 = i;
                    mHandler.sendMessage(message);
                    Message message2 = new Message();
                    message2.what = 2; // 更新textProgress
                    message2.obj = String.format("%.2fMB/%.2fMB", (float) i, (float) 100);
                    mHandler.sendMessage(message2);
                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                //开始解压
                int resId = getResources().getIdentifier("lebian_dl_status_extract", "string", mPackageName);
                strStatus = getResources().getString(resId);
                Message message3 = new Message();
                message3.what= 1;// 更新strStatus
                message3.obj = strStatus;
                mHandler.sendMessage(message3);
                Message message4 = new Message();
                message4.what = 4;  // 更新可见性
                message4.arg1 = View.INVISIBLE;
                mHandler.sendMessage(message4);

                for (int i = 0; i <= 100; i++) {
                    Message message5 = new Message();
                    message5.what= 3; // 更新进度
                    message5.arg1 = i;
                    mHandler.sendMessage(message5);
                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }

                //解压完成
                mHandler.removeCallbacks(runnable);
                resId = getResources().getIdentifier("lebian_dl_status_downloaded", "string", mPackageName);
                strStatus = getResources().getString(resId);
                Message message6 = new Message();
                message6.what= 1;// 更新strStatus
                message6.obj = strStatus;
                mHandler.sendMessage(message6);
            }
        }).start();

    }
}
