package com.excelliance.open;

import android.content.Context;
import android.content.res.Configuration;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ProgressBar;

public class AdaptiveProgressBar extends ProgressBar {

    private LbUiWindowManager mLbUiWindowManager;
    private double mWidthScale = 1;
    private double mHeightScale = 1;
    private Context mContext;

    public AdaptiveProgressBar(Context context) {
        this(context, null);
    }

    public AdaptiveProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        mLbUiWindowManager = LbUiWindowManager.getInstance(context);
        mContext = context;
    }


    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        updateLayoutParams(mWidthScale, mHeightScale);
    }

    /**
     * 缩放指定倍数
     *
     * @param widthScale  宽度缩放倍数
     * @param heightScale 高度缩放倍数
     */
    public void updateLayoutParams(double widthScale, double heightScale) {
        mWidthScale = widthScale;
        mHeightScale = heightScale;
        ViewGroup.LayoutParams layoutParams = getLayoutParams();
        layoutParams.width = (int) (mLbUiWindowManager.getScreenWidth(mContext) * widthScale);
        layoutParams.height = (int) (layoutParams.height * heightScale);
        setLayoutParams(layoutParams);
    }
}
