package com.excelliance.open.floatwindow;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.excelliance.lbui.R;
import com.excelliance.open.BwbxUI;
import com.excelliance.open.utils.MainUtil;

public class RecordFloatWindow extends BaseFloatWindow {

    private static long mSize = 0;
    private static int mCount = 0;
    private TextView mSizeTv;

    private boolean isUploading;
    private TextView upload;

    public RecordFloatWindow(Context context, Activity activity) {
        super(context,activity);
    }

    @Override
    protected View getLogoView(LayoutInflater inflater) {
        Resources res = BwbxUI.getResources(mContext);
        XmlResourceParser parser = res.getLayout(R.layout.lebian_float_window_record);
        ViewGroup view = (ViewGroup) inflater.inflate(parser, null);
        view.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.WRAP_CONTENT));
        mSizeTv = view.findViewById(R.id.lebian_float_size_text);
        if (mSizeTv == null) {
            mSizeTv = (TextView) view.getChildAt(0);
        }
        upload = view.findViewById(R.id.lebian_upload_record);
        upload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                uploadRecord(mContext);
            }
        });
        return view;
    }

    @Override
    protected void doOpen() {

    }

    public void setPkgSize(int count, long size){
        mSize = size;
        mCount = count;
        mSizeTv.setText(String.format("count:%d size:%.2fM", count, ((double) mSize) / (1024.00 * 1024.00)));
    }

    @Override
    public void show() {
        super.show();
        setPkgSize(mCount, mSize);
    }

    public void destroy() {
        mActivity = null;
        mContext = null;
    }

    private String getPackageName(){
        return mContext.getPackageName();
    }


    private void uploadRecord(Context context) {
        if (isUploading) {
            return;
        }
        isUploading = true;
        final Handler handler = new Handler();
        upload.setText("上传中...");
        new Thread(new Runnable() {
            @Override
            public void run() {
                final boolean success = MainUtil.uploadRecord(mContext);
                handler.post(new Runnable() {
                    @Override
                    public void run() {
                        endUpload(success);
                    }
                });
            }
        }).start();
    }

    private void endUpload(boolean success) {
        upload.setText("上传");
        isUploading = false;
        if (success) {
            Toast.makeText(mContext, "上传成功", Toast.LENGTH_LONG).show();
        } else {
            Toast.makeText(mContext, "上传失败", Toast.LENGTH_LONG).show();
        }
    }
}
