package com.excelliance.open;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

import com.excelliance.lbui.R;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class AssistActivity extends BaseActivity{

    private Parcelable assistActivityParcel = null;
    public static String TAG = "AssistActivity";
    private boolean fromInstall;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        setTheme(R.style.LebianNoActionBarFullscreenTheme);
        Log.d(TAG, "onCreate savedInstanceState=" + savedInstanceState);
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            assistActivityParcel = savedInstanceState.getParcelable("AssistActivityParcel");
        } else {
            try {
                Class clazz = BwbxUI.getClass("main.AssistActivityParcel");
                Constructor cons = clazz.getDeclaredConstructor(Parcel.class);
                cons.setAccessible(true);
                assistActivityParcel = (Parcelable) cons.newInstance((Parcel) null);
            } catch (Exception e) {
                Log.d(TAG, "no AssistActivityParcel");
                e.printStackTrace();
            }
        }
        if (assistActivityParcel != null) {
            callAssistActivityParcel("init", new Class[]{Activity.class, Bundle.class}, new Object[]{this, savedInstanceState});
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (assistActivityParcel != null) {
            outState.putParcelable("AssistActivityParcel", assistActivityParcel);
        }
    }

    @Override
    protected void onPause() {
        Log.d(TAG, "onPause");
        super.onPause();
        callAssistActivityParcel("onPause", null, null);
    }


    @Override
    protected void onResume() {
        Log.d(TAG, "onResume fromInstall= "+fromInstall);
        super.onResume();
        if (fromInstall) {
            fromInstall = false;
            return;
        }
        callAssistActivityParcel("onResume", null, null);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        callAssistActivityParcel("onDestroy", null, null);
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.d(TAG, "onActivityResult: in resultCode= "+resultCode+",requestCode="+requestCode);
        fromInstall = true;
        callAssistActivityParcel("onActivityResult", new Class[]{int.class, int.class, Intent.class}, new Object[]{requestCode, resultCode, data});
    }

    private Object callAssistActivityParcel(String name, Class[] type, Object[] args) {

        Parcelable promp=assistActivityParcel;
        try {
            Class clazz = BwbxUI.getClass("main.AssistActivityParcel");
            Method method = clazz.getDeclaredMethod(name, type);
            method.setAccessible(true);
            return method.invoke(promp, args);
        } catch (Exception e) {
            Log.d(TAG, "no AssistActivityParcel");
            e.printStackTrace();
        }

        return null;
    }

}
