package com.excelliance.open.utils;

import android.content.Context;

import java.lang.reflect.Method;

/**
 * 调用lbmain模块里的函数
 */
public class MainUtil {

    private static final String TAG = "MainUtil";

    public static boolean uploadRecord(Context context) {
        Integer ret = (Integer) invoke("com.excelliance.lbsdk.main.LBSdkHelper", "uploadRecord",
                new Class[]{Context.class}, new Object[]{context});
        return 0 == ret.intValue();
    }


    /**
     * 调用lebianbase里的类的方法
     * @param className 类名
     * @param method 函数名
     * @param paramTypes 参数类型
     * @param params 参数
     * @return 函数返回值
     */
    static Object invoke(String className, String method, Class[] paramTypes, Object[] params) {
        try {
            Class<?> clazz = Class.forName(className);
            Method m = clazz.getDeclaredMethod(method, paramTypes);
            return m.invoke(null, params);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
