package com.excelliance.open;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.util.Log;

public class LBContextCompat {
    public static final String TAG = "LBContextCompat";
    public static final int VERSION_T = 33;
    public static final int RECEIVER_EXPORTED = 2;
    public static final int RECEIVER_NOT_EXPORTED = 4;
    public static final int RECEIVER_VISIBLE_TO_INSTANT_APPS = 1;
    public static void registerReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
        if (context != null && receiver != null && filter != null) {
            if (Build.VERSION.SDK_INT >= VERSION_T) {
                context.registerReceiver(receiver, filter, null, null, RECEIVER_NOT_EXPORTED);
            }else {
                context.registerReceiver(receiver, filter, null, null);
            }
        }
    }

    public static void unregisterReceiver(Context context, BroadcastReceiver receiver) {
        if (context != null && receiver != null) {
            try {
                context.unregisterReceiver(receiver);
            }catch (Exception e){
                Log.d(TAG, "unregister wrong");
            }
        }
    }
}
