package com.excelliance.open;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.CheckBox;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.view.Window;

import com.excelliance.lbui.R;

import java.lang.reflect.Field;

/**
 *
 * Create custom Dialog windows for your application
 * Custom dialogs rely on custom layouts wich allow you to
 * create and use your own look & feel.
 *
 */
public class CustomDialog extends Dialog {
    TextView mTextViewMessage = null;
    Button mNegativeButton = null;
    Button mPositiveButton = null;
    public CustomDialog(Context context, int theme) {
        super(context, theme);
    }

    public CustomDialog(Context context) {
        super(context);
    }

    public void setMessage(String message) {
        this.mTextViewMessage.setText(message);
    }
    public void seNegativeButtonText(String text) {
        this.mNegativeButton.setText(text);
    }
    public void setPositiveButtonClick(final DialogInterface.OnClickListener listener) {
        this.mPositiveButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                listener.onClick(CustomDialog.this, DialogInterface.BUTTON_POSITIVE);
            }
        });
    }

    /**
     * Helper class for creating a custom dialog
     */
    public static class Builder {

        private Context context;
        private String title;
        private String message;
        private String positiveButtonText;
        private String negativeButtonText;
        private View contentView;

        private CheckBox checkBox;
        private String checkBoxText;
        private boolean checked;
        private OnCheckedChangeListener checkBoxListener;

        private DialogInterface.OnClickListener
        positiveButtonClickListener,
        negativeButtonClickListener;

		public Builder(Context context) {
			this.context = context;
		}

        public Builder(Context context, Context topActivity) {
            this.context = new BaseActivity.LebianContext(topActivity,android.R.style.Theme,BwbxUI.getResources(context));
        }

        /**
         * Set the Dialog message from String
         * @return
         */
        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        /**
         * Set the Dialog message from resource
         * @param title
         * @return
         */
        public Builder setMessage(int message) {
            this.message = (String) context.getText(message);
            return this;
        }

        /**
         * Set the Dialog title from resource
         * @param title
         * @return
         */
        public Builder setTitle(int title) {
            this.title = (String) context.getText(title);
            return this;
        }

        /**
         * Set the Dialog title from String
         * @param title
         * @return
         */
        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        /**
         * Set a custom content view for the Dialog.
         * If a message is set, the contentView is not
         * added to the Dialog...
         * @param v
         * @return
         */
        public Builder setContentView(View v) {
            this.contentView = v;
            return this;
        }

        /**
         * Set the positive button resource and it's listener
         * @param positiveButtonText
         * @param listener
         * @return
         */
        public Builder setPositiveButton(int positiveButtonText,
                                         DialogInterface.OnClickListener listener) {
            this.positiveButtonText = (String) context
                                      .getText(positiveButtonText);
            this.positiveButtonClickListener = listener;
            return this;
        }

        /**
         * Set the positive button text and it's listener
         * @param positiveButtonText
         * @param listener
         * @return
         */
        public Builder setPositiveButton(String positiveButtonText,
                                         DialogInterface.OnClickListener listener) {
            this.positiveButtonText = positiveButtonText;
            this.positiveButtonClickListener = listener;
            return this;
        }

        /**
         * Set the negative button resource and it's listener
         * @param negativeButtonText
         * @param listener
         * @return
         */
        public Builder setNegativeButton(int negativeButtonText,
                                         DialogInterface.OnClickListener listener) {
            this.negativeButtonText = (String) context
                                      .getText(negativeButtonText);
            this.negativeButtonClickListener = listener;
            return this;
        }

        /**
         * Set the negative button text and it's listener
         * @param negativeButtonText
         * @param listener
         * @return
         */
        public Builder setNegativeButton(String negativeButtonText,
                                         DialogInterface.OnClickListener listener) {
            this.negativeButtonText = negativeButtonText;
            this.negativeButtonClickListener = listener;
            return this;
        }

        public Builder setCheckBox(String checkBoxText,boolean checked,
                                   OnCheckedChangeListener listener) {
            this.checkBoxText = checkBoxText;
            this.checked = checked;
            this.checkBoxListener = listener;
            return this;
        }
        public boolean getChecked() {
            if(this.checkBox != null) {
                return this.checkBox.isChecked();
            } else {
                return false;
            }
        }

        /**
         * Create the custom dialog
         */
        public CustomDialog create() {
            Resources res = BwbxUI.getResources(context);
            LayoutInflater inflater = (LayoutInflater) context
                                      .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            // instantiate the dialog with the custom Theme
            inflater = inflater.cloneInContext(context);
            try {
                Class inflateClass = Class.forName("android.view.LayoutInflater", false, context.getClassLoader());
                Field f1 = inflateClass.getDeclaredField("mFactory");
                f1.setAccessible(true);
                Field f2 = inflateClass.getDeclaredField("mFactory2");
                f2.setAccessible(true);
                f1.set(inflater,null);
                f2.set(inflater,null);
            } catch (Exception e) {
                e.printStackTrace();
            }
            String packageName = context.getPackageName();
            final CustomDialog dialog =new CustomDialog(context, R.style.lebian_dialog_theme);
			dialog.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
            View layout = inflater.inflate(R.layout.lebian_dialog, null);
            // set the header background
            LinearLayout headerLayout = (LinearLayout)layout.findViewById(R.id.lebian_dialog_header_layout);

            Drawable d = res.getDrawable(R.drawable.lebian_header);
            headerLayout.setBackgroundDrawable(d);
            // set the center background
            LinearLayout contentLayout = (LinearLayout)layout.findViewById(R.id.lebian_content);

            d = res.getDrawable(R.drawable.lebian_center);
            contentLayout.setBackgroundDrawable(d);
            // set the dialog title
            TextView titleTextView = (TextView) layout.findViewById(R.id.lebian_title);
            titleTextView.setText(title);
            // set the footer background
            LinearLayout footerLayout = (LinearLayout)layout.findViewById(R.id.lebian_dialog_footer_layout);

            d = res.getDrawable(R.drawable.lebian_footer);
            footerLayout.setBackgroundDrawable(d);
            // set the confirm button
            if (positiveButtonClickListener != null) {
                View v = layout.findViewById(R.id.lebian_positiveButton);
                StateListDrawable sdrawable = new StateListDrawable();
                Drawable pressed = res.getDrawable(R.drawable.lebian_btn_positive_pressed);
                Drawable normal = res.getDrawable(R.drawable.lebian_btn_positive_normal);
                sdrawable.addState(new int[]{android.R.attr.state_pressed}, pressed);
                sdrawable.addState(new int[]{android.R.attr.state_focused}, pressed);
                sdrawable.addState(new int[]{}, normal);
                v.setBackgroundDrawable(sdrawable);
                if (positiveButtonText != null) {
                    if ( v instanceof Button){
                        dialog.mPositiveButton = (Button) v;
                        ((Button) v).setText(positiveButtonText);
                    }
                    else if( v instanceof TextView){
                        ((TextView) v).setText(positiveButtonText);
                    }
                }
                v.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View v) {
                        positiveButtonClickListener.onClick(
                            dialog,
                            DialogInterface.BUTTON_POSITIVE);
                    }
                });
                
            } else {
                View v = layout.findViewById(R.id.lebian_positiveButton);
                // if no confirm button just set the visibility to GONE
                v.setVisibility(
                    View.GONE);
            }
            // set the cancel button
            if (negativeButtonClickListener != null) {
                View v = layout.findViewById(R.id.lebian_negativeButton);
                StateListDrawable sdrawable = new StateListDrawable();
                Drawable pressed = res.getDrawable(R.drawable.lebian_btn_negative_pressed);
                Drawable normal = res.getDrawable(R.drawable.lebian_btn_negative_normal);
                sdrawable.addState(new int[]{android.R.attr.state_pressed}, pressed);
                sdrawable.addState(new int[]{android.R.attr.state_focused}, pressed);
                sdrawable.addState(new int[]{}, normal);
                v.setBackgroundDrawable(sdrawable);
                if (negativeButtonText != null) {
                    if ( v instanceof Button){
                        dialog.mNegativeButton = (Button) v;
                        dialog.mNegativeButton.setText(negativeButtonText);
                    }
                    else if( v instanceof TextView){
                        ((TextView) v).setText(negativeButtonText);
                    }
                }
                v.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View v) {
                        negativeButtonClickListener.onClick(
                            dialog,
                            DialogInterface.BUTTON_NEGATIVE);
                    }
                });
                
            } else {

                // if no confirm button just set the visibility to GONE
                View v = layout.findViewById(R.id.lebian_negativeButton);
                v.setVisibility(View.GONE);
            }
            // set the content message
            if (message != null) {
                TextView textView = (TextView)layout.findViewById(R.id.lebian_message);
                dialog.mTextViewMessage = textView;
                dialog.mTextViewMessage.setText(message);
            } else if (contentView != null) {
                // if no message set
                // add the contentView to the dialog body
                contentLayout.removeAllViews();
                contentLayout.addView(contentView,
                         new LayoutParams(
                             LayoutParams.WRAP_CONTENT,
                             LayoutParams.WRAP_CONTENT));
            }

            if(checkBoxText != null) {
                LinearLayout checkBoxLayout = (LinearLayout)layout.findViewById(R.id.lebian_check_box_layout);
                d = res.getDrawable(R.drawable.lebian_down_center);
                checkBoxLayout.setBackgroundDrawable(d);
                checkBoxLayout.setVisibility(View.VISIBLE);
                checkBox = (CheckBox)layout.findViewById(R.id.lebian_check_box);
                //checkBox.setButtonDrawable(null);
                checkBox.setText(checkBoxText);
                StateListDrawable sdrawable = new StateListDrawable();
                Drawable checked = res.getDrawable(R.drawable.lebian_checkbox_bg_checked);
                Drawable normal = res.getDrawable(R.drawable.lebian_checkbox_bg_normal);
                sdrawable.addState(new int[]{android.R.attr.state_checked}, checked);
                sdrawable.addState(new int[]{-android.R.attr.state_checked}, normal);
                sdrawable.addState(new int[]{}, normal);
                checkBox.setButtonDrawable(sdrawable);

                if(checkBoxListener != null) {
                    checkBox.setOnCheckedChangeListener(checkBoxListener);
                }
                checkBox.setChecked(this.checked);
            }

            dialog.setContentView(layout);
            return dialog;
        }
    }
}


